/********************************************************************
        Actel ProASIC3 Verilog Library
        NAME: proasic3.v
        DATE: September 4, 2007
*********************************************************************/

`timescale 1 ns / 100 ps

//----------------------------------------------------------------------
//---             VERILOG LIBRRAY PRIMITIVE SECTION                     
//----------------------------------------------------------------------

 //---------------------------------------------------------------------
 // primitibe module (Dffpr) state table definition
 // FUNCTION : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
 //            ASYNCHRONOUS SET AND CLEAR. CLR PRIORITY WHEN BOTH
 //            SET AND CLEAR ARE LOW ( Q OUTPUT UDP ).
 //            Enable active low.

 //----------------------------------------------------------------------
primitive Dffpr (Q, D, CLK, CLR, PRE, E, NOTIFIER_REG);
  output Q;
  input  NOTIFIER_REG;
  input  D, CLK, E, CLR, PRE;
  reg Q;

	table

	//  D   CLK   CLR  PRE   E  NOTIFIER_REG  :   Qt  :  Qt+1

	    1   (01)    1   1    0      ?         :   ?   :   1;  // clocked data
	    0   (01)    1   1    0      ?         :   ?   :   0;  // clocked data
	    1   (01)    1   1    x      ?         :   1   :   1;  // clocked data
	    0   (01)    1   1    x      ?         :   0   :   0; 
	    0   (01)    1   1    x      ?         :   1   :   x;
	    1   (01)    1   1    x      ?         :   0   :   x;
	    0   (01)    x   1    0      ?         :   ?   :   0;  // pessimism
	    1   (01)    1   x    0      ?         :   ?   :   1;  // pessimism
	    ?    ?      1   x    ?      ?         :   1   :   1;  // pessimism
	    0    ?      1   x    ?      ?         :   x   :   x;  // pessimism
	    ?    ?      1   x    ?      ?         :   0   :   x;
	    ?    ?      x   x    ?      ?         :   ?   :   x;
	    ?    ?      x   0    ?      ?         :   ?   :   x;
	    ?    ?      x   1    ?      ?         :   0   :   0;
	    ?    ?      x   1    ?      ?         :   1   :   x;
	    ?    ?      0   ?    ?      ?         :   ?   :   0;
	    ?    ?      1   0    ?      ?         :   ?   :   1;
	    1   (x1)    1   1    0      ?         :   1   :   1;  // reducing pessimism
	    0   (x1)    1   1    0      ?         :   0   :   0;
	    1   (0x)    1   1    0      ?         :   1   :   1;
     0   (0x)    1   1    0      ?         :   0   :   0;
	    1   (x1)    1   1    x      ?         :   1   :   1;  // reducing pessimism
	    0   (x1)    1   1    x      ?         :   0   :   0;
	    1   (0x)    1   1    x      ?         :   1   :   1;
	    0   (0x)    1   1    x      ?         :   0   :   0;
	    ?  (?1)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	    ?  (0x)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	    ?   ?       ?   ?    *      ?         :   ?   :   -;
	    ?   (?0)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	    ?   (1x)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	    *    ?      ?   ?    ?      ?         :   ?   :   -;  // ignore data edges
	    ?   ?     (?1)  ?    ?      ?         :   ?   :   -;  // ignore the edges on
	    ?   ?       ?  (?1)  ?      ?         :   ?   :   -;  //       set and clear
	    ?   ?       ?   ?    ?      *         :   ?   :   x;

	endtable
 endprimitive


 //---------------------------------------------------------------------
 // primitibe module (Dffpf) logic table definition
 // FUNCTION : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
 //            ASYNCHRONOUS SET AND CLEAR. CLR PRIORITY WHEN BOTH
 //            SET AND CLEAR ARE LOW ( Q OUTPUT UDP ).
 //            Enable active low.

 //----------------------------------------------------------------------
primitive Dffpf (Q, D, CLK, CLR, PRE, E, NOTIFIER_REG);
  output Q;
  input  NOTIFIER_REG;
  input  D, CLK, E, CLR, PRE;
  reg Q;

 table

//    D   CLK     CLR PRE  E  NOTIFIER_REG  :   Qt  :  Qt+1	
	     1   (10)    1   1    0      ?         :   ?   :   1;  // clocked data
	     0   (10)    1   1    0      ?         :   ?   :   0;  // clocked data
	     1   (10)    1   1    x      ?         :   1   :   1;  // clocked data
	     0   (10)    1   1    x      ?         :   0   :   0;
	     0   (10)    1   x    x      ?         :   1   :   1;
	     0   (10)    1   1    x      ?         :   1   :   x;
	     1   (10)    1   1    x      ?         :   0   :   x;
	     0   (10)    1   x    0      ?         :   1   :   1;
	     0   (10)    x   1    0      ?         :   ?   :   0;
	     1   (10)    1   ?    0      ?         :   ?   :   1;  // pessimism
	     1    ?      1   x    0      ?         :   1   :   1;  // pessimism
	     ?    ?      1   x    ?      ?         :   0   :   x;
	     0    1      1   x    0      ?         :   1   :   1;  // pessimism
	     0    x      1 (?x)   0      ?         :   1   :   1;  // pessimism
	     0    ?      1 (?x)   0      ?         :   1   :   1;  // baoxian
	     0    ?      x   1    ?      ?         :   0   :   0;
	     0    ?      x   0    ?      ?         :   ?   :   x;
	     0    ?      x   1    ?      ?         :   1   :   x;
	     x    1      1   x    0      ?         :   1   :   1;  // pessimism
	     x    x      1 (?x)   0      ?         :   1   :   1;  // pessimism
	     x    0      1   x    0      ?         :   1   :   1;  // pessimism
	     1    ?      1   x    x      ?         :   1   :   1;  // pessimism
	     0    1      1   x    x      ?         :   1   :   1;  // pessimism
	     0    x      1 (?x)   x      ?         :   1   :   1;  // pessimism
	     0    0      1 (?x)   x      ?         :   1   :   1;  // pessimism
	     x    1      1   x    x      ?         :   1   :   1;  // pessimism
	     x    ?      1   x    x      ?         :   1   :   1;  // pessimism
	     1    0      x   1    0      ?         :   0   :   0;  // pessimism
	     1    x    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     1    1    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     x    0      x   1    0      ?         :   0   :   0;  // pessimism
	     x    x    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     x    1    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     1    0      x   1    x      ?         :   0   :   0;  // pessimism
	     1    x    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     1    1    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     x    0      x   1    x      ?         :   0   :   0;  // pessimism
	     x    x    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     x    1    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     1   (1x)    1   1    0      ?         :   1   :   1;  // reducing pessimism
	     0   (1x)    1   1    0      ?         :   0   :   0;
	     1   (x0)    1   1    0      ?         :   1   :   1;
	     0   (x0)    1   1    0      ?         :   0   :   0;
	     1   (1x)    1   1    x      ?         :   1   :   1;  // reducing pessimism
	     0   (1x)    1   1    x      ?         :   0   :   0;
	     1   (x0)    1   1    x      ?         :   1   :   1;
	     0   (x0)    1   1    x      ?         :   0   :   0;
	     ?   ?       0   1    ?      ?         :   ?   :   0;  // asynchronous clear
	     ?   ?       1   0    ?      ?         :   ?   :   1;  // asynchronous set
	     ?  (?0)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	     ?  (1x)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	     ?   (?0)    x   1    1      ?         :   0   :   0;  // chip is not enabled pessimism with reset
	     ?   (1x)    x   1    1      ?         :   0   :   0;  // chip is not enabled pessimism with reset
	     ?    ?    (?x)  1    1      ?         :   0   :   0;  // chip is not enabled pessimism with reset
	     ?   (?0)    1   x    1      ?         :   1   :   1;  // chip is not enabled pessimism with reset
	     ?   (1x)    1   x    1      ?         :   1   :   1;  // chip is not enabled pessimism with reset
	     ?    ?      1  (?x)  1      ?         :   1   :   1;  // chip is not enabled pessimism with reset
	     ?   ?       ?   ?    *      ?         :   ?   :   -;
	     ?   (?1)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	     ?   (0x)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	     *    ?      ?   ?    ?      ?         :   ?   :   -;  // ignore data edges
	     ?   ?     (?1)  ?    ?      ?         :   ?   :   -;  // ignore the edges on
	     ?   ?       ?  (?1)  ?      ?         :   ?   :   -;  //       set and clear
	     ?   ?       0   0    ?      ?         :   ?   :   0; // CLR Priority (added 0n 11/12/97)
	     ?   ?       0   x    ?      ?         :   ?   :   0; // CLR Priority (added 0n 11/12/97)
	     ?   ?       ?   ?    ?      *         :   ?   :   x;
	endtable
 endprimitive

//--------------------------------------------------------------------
//-                    cell  UFPRB.v                                  -
//--------------------------------------------------------------------

primitive UFPRB (Q, D, CP, RB, NOTIFIER_REG);

    output Q;
    input  NOTIFIER_REG,
           D, CP, RB;
    reg    Q;

// FUNCTION : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
//            ASYNCHRONOUS CLEAR ( Q OUTPUT UDP ).

    table
    //  D   CP      RB     NOTIFIER_REG  :   Qt  :   Qt+1

        1   (01)    1         ?          :   ?   :   1;  // clocked data
        0   (01)    1         ?          :   ?   :   0;

        0   (01)    x         ?          :   ?   :   0;  // pessimism
        0    ?      x         ?          :   0   :   0;  // pessimism

        1    0      x         ?          :   0   :   0;  // pessimism
        1    x    (?x)        ?          :   0   :   0;  // pessimism
        1    1    (?x)        ?          :   0   :   0;  // pessimism
        x    0      x         ?          :   0   :   0;  // pessimism
        x    x    (?x)        ?          :   0   :   0;  // pessimism
        x    1    (?x)        ?          :   0   :   0;  // pessimism
        1   (x1)    1         ?          :   1   :   1;  // reducing pessimism
        0   (x1)    1         ?          :   0   :   0;
        1   (0x)    1         ?          :   1   :   1;
        0   (0x)    1         ?          :   0   :   0;
        ?   ?       0         ?          :   ?   :   0;  // asynchronous clear
        ?   (?0)    ?         ?          :   ?   :   -;  // ignore falling clock
        ?   (1x)    ?         ?          :   ?   :   -;  // ignore falling clock
        *    ?      ?         ?          :   ?   :   -;  // ignore the edges on data
        ?    ?    (?1)        ?          :   ?   :   -;  // ignore the edges on clear
        ?    ?      ?         *          :   ?   :   x;
    endtable
endprimitive

//--------------------------------------------------------------------
//-                    cell  UFNRB.v                                  -
//--------------------------------------------------------------------
primitive UFNRB (Q, D, CP, RB, NOTIFIER_REG);
    output Q;
    input  NOTIFIER_REG,
           D, CP, RB;
    reg    Q;
// FUNCTION : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
//            ASYNCHRONOUS CLEAR ( Q OUTPUT UDP ).
    table
    //  D   CP      RB     NOTIFIER_REG  :   Qt  :   Qt+1
        1   (10)    1         ?          :   ?   :   1;  // clocked data
        0   (10)    1         ?          :   ?   :   0;
        0   (10)    x         ?          :   ?   :   0;  // pessimism
        0    ?      x         ?          :   0   :   0;  // pessimism
        1    1      x         ?          :   0   :   0;  // pessimism
        1    x    (?x)        ?          :   0   :   0;  // pessimism
        1    0    (?x)        ?          :   0   :   0;  // pessimism
        x    1      x         ?          :   0   :   0;  // pessimism
        x    x    (?x)        ?          :   0   :   0;  // pessimism
        x    0    (?x)        ?          :   0   :   0;  // pessimism
        1   (1x)    1         ?          :   1   :   1;  // reducing pessimism
        0   (1x)    1         ?          :   0   :   0;
        1   (x0)    1         ?          :   1   :   1;
        0   (x0)    1         ?          :   0   :   0;
        ?   ?       0         ?          :   ?   :   0;  // asynchronous clear
        ?   (?1)    ?         ?          :   ?   :   -;  // ignore falling clock
        ?   (0x)    ?         ?          :   ?   :   -;  // ignore falling clock
        *    ?      ?         ?          :   ?   :   -;  // ignore the edges on data
        ?    ?    (?1)        ?          :   ?   :   -;  // ignore the edges on clear
        ?    ?      ?         *          :   ?   :   x;
    endtable
endprimitive

//------------------------------------------------------------------------
// primitive DL2C_UDP functional description
// FUNCTION : NEGATIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE HIGH
//            ASYNCHRONOUS SET AND RESET.
//-------------------------------------------------------------------------

primitive DL2C_UDP (q, d, g, c, p, NOTIFIER_REG);

 output q;
 input  d,              // DATA
        g,              // CLOCK
        c,              // CLEAR ACTIVE HIGH
        p,              // SET ACTIVE HIGH
        NOTIFIER_REG;

 reg q;

    table
    //  D     G     C     P  NOTIFIER_REG  :   Qt  :   Qt+1
        ?     ?     1     ?     ?          :   ?   :   0;  // active low clear
        ?     ?     0     1     ?          :   ?   :   1;  // active high preset

        ?     1     0     0     ?          :   ?   :   -;  // latch
        0     0     0     0     ?          :   ?   :   0;  // transparent

        0     0     x     0     ?          :   ?   :   0;  // CLR==x
        ?     1     x     0     ?          :   0   :   0;  // CLR==x
        0     x     ?     0     ?          :   0   :   0;  // CLR,G==x

        1     x     0     ?     ?          :   1   :   1;  // PRE==x/?,G==x
        1     0     0     ?     ?          :   ?   :   1;  // PRE==x/?
        ?     1     0     x     ?          :   1   :   1;  // PRE==x
    endtable


endprimitive


//--------------------------------------------------------------------------
// primitive DLE3B_UDP
// FUNCTION : D LATCH WITH DUAL CLOCK INPUTS ACTIVE HIGH ASYNCHRONOUS PRESET.
//            TWO CLOCKS: E G
//-------------------------------------------------------------------------

primitive DLE3B_UDP (q, d, g, e, p, NOTIFIER_REG);

 output q;
 input  d,              // DATA
        g,              // CLOCK
        e,              // CLEAR ACTIVE HIGH
        p,              // SET ACTIVE HIGH
        NOTIFIER_REG;

 reg    q;

    table
    //  D     G     E     P  NOTIFIER_REG  :   Qt  :   Qt+1
        ?     ?     ?     1     ?          :   ?   :   1;  // active high preset

        ?     1     ?     0     ?          :   ?   :   -;  // latch
        ?     ?     1     0     ?          :   ?   :   -;  // latch

        1     0     0     0     ?          :   ?   :   1;  // transparent
        0     0     0     0     ?          :   ?   :   0;  // transparent

        1     x     ?     0     ?          :   1   :   1;  // o/p mux pessimism
        1     ?     x     0     ?          :   1   :   1;  // o/p mux pessimism
        0     x     ?     0     ?          :   0   :   0;  // o/p mux pessimism
        0     ?     x     0     ?          :   0   :   0;  // o/p mux pessimism

        1     0     0     x     ?          :   ?   :   1;  // PRE==x
        ?     1     ?     x     ?          :   1   :   1;  // PRE==x
        ?     ?     1     x     ?          :   1   :   1;  // PRE==x
        1     0     x     x     ?          :   1   :   1;  // PRE==x
        1     x     0     x     ?          :   1   :   1;  // PRE==x
        1     x     x     x     ?          :   1   :   1;  // PRE==x
    endtable

endprimitive


//--------------------------------------------------------------------------
// primitive DLE2B_UDP
// FUNCTION : D LATCH WITH DUAL CLOCK INPUTS ACTIVE HIGH ASYNCHRONOUS CLEAR.
//            TWO CLOCKS: E G
//-------------------------------------------------------------------------

primitive DLE2B_UDP (q, d, e, g, c, NOTIFIER_REG);

 output q;
 input  d,              // DATA
        e,              // CLOCK
        g,              // CLOCK
        c,              // CLEAR ACTIVE HIGH
        NOTIFIER_REG;

 reg    q;

    table
    //  D     E     G     C  NOTIFIER_REG  :   Qt  :   Qt+1
        ?     ?     ?     0     ?          :   ?   :   0;  // active low clear

        ?     ?     1     1     ?          :   ?   :   -;  // latch
        ?     1     ?     1     ?          :   ?   :   -;  // latch

        1     0     0     1     ?          :   ?   :   1;  // transparent
        0     0     0     1     ?          :   ?   :   0;  // transparent

        0     ?     ?     1     ?          :   0   :   0;  // o/p mux pessimism
        1     ?     ?     1     ?          :   1   :   1;  // o/p mux pessimism

        0     ?     ?     x     ?          :   0   :   0;  // CLR==x, o/p mux pessimism
        ?     ?     1     x     ?          :   0   :   0;  // PRE==x, o/p mux pessimism, latch
        ?     1     ?     x     ?          :   0   :   0;  // PRE==x, o/p mux pessimism, latch
        0     0     0     x     ?          :   ?   :   0;  // PRE==x, o/p mux pessimism
    endtable

endprimitive


//--------------------------------------------------------------------
//-                 primitive  JKFFF  -- falling edge                -
//--------------------------------------------------------------------

primitive JKFFF (Q, J, K, CP, RB, SB, NOTIFIER_REG);
    output Q;
    reg    Q; 
    input  NOTIFIER_REG,
           J,K,
            CP,                                  // Clock.
            RB,                                  // Clear input
            SB;                                  // Set input
// FUNCTION :NEGATIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW
//           ASYNCHRONOUS CLEAR AND  SET
//           OUTPUT GOES TO X WHEN BOTH CLEAR AND SET ARE ACTIVE
    table
      // J   K   CP  RB   SB       NOTIFIER_REG  : Qtn : Qtn+1
         0   1  (10) 1    1           ?          :  ?  :   - ;    // Output retains the
         0   0  (10) 1    1           ?          :  ?  :   0 ;    // Clocked J and K.
         0   0  (10) x    1           ?          :  ?  :   0 ;    // pessimism
         ?   ?   ?   x    1           ?          :  0  :   0 ;    // pessimism
         1   1  (10) 1    1           ?          :  ?  :   1 ;
         1   1  (10) 1    x           ?          :  ?  :   1 ;    // pessimism
         ?   ?   ?   1    x           ?          :  1  :   1 ;    // pessimis
         1   0  (10) 1    1           ?          :  0  :   1 ;    // Clocked toggle.
         1   0  (10) 1    1           ?          :  1  :   0 ;
         ?   0  (10) x    1           ?          :  1  :   0 ;    //pessimism
         1   ?  (10) 1    x           ?          :  0  :   1 ;
         0   1  (1x) 1    1           ?          :  ?  :   - ;    //possible clocked JK
         0   0  (1x) 1    1           ?          :  0  :   0 ;
         1   1  (1x) 1    1           ?          :  1  :   1 ;
         0   1  (x0) 1    1           ?          :  ?  :   - ;
         0   0  (x0) 1    1           ?          :  0  :   0 ;
         1   1  (x0) 1    1           ?          :  1  :   1 ;
         *   ?   ?   1    1           ?          :  ?  :   - ;    // Insensitive to
         ?   *   ?   1    1           ?          :  ?  :   - ;    // transitions on J and K
         ?   ?   ?   0    1           ?          :  ?  :   0 ;    // Clear
         ?   ?   ?   1    0           ?          :  ?  :   1 ;    // Set.
         ?   ?   ?   0    0           ?          :  ?  :   x ;    // ILLEGAL
         x   1   f   1    1           ?          :  1  :   1 ;
         x   0   f   1    1           ?          :  1  :   0 ;
         0   x   f   1    1           ?          :  0  :   0 ;
         1   x   f   1    1           ?          :  0  :   1 ;
         x   1 (1x)  1    1           ?          :  1  :   1 ;    //possible clocked with
         0   x (1x)  1    1           ?          :  0  :   0 ;    //possible J & K
         x   1 (x0)  1    1           ?          :  1  :   1 ;
         0   x (x0)  1    1           ?          :  0  :   0 ;
         ?   ? (?1)  ?    ?           ?          :  ?  :   - ;
         ?   ? (0x)  ?    ?           ?          :  ?  :   - ;
         ?   ?   ? (?1)   1           ?          :  ?  :   - ;    //ignore changes on set and
         ?   ?   ?   1  (?1)          ?          :  ?  :   - ;    //reset.
         ?   ?   ?   ?    ?           *          :  ?  :   x ;
    endtable
endprimitive

//--------------------------------------------------------------------
//-                   primitive  JKFFR                                -
//--------------------------------------------------------------------
primitive JKFFR (Q, J, K, CP, RB, SB, NOTIFIER_REG);
    output Q;
    reg    Q; 
    input  NOTIFIER_REG,
           J,K,
           CP,                                  // Clock.
           RB,                                  // Clear input
           SB;                                  // Set input
// FUNCTION :POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW
//           ASYNCHRONOUS CLEAR AND  SET
//           OUTPUT GOES TO x WHEN BOTH CLEAR AND SET ARE ACTIVE
    table
      // J   K  CP  RB   SB        NOTIFIER_REG  : Qtn : Qtn+1
         0   1  (01) 1    1           ?          :  ?  :   - ;    // Output retains the
         0   0  (01) 1    1           ?          :  ?  :   0 ;    // Clocked J and K.
         0   0  (01) x    1           ?          :  ?  :   0 ;    // pessimism
         ?   ?   ?   x    1           ?          :  0  :   0 ;    // pessimism
         1   1  (01) 1    1           ?          :  ?  :   1 ;
         1   1  (01) 1    x           ?          :  ?  :   1 ;    // pessimism
         ?   ?   ?   1    x           ?          :  1  :   1 ;    // pessimism
         1   0  (01) 1    1           ?          :  0  :   1 ;    // Clocked toggle.
         1   0  (01) 1    1           ?          :  1  :   0 ;
         ?   0  (01) x    1           ?          :  1  :   0 ;     //pessimism
         1   ?  (01) 1    x           ?          :  0  :   1 ;
         0   1  (x1) 1    1           ?          :  ?  :   - ;   //possible clocked JK
         0   0  (x1) 1    1           ?          :  0  :   0 ;
         1   1  (x1) 1    1           ?          :  1  :   1 ;
         0   1  (0x) 1    1           ?          :  ?  :   - ;
         0   0  (0x) 1    1           ?          :  0  :   0 ;
         1   1  (0x) 1    1           ?          :  1  :   1 ;
         *   ?   ?   1    1           ?          :  ?  :   - ;    // Insensitive to
         ?   *   ?   1    1           ?          :  ?  :   - ;    // transitions on J and K
         ?   ?   ?   0    1           ?          :  ?  :   0 ;    // Clear
         ?   ?   ?   1    0           ?          :  ?  :   1 ;    // Set.
         ?   ?   ?   0    0           ?          :  ?  :   x ;    // ILLEGAL
         x   1   r   1    1           ?          :  1  :   1 ;
         x   0   r   1    1           ?          :  1  :   0 ;
         0   x   r   1    1           ?          :  0  :   0 ;
         1   x   r   1    1           ?          :  0  :   1 ;
         x   1 (x1)  1    1           ?          :  1  :   1 ;        //possible clocked with
         0   x (x1)  1    1           ?          :  0  :   0 ;        //possible J & K
         x   1 (0x)  1    1           ?          :  1  :   1 ;
         0   x (0x)  1    1           ?          :  0  :   0 ;
         ?   ? (?0)  1    1           ?          :  ?  :   - ;    //ignore falling clock.
         ?   ? (1x)  1    1           ?          :  ?  :   - ;
         ?   ?   ? (?1)   1           ?          :  ?  :   - ;    //ignore changes on set and
         ?   ?   ?   1  (?1)          ?          :  ?  :   - ;    //reset.
         ?   ?   ?   ?    ?           *          :  ?  :   x ;
    endtable
endprimitive
 // --------------------------------------------------------------------
 // 2-1 MUX  primitive   
 // FUNCTION : when select signal S= 1, A will be selected, S= 0, B will 
 //            be selected; when S=X, if A=B, A will be selected, if A!=B,
 //            X will be the output!
 // --------------------------------------------------------------------
primitive UDP_MUX2 (Q, A, B, SL);
output Q;
input A, B, SL;

// FUNCTION :  TWO TO ONE MULTIPLEXER

    table
    //  A   B   SL  :   Q
        0   0   ?   :   0 ;
        1   1   ?   :   1 ;

        0   ?   1   :   0 ;
        1   ?   1   :   1 ;

        ?   0   0   :   0 ;
        ?   1   0   :   1 ;

    endtable
endprimitive

primitive UDPN_MUX2 (Q, A, B, SL);
output Q;
input A, B, SL;

// FUNCTION :  TWO TO ONE MULTIPLEXER

    table
    //  A   B   SL  :   Q
        0   0   ?   :   1 ;
        1   1   ?   :   0 ;

        0   ?   1   :   1 ;
        1   ?   1   :   0 ;

        ?   0   0   :   1 ;
        ?   1   0   :   0 ;

    endtable
endprimitive


//---------------  END OF VERILOG PRIMITIVE SECTION --------------------

primitive CMA9_primitive (Y, D0,DB, D3,S01,S11);
output Y;
input D0,DB, D3,S01,S11;


	table
	// D0   DB   D3   S01  S11 :       Y
	   ?    0    ?    0    ?  :       1;
	   ?    1    ?    ?    1  :       0;
	   ?    0    0    1    ?  :       0;
	   1    1    ?    ?    0  :       1;
	   1    ?    1    ?    0  :       1;
	   ?    0    1    ?    ?  :       1;
	   0    1    ?    ?    ?  :       0;
	   0    ?    0    1    ?  :       0;
	   1    ?    ?    0    0  :       1;
	   ?    ?    0    1    1  :       0;

	endtable
endprimitive

primitive CMAF_primitive (Y, D0, D2,  D3, DB, S01, S11);
output Y;
input D0, D2,  D3, DB, S01, S11;


	table
	// D0   D2   D3   DB   S01  S11       Y
	   0    0    0     ?    ?    ? :    0;
	   1    1    1     ?    ?    ? :    1;
	   0    0    ?     ?    0    0 :    0;
	   1    1    ?     ?    0    0 :    1;
	   0    0    ?     1    ?    ? :    0;
	   1    1    ?     1    ?    ? :    1;
	   0    0    ?     ?    0    ? :    0;
	   1    1    ?     ?    0    ? :    1;
	   ?    0    0     ?    1    1 :    0;
	   ?    1    1     ?    1    1 :    1;
	   ?    0    0     0    ?    ? :    0;
	   ?    1    1     0    ?    ? :    1;
	   ?    0    0     ?    ?    1 :    0;
	   ?    1    1     ?    ?    1 :    1;
	   0    ?    0     ?    1    0 :    0;
	   1    ?    1     ?    1    0 :    1;
	   ?    0    ?     0    0    ? :    0;
	   ?    1    ?     0    0    ? :    1;
	   ?    0    ?     1    ?    1 :    0;
	   ?    1    ?     1    ?    1 :    1;
	   ?    0    ?     ?    0    1 :    0;
	   ?    1    ?     ?    0    1 :    1;
	   ?    ?    0     0    1    ? :    0;
	   ?    ?    1     0    1    ? :    1;
	   0    ?    ?     1    ?    0 :    0;
	   1    ?    ?     1    ?    0 :     1;

	endtable
endprimitive

primitive CMB7_primitive (Y, D0, D1, D2, DB, S00, S01, S11);
output Y;
input D0, D1, D2, DB, S00, S01, S11;


   table
	//D0   D1   D2   DB   S00  S01  S11          Y
	  0    0    0    1    ?    ?    ?  :       0;
	  ?    ?    1    0    ?    ?    ?  :      1;
	  ?    0    ?    1    1    1    0  :      0;
	  ?    1    ?    ?    1    1    0  :      1;
	  0    ?    ?    1    0    ?    0  :      0;
	  0    ?    ?    1    ?    0    0  :      0;
	  1    ?    ?    1    0    ?    0  :      1;
	  1    ?    ?    1    ?    0    0  :      1;
	  ?    ?    ?    1    1    1    1  :      0;
	  ?    ?    ?    0    1    1    ?  :      1;
	  ?    ?    0    0    0    ?    ?  :      0;
	  ?    ?    0    0    ?    0    ?  :      0;
	  ?    ?    0    ?    0    ?    1  :      0;
	  ?    ?    0    ?    ?    0    1  :      0;
	  0    ?    0    ?    0    ?    ?  :      0;
	  0    ?    0    ?    ?    0    ?  :      0;
	  1    ?    1    ?    0    ?    ?  :      1;
	  1    ?    1    ?    ?    0    ?  :      1;
	  ?    ?    1    ?    0    ?    1  :      1;
	  ?    ?    1    ?    ?    0    1  :      1;
	  ?    0    ?    1    1    1    ?  :      0;
	  0    0    ?    1    ?    ?    0  :      0;
	  1    1    ?    1    ?    ?    0  :      1;
	  ?    ?    0    1    ?    ?    1  :      0;
	  1    1    1    ?    ?    ?    0  :      1;

	endtable
endprimitive

primitive CMBB_primitive (Y, D0,D1,DB,D3,S00,S01,S11);
output Y;
input D0,D1,DB,D3,S00,S01,S11;


	table
// D0   D1   DB   D3   S00  S01  S11          Y
	0    0    1    0    ?    ?    ? :        0;
	?    ?    0    1    ?    ?    ? :       1;
	?    ?    0    ?    ?    0    ? :       1;
	?    ?    1    ?    ?    0    1 :       0;
	?    ?    0    ?    0    ?    ? :       1;
	?    ?    1    ?    0    ?    1 :       0;
	0    ?    1    ?    ?    0    0 :       0;
	1    ?    ?    ?    ?    0    0 :       1;
	0    ?    1    ?    0    ?    0 :       0;
	1    ?    ?    ?    0    ?    0 :       1;
	?    0    1    ?    1    1    0 :       0;
	?    1    1    ?    1    1    0 :       1;
	?    ?    ?    0    1    1    1 :       0;
	?    ?    ?    1    1    1    1 :       1;
	?    ?    0    0    1    1    ? :       0;
	?    ?    1    0    ?    ?    1 :       0;
	?    0    ?    0    1    1    ? :       0;
	?    1    ?    1    1    1    ? :       1;
	0    ?    1    ?    0    ?    ? :       0;
	0    0    1    ?    ?    ?    0 :       0;
	1    1    1    ?    ?    ?    0 :       1;
	0    ?    1    ?    ?    0    ? :       0;
	1    1    ?    1    ?    ?    0 :       1;

	endtable
endprimitive

primitive CMEA_primitive (Y, DB,D1,D3,S01,S10,S11);
output Y;
input DB,D1,D3,S01,S10,S11;


	table
// DB   D1   D3   S01  S10  S11          Y
	1     ?    ?    ?   ?    ? :       0;
	0     1    1    ?   ?    ? :       1;
	0     0    ?    1   0    0 :       0;
	0     1    ?    ?   0    0 :       1;
	0     ?    0    1   1    ? :       0;
	0     ?    0    1   ?    1 :       0;
	0     ?    ?    0   ?    ? :       1;
	?     0    0    1   ?    ? :       0;
	0     ?    1    ?   1    ? :       1;
	0     ?    1    ?   ?    1 :       1;

   endtable
endprimitive

primitive CMEB_primitive (Y,D0,D1,DB,D3,S01,S10,S11);
output Y;
input D0,D1,DB,D3,S01,S10,S11;


   table
	// D0   D1   DB   D3   S01  S10  S11          Y
	0   0   1   0   ?   ?   ? :        0;
	1   1   0   1   ?   ?   ? :       1;
	0   ?   ?   ?   0   0   0 :       0;
	1   ?   ?   ?   0   0   0 :       1;
	0   ?   1   ?   ?   0   0 :       0;
	1   ?   1   ?   ?   0   0 :       1;
	?   ?   0   1   1   1   ? :       1;
	?   ?   0   1   1   ?   1 :       1;
	?   0   0   ?   1   0   0 :       0;
	?   1   0   ?   1   0   0 :       1;
	?   ?   ?   0   1   1   ? :       0;
	?   ?   ?   0   1   ?   1 :       0;
	?   ?   1   ?   ?   1   ? :       0;
	?   ?   1   ?   ?   ?   1 :       0;
	?   ?   0   ?   0   1   ? :       1;
	?   0   0   0   1   ?   ? :       0;
	?   1   0   1   1   ?   ? :       1;
	0   0   ?   ?   ?   0   0 :       0;
	1   1   ?   ?   ?   0   0 :       1;
	0   ?   1   ?   ?   ?   ? :       0;
	1   ?   0   ?   0   ?   ? :       1;
	?   ?   0   1   ?   1   ? :       1;
	?   ?   0   1   ?   ?   1 :       1;
	?   ?   0   ?   0   ?   1 :       1;
	0   0   ?   0   1   ?   ? :       0;

	endtable
endprimitive

primitive CMEE_primitive (Y,DB, D1, D2, D3, S01,S10, S11);
output Y;
input DB, D1, D2, D3, S01,S10, S11;


   table
	//DB   D1   D2   D3   S01  S10  S11          Y
	1 0 0 0 ? ? ? :       0;
	0 1 1 1 ? ? ? :       1;
	? 0 ? ? 1 0 0 :       0;
	0 1 ? ? 1 0 0 :       1;
	0 ? ? 0 1 1 ? :       0;
	0 ? ? 1 1 1 ? :       1;
	0 ? ? 0 1 ? 1 :       0;
	0 ? ? 1 1 ? 1 :       1;
	1 ? ? ? ? 0 0 :       0;
	0 ? ? ? 0 0 0 :       1;
	? ? 0 ? 0 ? 1 :       0;
	? ? 1 ? 0 ? 1 :       1;
	? ? 0 ? 0 1 ? :       0;
	? ? 1 ? 0 1 ? :       1;
	1 ? 0 ? ? ? 1 :       0;
	1 ? 1 ? ? ? 1 :       1;
	1 ? 0 ? ? 1 ? :       0;
	1 ? 1 ? ? 1 ? :       1;
	1 ? 0 ? ? ? ? :       0;
	0 ? 1 ? 0 ? ? :       1;
	? ? 0 0 ? 1 ? :       0;
	? ? 1 1 ? 1 ? :       1;
	? ? 0 0 ? ? 1 :       0;
	0 0 ? 0 1 ? ? :       0;
	0 1 ? 1 1 ? ? :       1;
	? ? 1 1 ? ? 1 :       1;
	0 1 ? ? ? 0 0 :       1;
	? 0 0 0 1 ? ? :       0;

   endtable
endprimitive




/*--------------------------------------------------------------------
 CELL NAME : AND2
 CELL TYPE : comb
 CELL LOGIC : Y = A & B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND2(Y,A,B);
 input A,B;
 output Y;

 and      U2(Y, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND2A
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND2A(Y,A,B);
 input A,B;
 output Y;

 not	INV_0(A_, A);
 and      U5(Y, A_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND2B
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND2B(Y,A,B);
 input A,B;
 output Y;

 not	INV_1(A_, A);
 not	INV_2(B_, B);
 and      U8(Y, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U15(NET_0_0, A, B);
 and      U16(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3A
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_4(A_, A);
 and      U20(NET_0_0, A_, B);
 and      U21(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3B
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_5(A_, A);
 not	INV_6(B_, B);
 and      U25(NET_0_0, A_, B_);
 and      U26(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3C
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_7(A_, A);
 not	INV_8(B_, B);
 not	INV_9(C_, C);
 and      U30(NET_0_0, A_, B_);
 and      U31(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO12
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B + !A & !C + A & !B & C + B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO12(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_13(A_, A);
 not	INV_14(B_, B);
 not	INV_15(C_, C);
 UDP_MUX2   U56(NET_0_5, B, NET_0_3, C_);
 and      U59(NET_0_3, A, B_);
 or       U60(Y, NET_0_5, NET_0_2);
 and      U63(NET_0_0, A_, B);
 or       U64(NET_0_2, NET_0_0, NET_0_1);
 and      U66(NET_0_1, A_, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO13
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + A & !C + B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO13(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_16(C_, C);
 and      U71(NET_0_0, A, B);
 or       U72(NET_0_2, NET_0_0, NET_0_1);
 and      U74(NET_0_1, A, C_);
 or       U75(Y, NET_0_2, NET_0_3);
 and      U77(NET_0_3, B, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO14
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + A & !C + B & !C + !A & !B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO14(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_17(A_, A);
 not	INV_18(B_, B);
 not	INV_19(C_, C);
 and      U82(NET_0_5, A_, B_);
 UDP_MUX2   U83(NET_0_4, NET_0_5, B, C);
 or       U85(Y, NET_0_4, NET_0_2);
 and      U88(NET_0_0, A, B);
 or       U89(NET_0_2, NET_0_0, NET_0_1);
 and      U91(NET_0_1, A, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO15
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B & C + !A & B & C + !A & !B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO15(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_20(A_, A);
 not	INV_21(B_, B);
 not	INV_22(C_, C);
 and      U96(NET_0_0, A, B_);
 UDP_MUX2   U97(NET_0_4, NET_0_0, NET_0_5, C);
 and      U100(NET_0_5, A_, B_);
 or       U101(Y, NET_0_4, NET_0_3);
 and      U104(NET_0_2, A_, B);
 and      U105(NET_0_3, NET_0_2, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO16
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & !C + !A & !B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO16(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_23(A_, A);
 not	INV_24(B_, B);
 not	INV_25(C_, C);
 and      U109(NET_0_0, A, B);
 UDP_MUX2   U110(Y, NET_0_0, NET_0_2, C_);
 and      U113(NET_0_2, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO17
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & C + !A & B & !C + !A & !B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO17(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_26(A_, A);
 not	INV_27(B_, B);
 not	INV_28(C_, C);
 and      U118(NET_0_5, A_, B_);
 UDP_MUX2   U119(NET_0_4, NET_0_5, NET_0_2, C);
 and      U122(NET_0_2, A_, B);
 or       U123(Y, NET_0_4, NET_0_1);
 and      U126(NET_0_0, A, B);
 and      U127(NET_0_1, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO18
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B + !A & !C + B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO18(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_29(A_, A);
 not	INV_30(C_, C);
 and      U132(NET_0_0, A_, B);
 or       U133(NET_0_2, NET_0_0, NET_0_1);
 and      U135(NET_0_1, A_, C_);
 or       U136(Y, NET_0_2, NET_0_3);
 and      U138(NET_0_3, B, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO1
 CELL TYPE : comb
 CELL LOGIC : Y = (A & B) + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U142(NET_0_0, A, B);
 or       U143(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO1A
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & B) + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_31(A_, A);
 and      U147(NET_0_0, A_, B);
 or       U148(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO1B
 CELL TYPE : comb
 CELL LOGIC : Y = (A & B) + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO1B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_32(C_, C);
 and      U152(NET_0_0, A, B);
 or       U153(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO1C
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & B) + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO1C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_33(A_, A);
 not	INV_34(C_, C);
 and      U157(NET_0_0, A_, B);
 or       U158(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO1D
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & !B) + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO1D(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_35(A_, A);
 not	INV_36(B_, B);
 and      U162(NET_0_0, A_, B_);
 or       U163(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO1E
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO1E(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_37(A_, A);
 not	INV_38(B_, B);
 not	INV_39(C_, C);
 and      U167(NET_0_0, A_, B_);
 or       U168(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI1
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B + C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U192(NET_0_0, A, B);
 nor      U193(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI1A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B + C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_44(A_, A);
 and      U197(NET_0_0, A_, B);
 nor      U198(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI1B
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B + !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI1B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_45(C_, C);
 and      U202(NET_0_0, A, B);
 nor      U203(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI1C
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B + C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI1C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_46(A_, A);
 not	INV_47(B_, B);
 and      U207(NET_0_0, A_, B_);
 nor      U208(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI1D
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B + !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI1D(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_48(A_, A);
 not	INV_49(B_, B);
 not	INV_50(C_, C);
 and      U212(NET_0_0, A_, B_);
 nor      U213(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI5
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B & C + A & !B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI5(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_54(A_, A);
 not	INV_55(B_, B);
 not	INV_56(C_, C);
 and      U237(NET_0_0, A_, B);
 UDPN_MUX2  U238(Y, NET_0_0, NET_0_2, C);
 and      U241(NET_0_2, A, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AX1
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & B) ^ C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AX1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_57(A_, A);
 and      U245(NET_0_0, A_, B);
 xor      U246(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AX1A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AX1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_58(A_, A);
 and      U250(NET_0_0, A_, B);
 xnor     U251(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AX1B
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & !B) ^ C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AX1B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_59(A_, A);
 not	INV_60(B_, B);
 and      U255(NET_0_0, A_, B_);
 xor      U256(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AX1C
 CELL TYPE : comb
 CELL LOGIC : Y = (A & B) ^ C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AX1C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U260(NET_0_0, A, B);
 xor      U261(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AX1D
 CELL TYPE : comb
 CELL LOGIC : Y = !((!A & !B) ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AX1D(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_61(A_, A);
 not	INV_62(B_, B);
 and      U265(NET_0_0, A_, B_);
 xnor     U266(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AX1E
 CELL TYPE : comb
 CELL LOGIC : Y = !((A & B) ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AX1E(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U270(NET_0_0, A, B);
 xnor     U271(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXO1
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + (B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXO1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_63(B_, B);
 not	INV_64(C_, C);
 and      U275(NET_0_1_XOR_REXT, B, C_);
 or       U276(Y, NET_0_1_XOR_REXT, NET_0_1);
 UDP_MUX2   U278(NET_0_1, C, A, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXO2
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B + (B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXO2(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_65(A_, A);
 not	INV_66(B_, B);
 not	INV_67(C_, C);
 and      U283(NET_0_1_XOR_REXT, B, C_);
 or       U284(Y, NET_0_1_XOR_REXT, NET_0_1);
 UDP_MUX2   U286(NET_0_1, C, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXO3
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B + (B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXO3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_68(B_, B);
 not	INV_69(C_, C);
 and      U291(NET_0_1_XOR_LEXT, B_, C);
 or       U292(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U294(NET_0_1, A, C_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXO5
 CELL TYPE : comb
 CELL LOGIC : Y =  !A & B + (!B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXO5(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_70(A_, A);
 not	INV_71(B_, B);
 not	INV_72(C_, C);
 and      U299(NET_0_1_XOR_LEXT, B, C);
 or       U300(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U302(NET_0_1, A_, C_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXO6
 CELL TYPE : comb
 CELL LOGIC : Y =  A & !B + (!B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXO6(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_73(B_, B);
 not	INV_74(C_, C);
 and      U307(NET_0_1_XOR_REXT, B_, C_);
 or       U308(Y, NET_0_1_XOR_REXT, NET_0_1);
 UDP_MUX2   U310(NET_0_1, C, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXO7
 CELL TYPE : comb
 CELL LOGIC : Y =  !A & !B + (B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXO7(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_75(A_, A);
 not	INV_76(B_, B);
 not	INV_77(C_, C);
 and      U315(NET_0_1_XOR_LEXT, B_, C);
 or       U316(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U318(NET_0_1, A_, C_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXOI1
 CELL TYPE : comb
 CELL LOGIC : Y =  !(A & B + (B ^ C))
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXOI1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_78(B_, B);
 not	INV_79(C_, C);
 and      U323(NET_0_1_XOR_REXT, B, C_);
 nor      U324(Y, NET_0_1_XOR_REXT, NET_0_1);
 UDP_MUX2   U326(NET_0_1, C, A, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXOI2
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B + (B ^ C))
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXOI2(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_80(A_, A);
 not	INV_81(B_, B);
 not	INV_82(C_, C);
 and      U331(NET_0_1_XOR_REXT, B, C_);
 nor      U332(Y, NET_0_1_XOR_REXT, NET_0_1);
 UDP_MUX2   U334(NET_0_1, C, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXOI3
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & !B + (B ^ C))
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXOI3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_83(B_, B);
 not	INV_84(C_, C);
 and      U339(NET_0_1_XOR_LEXT, B_, C);
 nor      U340(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U342(NET_0_1, A, C_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXOI4
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B + (!B ^ C))
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXOI4(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_85(B_, B);
 not	INV_86(C_, C);
 and      U347(NET_0_1_XOR_LEXT, B, C);
 nor      U348(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U350(NET_0_1, A, C_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXOI5
 CELL TYPE : comb
 CELL LOGIC : Y =  !(!A & B + (!B ^ C))
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXOI5(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_87(A_, A);
 not	INV_88(B_, B);
 not	INV_89(C_, C);
 and      U355(NET_0_1_XOR_LEXT, B, C);
 nor      U356(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U358(NET_0_1, A_, C_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXOI7
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B + (B ^ C))
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXOI7(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_90(A_, A);
 not	INV_91(B_, B);
 not	INV_92(C_, C);
 and      U363(NET_0_1_XOR_LEXT, B_, C);
 nor      U364(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U366(NET_0_1, A_, C_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : PLLINT 
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module PLLINT(Y,A);
 input A;
 output Y;

 buf    BUF_U_00(Y,A);

       specify

                specparam tpdLH_A_to_Y = (0.0:0.0:0.0);
                specparam tpdHL_A_to_Y = (0.0:0.0:0.0);
                specparam MacroType = "comb";

                //pin to pin path delay

                (A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U370(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
                (E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_12
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_12(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U373(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_12D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_12D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U376(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_12U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_12U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U379(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_16
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_16(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U382(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_16D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_16D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U385(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_16U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_16U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U388(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_8
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_8(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U400(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_8D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_8D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U403(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_8U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_8U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U406(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_24
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_24(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U391(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_24D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_24D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U394(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_24U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_24U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U397(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS15
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS15(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U418(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS15D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS15D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U421(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS15U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS15U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U424(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS18
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS18(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U427(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS18D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS18D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U430(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS18U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS18U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U433(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS25
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS25(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U436(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS25D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS25D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U439(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS25U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS25U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U442(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS33
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS33(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U2(PAD, D, E);
 buf    BUF_U_01(Y,PAD);

      specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
        specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
        specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
        specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
        specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
        specparam MacroType = "comb";

        //pin to pin path delay

      //if(~D)
        (E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
        (D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS33D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS33D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U5(PAD, D, E);
 buf    BUF_U_01(Y,PAD);

      specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
        specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
        specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
        specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
        specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
        specparam MacroType = "comb";

        //pin to pin path delay

      //if(~D)
        (E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
        (D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS33U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS33U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U8(PAD, D, E);
 buf    BUF_U_01(Y,PAD);

      specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
        specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
        specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
        specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
        specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
        specparam MacroType = "comb";

        //pin to pin path delay

      //if(~D)
        (E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
        (D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS5
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS5(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U445(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS5D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS5D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U448(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS5U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS5U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U451(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVDS
 CELL TYPE : comb
 CELL LOGIC : PADP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVDS(Y,PADP,PADN,D,E);
 input D,E;
 inout PADP,PADN;
 output Y;
 reg NOTIFY_REG;
 reg temp;

   bufif1   U89(PADP, D, E);
   not      U88(D_tmp, D);
   bufif1   U87(PADN, D_tmp, E);
   pmos     U86(Y,temp,1'b0);

   always @(PADP or PADN) begin
     if ((PADP == 1'b1) && (PADN == 1'b0))
        temp = 1'b1;
     else if ((PADP == 1'b0) && (PADN == 1'b1))
        temp = 1'b0;
     else
        temp = 1'bx;
    end


      specify

	specparam tpdLH_E_to_PADP = ( 0.1:0.1:0.1 );
	specparam tpdHL_E_to_PADP = ( 0.1:0.1:0.1 );
        specparam tpdLZ_E_to_PADP = ( 0.1:0.1:0.1 );
        specparam tpdZL_E_to_PADP = ( 0.1:0.1:0.1 );
        specparam tpdHZ_E_to_PADP = ( 0.1:0.1:0.1 );
        specparam tpdZH_E_to_PADP = ( 0.1:0.1:0.1 );
	specparam tpdLH_E_to_PADN = ( 0.1:0.1:0.1 );
	specparam tpdHL_E_to_PADN = ( 0.1:0.1:0.1 );
        specparam tpdLZ_E_to_PADN = ( 0.1:0.1:0.1 );
        specparam tpdZL_E_to_PADN = ( 0.1:0.1:0.1 );
        specparam tpdHZ_E_to_PADN = ( 0.1:0.1:0.1 );
        specparam tpdZH_E_to_PADN = ( 0.1:0.1:0.1 );
        specparam tpdLH_D_to_PADP = ( 0.1:0.1:0.1 );
        specparam tpdHL_D_to_PADP = ( 0.1:0.1:0.1 );
        specparam tpdLH_D_to_PADN = ( 0.1:0.1:0.1 );
        specparam tpdHL_D_to_PADN = ( 0.1:0.1:0.1 );
        specparam tpdLH_PADP_to_Y = ( 0.1:0.1:0.1 );
        specparam tpdHL_PADP_to_Y = ( 0.1:0.1:0.1 );
        specparam tpdLH_PADN_to_Y = ( 0.1:0.1:0.1 );
        specparam tpdHL_PADN_to_Y = ( 0.1:0.1:0.1 );
        specparam MacroType = "comb";

        //pin to pin path delay 

        //if(~D)
        ( E => PADP ) = ( tpdLH_E_to_PADP,tpdHL_E_to_PADP,tpdLZ_E_to_PADP,tpdZH_E_to_PADP,tpdHZ_E_to_PADP,tpdZL_E_to_PADP );
        ( E => PADN ) = ( tpdLH_E_to_PADN,tpdHL_E_to_PADN,tpdLZ_E_to_PADN,tpdZH_E_to_PADN,tpdHZ_E_to_PADN,tpdZL_E_to_PADN );

        ( D => PADP ) = ( tpdLH_D_to_PADP,tpdHL_D_to_PADP );
        ( D => PADN ) = ( tpdLH_D_to_PADN,tpdHL_D_to_PADN );

        ( D => Y )    = ( 0.1:0.1:0.1, 0.1:0.1:0.1 );
        ( E => Y )    = ( 0.1:0.1:0.1, 0.1:0.1:0.1 );
        ( PADP => Y ) = ( tpdLH_PADP_to_Y, tpdHL_PADP_to_Y );
        ( PADN => Y ) = ( tpdLH_PADN_to_Y, tpdHL_PADN_to_Y );

        $width( negedge PADP, 0.0, 0, NOTIFY_REG );
        $width( posedge PADP, 0.0, 0, NOTIFY_REG );
        $width( negedge PADN, 0.0, 0, NOTIFY_REG );
        $width( posedge PADN, 0.0, 0, NOTIFY_REG );
        $width( negedge D, 0.0, 0, NOTIFY_REG );
        $width( posedge D, 0.0, 0, NOTIFY_REG );
        $width( negedge E, 0.0, 0, NOTIFY_REG );
        $width( posedge E, 0.0, 0, NOTIFY_REG );


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : BIBUF_PCI
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_PCI(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U454(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_PCIX
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_PCIX(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U457(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_12
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_12(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U472(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_12D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_12D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U475(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_12U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_12U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U478(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_16
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_16(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U481(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_16D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_16D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U484(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_16U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_16U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U487(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_8
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_8(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U499(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_8D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_8D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U502(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_8U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_8U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U505(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_24
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_24(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U490(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_24D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_24D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U493(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_24U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_24U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U496(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf    BUF_U_00(Y,PAD);

       specify

                specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam MacroType = "comb";

                //pin to pin path delay

                (PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_LVCMOS15
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_LVCMOS15(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_LVCMOS18
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_LVCMOS18(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_LVCMOS25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_LVCMOS25(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_LVCMOS33
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_LVCMOS33(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf    BUF_U_00(Y,PAD);

      specify

        specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
        specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
        specparam MacroType = "comb";

        //pin to pin path delay

        (PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_LVCMOS5
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_LVCMOS5(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_LVDS
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_LVDS (PADP,PADN,Y);
  
    input PADP,PADN;
    output Y;
 reg NOTIFY_REG;

    reg temp;

    pmos p1(Y,temp,1'b0);
    always @(PADP or PADN) begin

    if ((PADP == 1'b1) && (PADN == 1'b0))
       temp = 1'b1;
    else if ((PADP == 1'b0) && (PADN == 1'b1))
       temp = 1'b0;
    else
       temp = 1'bx;
    end


    specify

         specparam   LibName       = "proasic3";
         specparam   InputLoad$PADP = 0;
         specparam   InputLoad$PADN = 0;
         specparam   OutputLoad$Y  = 0;

         specparam   MacroType = "clkbuf_lvds";


        (PADP => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);
          (PADN => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);

         $width(negedge PADP, 0.0, 0, NOTIFY_REG);
         $width(posedge PADP, 0.0, 0, NOTIFY_REG);
         $width(negedge PADN, 0.0, 0, NOTIFY_REG);
         $width(posedge PADN, 0.0, 0, NOTIFY_REG);


    endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_LVPECL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_LVPECL (PADP,PADN,Y);
  
    input PADP,PADN;
    output Y;
 reg NOTIFY_REG;

    buf b1(Y, PADP);

    always @(PADP or PADN) begin
       if (PADP != ~PADN) begin
        $display(" -- Error: two inputs should be complement with each other!\n");
        //$finish;
       end
    end

    specify

         specparam   LibName       = "proasic3";
         specparam   InputLoad$PADP = 0;
         specparam   InputLoad$PADN = 0;
         specparam   OutputLoad$Y  = 0;

         specparam   MacroType = "clkbuf_lvpecl";


        (PADP => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);
          (PADN => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);

         $width(negedge PADP, 0.0, 0, NOTIFY_REG);
         $width(posedge PADP, 0.0, 0, NOTIFY_REG);
         $width(negedge PADN, 0.0, 0, NOTIFY_REG);
         $width(posedge PADN, 0.0, 0, NOTIFY_REG);


    endspecify

endmodule


`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_PCI
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_PCI(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_PCIX
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_PCIX(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------
 CELL NAME : DFI0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0(CLK, QN,D);
 input D,CLK;
 output QN;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(q_tmp, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0C0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0C0(CLR, CLK, QN,D);
 input D,CLR,CLK;
 output QN;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(q_tmp, D,CLK,CLR, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,CLR);
       buf U_c2 (Enable02, CLR);
      buf U_c6 (Enable05, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(negedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(negedge CLK, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0C1(CLR, CLK, QN,D);
 input D,CLR,CLK;
 output QN;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(q_tmp, D,CLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,_CLR0);
       buf U_c2 (Enable02, _CLR0);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(negedge CLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0E0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, _E=E, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0E0(E, CLK, QN,D);
 input D,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpf DF_0(q_tmp, D,CLK,VCC_0, VCC_0, E, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I3 (_E0, E);
      buf U_c0 (Enable01,_E0);
      buf U_c2 (Enable02, _E0);
      buf U_c4 (Enable04, _E0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK,  0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge E,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0E0C0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, _E=E, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0E0C0(CLR, E, CLK, QN,D);
 input D,CLR,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpf DF_0(q_tmp, D,CLK,CLR, VCC_0, E, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I2 (_CLR0, CLR);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, CLR);
      and U_c2 (Enable02, _E0, CLR);
      buf U_c4 (Enable04, _E0);
      buf U_c6 (Enable05, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(negedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable04, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, negedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0E0C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, _E=E, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0E0C1(CLR, E, CLK, QN,D);
 input D,CLR,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(q_tmp, D,CLK,CLR_0, VCC_0, E, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I2 (_CLR0, CLR);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, _CLR0);
      and U_c2 (Enable02, _E0, _CLR0);
      buf U_c4 (Enable04, _E0);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, negedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0E0P0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, _E=E, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0E0P0(PRE, E, CLK, QN,D);
 input D,PRE,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpf DF_0(q_tmp, D,CLK,VCC_0, PRE, E, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, PRE);
      buf U_c2 (Enable02, _E0);
      and U_c4 (Enable04, _E0, PRE);
       buf U_c6 (Enable05, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(negedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable02, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0E0P1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, _E=E, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0E0P1(PRE, E, CLK, QN,D);
 input D,PRE,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpf DF_0(q_tmp, D,CLK,VCC_0, PRE_0, E, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, _PRE0);
      buf U_c2 (Enable02, _E0);
      and U_c4 (Enable04, _E0, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, negedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0E1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, E=E, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0E1(E, CLK, QN,D);
 input D,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_EN_0(E_0, E);

 Dffpf DF_0(q_tmp, D,CLK,VCC_0, VCC_0, E_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      buf U_c0 (Enable01,E);
      buf U_c2 (Enable02, E);
      buf U_c4 (Enable04, E);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK,  0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge E,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0E1C0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, E=E, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0E1C0(CLR, E, CLK, QN,D);
 input D,CLR,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_EN_0(E_0, E);

 Dffpf DF_0(q_tmp, D,CLK,CLR, VCC_0, E_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, E, CLR);
      and U_c2 (Enable02, E, CLR);
      buf U_c4 (Enable04, E);
      buf U_c6 (Enable05, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(negedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable04, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, negedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0E1C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, E=E, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0E1C1(CLR, E, CLK, QN,D);
 input D,CLR,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);
 not INV_EN_0(E_0, E);

 Dffpf DF_0(q_tmp, D,CLK,CLR_0, VCC_0, E_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, E, _CLR0);
      and U_c2 (Enable02, E, _CLR0);
      buf U_c4 (Enable04, E);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, negedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0E1P0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, E=E, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0E1P0(PRE, E, CLK, QN,D);
 input D,PRE,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_EN_0(E_0, E);

 Dffpf DF_0(q_tmp, D,CLK,VCC_0, PRE, E_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, E, PRE);
      buf U_c2 (Enable02, E);
      and U_c4 (Enable04, E, PRE);
       buf U_c6 (Enable05, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(negedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable02, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0E1P1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, E=E, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0E1P1(PRE, E, CLK, QN,D);
 input D,PRE,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);
 not INV_EN_0(E_0, E);

 Dffpf DF_0(q_tmp, D,CLK,VCC_0, PRE_0, E_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, E, _PRE0);
      buf U_c2 (Enable02, E);
      and U_c4 (Enable04, E, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, negedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0P0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0P0(PRE, CLK, QN,D);
 input D,PRE,CLK;
 output QN;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(q_tmp, D,CLK,VCC_0, PRE, GND_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, PRE);       buf U_c4 (Enable04, PRE);
       buf U_c6 (Enable05, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(negedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0P1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0P1(PRE, CLK, QN,D);
 input D,PRE,CLK;
 output QN;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpf DF_0(q_tmp, D,CLK,VCC_0, PRE_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, _PRE0);
       buf U_c4 (Enable04, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI0P1C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, _CLK=CLK, CLR=CLR, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI0P1C1(PRE, CLR, CLK, QN,D);
 input D,PRE,CLR,CLK;
 output QN;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);
 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(q_tmp, D,CLK,CLR_0, PRE_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, _CLR0, _PRE0);
       buf U_c2 (Enable02, _CLR0);
       buf U_c4 (Enable04, _PRE0);
      and U_c6 (Enable05, _CLR0, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);
	(posedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE &&& ~CLR,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, negedge CLK &&& Enable02, 0.0, NOTIFY_REG);
	$recovery(negedge CLR, negedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1(CLK, QN,D);
 input D,CLK;
 output QN;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(q_tmp, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1C0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1C0(CLR, CLK, QN,D);
 input D,CLR,CLK;
 output QN;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(q_tmp, D,CLK,CLR, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,CLR);
       buf U_c2 (Enable02, CLR);
      buf U_c6 (Enable05, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(negedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1C1(CLR, CLK, QN,D);
 input D,CLR,CLK;
 output QN;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(q_tmp, D,CLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,_CLR0);
       buf U_c2 (Enable02, _CLR0);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1E0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, _E=E, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1E0(E, CLK, QN,D);
 input D,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpr DF_0(q_tmp, D,CLK,VCC_0, VCC_0, E, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I3 (_E0, E);
      buf U_c0 (Enable01,_E0);
      buf U_c2 (Enable02, _E0);
      buf U_c4 (Enable04, _E0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK,  0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge E,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1E0C0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, _E=E, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1E0C0(CLR, E, CLK, QN,D);
 input D,CLR,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpr DF_0(q_tmp, D,CLK,CLR, VCC_0, E, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, CLR);
      and U_c2 (Enable02, _E0, CLR);
      buf U_c4 (Enable04, _E0);
      buf U_c6 (Enable05, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(negedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable04, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, posedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1E0C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, _E=E, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1E0C1(CLR, E, CLK, QN,D);
 input D,CLR,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(q_tmp, D,CLK,CLR_0, VCC_0, E, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, _CLR0);
      and U_c2 (Enable02, _E0, _CLR0);
      buf U_c4 (Enable04, _E0);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1E0P0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, _E=E, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1E0P0(PRE, E, CLK, QN,D);
 input D,PRE,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpr DF_0(q_tmp, D,CLK,VCC_0, PRE, E, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, PRE);
      buf U_c2 (Enable02, _E0);
      and U_c4 (Enable04, _E0, PRE);
       buf U_c6 (Enable05, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(negedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable02, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1E0P1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, _E=E, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1E0P1(PRE, E, CLK, QN,D);
 input D,PRE,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpr DF_0(q_tmp, D,CLK,VCC_0, PRE_0, E, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, _PRE0);
      buf U_c2 (Enable02, _E0);
      and U_c4 (Enable04, _E0, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1E1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, E=E, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1E1(E, CLK, QN,D);
 input D,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_EN_0(E_0, E);

 Dffpr DF_0(q_tmp, D,CLK,VCC_0, VCC_0, E_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      buf U_c0 (Enable01,E);
      buf U_c2 (Enable02, E);
      buf U_c4 (Enable04, E);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK,  0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge E,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1E1C0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, E=E, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1E1C0(CLR, E, CLK, QN,D);
 input D,CLR,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_EN_0(E_0, E);

 Dffpr DF_0(q_tmp, D,CLK,CLR, VCC_0, E_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, E, CLR);
      and U_c2 (Enable02, E, CLR);
      buf U_c4 (Enable04, E);
      buf U_c6 (Enable05, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(negedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable04, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, posedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1E1C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, E=E, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1E1C1(CLR, E, CLK, QN,D);
 input D,CLR,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);
 not INV_EN_0(E_0, E);

 Dffpr DF_0(q_tmp, D,CLK,CLR_0, VCC_0, E_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, E, _CLR0);
      and U_c2 (Enable02, E, _CLR0);
      buf U_c4 (Enable04, E);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1E1P0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, E=E, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1E1P0(PRE, E, CLK, QN,D);
 input D,PRE,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_EN_0(E_0, E);

 Dffpr DF_0(q_tmp, D,CLK,VCC_0, PRE, E_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, E, PRE);
      buf U_c2 (Enable02, E);
      and U_c4 (Enable04, E, PRE);
       buf U_c6 (Enable05, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(negedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable02, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1E1P1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, E=E, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1E1P1(PRE, E, CLK, QN,D);
 input D,PRE,E,CLK;
 output QN;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);
 not INV_EN_0(E_0, E);

 Dffpr DF_0(q_tmp, D,CLK,VCC_0, PRE_0, E_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, E, _PRE0);
      buf U_c2 (Enable02, E);
      and U_c4 (Enable04, E, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1P0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1P0(PRE, CLK, QN,D);
 input D,PRE,CLK;
 output QN;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(q_tmp, D,CLK,VCC_0, PRE, GND_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, PRE);       buf U_c4 (Enable04, PRE);
       buf U_c6 (Enable05, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(negedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1P1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1P1(PRE, CLK, QN,D);
 input D,PRE,CLK;
 output QN;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpr DF_0(q_tmp, D,CLK,VCC_0, PRE_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, _PRE0);
       buf U_c4 (Enable04, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFI1P1C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QN, CLK =CLK, CLR=CLR, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFI1P1C1(PRE, CLR, CLK, QN,D);
 input D,PRE,CLR,CLK;
 output QN;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);
 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(q_tmp, D,CLK,CLR_0, PRE_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QN,q_tmp);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, _CLR0, _PRE0);
       buf U_c2 (Enable02, _CLR0);
       buf U_c4 (Enable04, _PRE0);
      and U_c6 (Enable05, _CLR0, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QN = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_QN = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QN +: D))=(tpdLH_CLK_to_QN, tpdHL_CLK_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);
	(posedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE &&& ~CLR,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge CLK &&& Enable02, 0.0, NOTIFY_REG);
	$recovery(negedge CLR, posedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0(CLK, Q,D);
 input D,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0C0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0C0(CLR, CLK, Q,D);
 input D,CLR,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,CLR, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,CLR);
       buf U_c2 (Enable02, CLR);
      buf U_c6 (Enable05, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(negedge CLK, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0C1(CLR, CLK, Q,D);
 input D,CLR,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(Q, D,CLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,_CLR0);
       buf U_c2 (Enable02, _CLR0);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(negedge CLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0E0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0E0(E, CLK, Q,D);
 input D,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,VCC_0, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I3 (_E0, E);
      buf U_c0 (Enable01,_E0);
      buf U_c2 (Enable02, _E0);
      buf U_c4 (Enable04, _E0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK,  0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge E,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0E0C0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0E0C0(CLR, E, CLK, Q,D);
 input D,CLR,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,CLR, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I2 (_CLR0, CLR);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, CLR);
      and U_c2 (Enable02, _E0, CLR);
      buf U_c4 (Enable04, _E0);
      buf U_c6 (Enable05, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable04, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, negedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0E0C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0E0C1(CLR, E, CLK, Q,D);
 input D,CLR,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(Q, D,CLK,CLR_0, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I2 (_CLR0, CLR);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, _CLR0);
      and U_c2 (Enable02, _E0, _CLR0);
      buf U_c4 (Enable04, _E0);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, negedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0E0P0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0E0P0(PRE, E, CLK, Q,D);
 input D,PRE,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,VCC_0, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, PRE);
      buf U_c2 (Enable02, _E0);
      and U_c4 (Enable04, _E0, PRE);
       buf U_c6 (Enable05, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable02, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0E0P1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0E0P1(PRE, E, CLK, Q,D);
 input D,PRE,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpf DF_0(Q, D,CLK,VCC_0, PRE_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, _PRE0);
      buf U_c2 (Enable02, _E0);
      and U_c4 (Enable04, _E0, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, negedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0E1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, E=E, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0E1(E, CLK, Q,D);
 input D,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_EN_0(E_0, E);

 Dffpf DF_0(Q, D,CLK,VCC_0, VCC_0, E_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      buf U_c0 (Enable01,E);
      buf U_c2 (Enable02, E);
      buf U_c4 (Enable04, E);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK,  0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge E,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0E1C0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, E=E, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0E1C0(CLR, E, CLK, Q,D);
 input D,CLR,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_EN_0(E_0, E);

 Dffpf DF_0(Q, D,CLK,CLR, VCC_0, E_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, E, CLR);
      and U_c2 (Enable02, E, CLR);
      buf U_c4 (Enable04, E);
      buf U_c6 (Enable05, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable04, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, negedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0E1C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, E=E, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0E1C1(CLR, E, CLK, Q,D);
 input D,CLR,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);
 not INV_EN_0(E_0, E);

 Dffpf DF_0(Q, D,CLK,CLR_0, VCC_0, E_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, E, _CLR0);
      and U_c2 (Enable02, E, _CLR0);
      buf U_c4 (Enable04, E);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, negedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0E1P0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, E=E, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0E1P0(PRE, E, CLK, Q,D);
 input D,PRE,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_EN_0(E_0, E);

 Dffpf DF_0(Q, D,CLK,VCC_0, PRE, E_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, E, PRE);
      buf U_c2 (Enable02, E);
      and U_c4 (Enable04, E, PRE);
       buf U_c6 (Enable05, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable02, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0E1P1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, E=E, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0E1P1(PRE, E, CLK, Q,D);
 input D,PRE,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);
 not INV_EN_0(E_0, E);

 Dffpf DF_0(Q, D,CLK,VCC_0, PRE_0, E_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, E, _PRE0);
      buf U_c2 (Enable02, E);
      and U_c4 (Enable04, E, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, negedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0P0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0P0(PRE, CLK, Q,D);
 input D,PRE,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,VCC_0, PRE, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, PRE);       buf U_c4 (Enable04, PRE);
       buf U_c6 (Enable05, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0P1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0P1(PRE, CLK, Q,D);
 input D,PRE,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpf DF_0(Q, D,CLK,VCC_0, PRE_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, _PRE0);
       buf U_c4 (Enable04, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN0P1C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, CLR=CLR, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN0P1C1(PRE, CLR, CLK, Q,D);
 input D,PRE,CLR,CLK;
 output Q;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);
 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(Q, D,CLK,CLR_0, PRE_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I0 (_CLK0, CLK);
      not U0_I1 (_PRE0, PRE);
      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, _CLR0, _PRE0);
       buf U_c2 (Enable02, _CLR0);
       buf U_c4 (Enable04, _PRE0);
      and U_c6 (Enable05, _CLR0, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE &&& ~CLR,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, negedge CLK &&& Enable02, 0.0, NOTIFY_REG);
	$recovery(negedge CLR, negedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1(CLK, Q,D);
 input D,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1C0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1C0(CLR, CLK, Q,D);
 input D,CLR,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,CLR, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,CLR);
       buf U_c2 (Enable02, CLR);
      buf U_c6 (Enable05, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1C1(CLR, CLK, Q,D);
 input D,CLR,CLK;
 output Q;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 UFPRB DF_0( Q, D, CLK, CLR_0, NOTIFY_REG );

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,_CLR0);
       buf U_c2 (Enable02, _CLR0);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1E0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1E0(E, CLK, Q,D);
 input D,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,VCC_0, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I3 (_E0, E);
      buf U_c0 (Enable01,_E0);
      buf U_c2 (Enable02, _E0);
      buf U_c4 (Enable04, _E0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK,  0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge E,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1E0C0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1E0C0(CLR, E, CLK, Q,D);
 input D,CLR,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,CLR, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, CLR);
      and U_c2 (Enable02, _E0, CLR);
      buf U_c4 (Enable04, _E0);
      buf U_c6 (Enable05, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable04, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, posedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1E0C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1E0C1(CLR, E, CLK, Q,D);
 input D,CLR,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(Q, D,CLK,CLR_0, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, _CLR0);
      and U_c2 (Enable02, _E0, _CLR0);
      buf U_c4 (Enable04, _E0);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1E0P0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1E0P0(PRE, E, CLK, Q,D);
 input D,PRE,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,VCC_0, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, PRE);
      buf U_c2 (Enable02, _E0);
      and U_c4 (Enable04, _E0, PRE);
       buf U_c6 (Enable05, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable02, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1E0P1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1E0P1(PRE, E, CLK, Q,D);
 input D,PRE,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpr DF_0(Q, D,CLK,VCC_0, PRE_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      not U0_I3 (_E0, E);
      and U_c0 (Enable01, _E0, _PRE0);
      buf U_c2 (Enable02, _E0);
      and U_c4 (Enable04, _E0, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1E1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, E=E, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1E1(E, CLK, Q,D);
 input D,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_EN_0(E_0, E);

 Dffpr DF_0(Q, D,CLK,VCC_0, VCC_0, E_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      buf U_c0 (Enable01,E);
      buf U_c2 (Enable02, E);
      buf U_c4 (Enable04, E);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK,  0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge E,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1E1C0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, E=E, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1E1C0(CLR, E, CLK, Q,D);
 input D,CLR,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_EN_0(E_0, E);

 Dffpr DF_0(Q, D,CLK,CLR, VCC_0, E_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, E, CLR);
      and U_c2 (Enable02, E, CLR);
      buf U_c4 (Enable04, E);
      buf U_c6 (Enable05, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable04, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, posedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1E1C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, E=E, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1E1C1(CLR, E, CLK, Q,D);
 input D,CLR,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);
 not INV_EN_0(E_0, E);

 Dffpr DF_0(Q, D,CLK,CLR_0, VCC_0, E_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, E, _CLR0);
      and U_c2 (Enable02, E, _CLR0);
      buf U_c4 (Enable04, E);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1E1P0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, E=E, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1E1P0(PRE, E, CLK, Q,D);
 input D,PRE,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_EN_0(E_0, E);

 Dffpr DF_0(Q, D,CLK,VCC_0, PRE, E_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, E, PRE);
      buf U_c2 (Enable02, E);
      and U_c4 (Enable04, E, PRE);
       buf U_c6 (Enable05, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable02, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1E1P1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, E=E, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1E1P1(PRE, E, CLK, Q,D);
 input D,PRE,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);
 not INV_EN_0(E_0, E);

 Dffpr DF_0(Q, D,CLK,VCC_0, PRE_0, E_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, E, _PRE0);
      buf U_c2 (Enable02, E);
      and U_c4 (Enable04, E, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable05, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge CLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1P0
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1P0(PRE, CLK, Q,D);
 input D,PRE,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,VCC_0, PRE, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, PRE);       buf U_c4 (Enable04, PRE);
       buf U_c6 (Enable05, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1P1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1P1(PRE, CLK, Q,D);
 input D,PRE,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpr DF_0(Q, D,CLK,VCC_0, PRE_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, _PRE0);
       buf U_c4 (Enable04, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFN1P1C1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, CLR=CLR, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFN1P1C1(PRE, CLR, CLK, Q,D);
 input D,PRE,CLR,CLK;
 output Q;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);
 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(Q, D,CLK,CLR_0, PRE_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, _CLR0, _PRE0);
       buf U_c2 (Enable02, _CLR0);
       buf U_c4 (Enable04, _PRE0);
      and U_c6 (Enable05, _CLR0, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE &&& ~CLR,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge CLK &&& Enable02, 0.0, NOTIFY_REG);
	$recovery(negedge CLR, posedge CLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLI0
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, _CLK=G, D=D ];
-----------------------------------------------------------------*/

module DLI0(G, QN,D);
 input D,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 DL2C_UDP DL_U0(QN_, D, G, GND, GND, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	buf U_c1 (Enable2, _G);
	buf U_c3 (Enable4, _G);
	buf U_c5 (Enable6, _G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if (!G )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	(negedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLI0C0
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, _CLK=G, _CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLI0C0(CLR, G, QN,D);
 input D,CLR,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(QN_, D, G, CLR_, GND, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,CLR);
	and U_c1 (Enable2, _G, CLR);
	buf U_c2 (Enable3, CLR);
	and U_c3 (Enable4, _G, CLR);
	buf U_c5 (Enable6, _G);
	buf U_c6 (Enable7, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if (!G && CLR )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if (Enable1)
	(negedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(negedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);
	(posedge CLR => (QN+:D)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  CLR, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, posedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLI0C1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, _CLK=G, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLI0C1(CLR, G, QN,D);
 input D,CLR,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(QN_, D, G, CLR, GND, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, _G, _CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _G, _CLR);
	buf U_c5 (Enable6, _G);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if (!G && !CLR )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if (Enable1)
	(negedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);
	(negedge CLR => (QN+:D)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLI0P0
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, _CLK=G, _PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLI0P0(PRE, G, QN,D);
 input D,PRE,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 DL2C_UDP DL_U0(QN_, D, G, GND, PRE_, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,PRE);	and U_c1 (Enable2, _G, PRE);
	buf U_c3 (Enable4, _G);
	buf U_c4 (Enable5, PRE);
	and U_c5 (Enable6, _G, PRE);
	buf U_c6 (Enable7, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if (!G && PRE )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if (Enable1)
	(negedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(negedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);
       if (!G )
       (posedge PRE => (QN+:D)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  PRE, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, posedge PRE, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLI0P1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, _CLK=G, PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLI0P1(PRE, G, QN,D);
 input D,PRE,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 DL2C_UDP DL_U0(QN_, D, G, GND, PRE, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,_PRE);
	and U_c1 (Enable2, _G, _PRE);
	buf U_c3 (Enable4, _G);
	buf U_c4 (Enable5, _PRE);
	and U_c5 (Enable6, _G, _PRE);
	buf U_c6 (Enable7, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if (!G && !PRE )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if (Enable1)
	(negedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(posedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);
       if (!G )
	(negedge PRE => (QN+:D)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (negedge PRE, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, negedge PRE, 0.0, NOTIFY_REG);
	$hold(posedge G,  negedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLI0P1C1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, _CLK=G, CLR=CLR, PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLI0P1C1(PRE, CLR, G, QN,D);
 input D,PRE,CLR,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(QN_, D, G, CLR, PRE, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I1 (_PRE, PRE);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, _CLR, _PRE);
	and U_c1 (Enable2, _G, _CLR, _PRE);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _G, _CLR);
	buf U_c4 (Enable5, _PRE);
	and U_c5 (Enable6, _G, _PRE);
	and U_c6 (Enable7, _CLR, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if (!G && !CLR && !PRE )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if (Enable1)
	(negedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);
	(negedge CLR => (QN+:D)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);
	if (!CLR)
	(posedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);
       if (!G && !CLR )
	(negedge PRE => (QN+:D)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE &&& Enable3, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge PRE, posedge G &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (posedge G &&& Enable3 , negedge PRE, 0.0, NOTIFY_REG);
	$recovery (negedge CLR, posedge G &&& Enable5, 0.0, NOTIFY_REG);
	$hold (posedge G &&& Enable5, negedge CLR, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable3,  negedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLI1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, CLK =G, D=D ];
-----------------------------------------------------------------*/

module DLI1(G, QN,D);
 input D,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(QN_, D, G_, GND, GND, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	buf U_c1 (Enable2, G);
	buf U_c3 (Enable4, G);
	buf U_c5 (Enable6, G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if (G )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	(posedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLI1C0
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, CLK =G, _CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLI1C0(CLR, G, QN,D);
 input D,CLR,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(QN_, D, G_, CLR_, GND, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,CLR);
	and U_c1 (Enable2, G,CLR);
	buf U_c2 (Enable3, CLR);
	and U_c3 (Enable4, G, CLR);
	buf U_c5 (Enable6, G);
	buf U_c6 (Enable7, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if (G && CLR )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if (Enable1)
	(posedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(negedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);
	(posedge CLR => (QN+:D)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  CLR, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, posedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLI1C1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, CLK =G, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLI1C1(CLR, G, QN,D);
 input D,CLR,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(QN_, D, G_, CLR, GND, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, G,_CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, G, _CLR);
	buf U_c5 (Enable6, G);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if (G && !CLR )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if (Enable1)
	(posedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);
	(negedge CLR => (QN+:D)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLI1P0
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, CLK =G, _PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLI1P0(PRE, G, QN,D);
 input D,PRE,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(QN_, D, G_, GND, PRE_, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,PRE);	and U_c1 (Enable2, G, PRE);
	buf U_c3 (Enable4, G);
	buf U_c4 (Enable5, PRE);
	and U_c5 (Enable6, G, PRE);
	buf U_c6 (Enable7, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if (G && PRE )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if (Enable1)
	(posedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(negedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);
       if (G )
       (posedge PRE => (QN+:D)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  PRE, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, posedge PRE, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLI1P1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, CLK =G, PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLI1P1(PRE, G, QN,D);
 input D,PRE,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(QN_, D, G_, GND, PRE, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,_PRE);
	and U_c1 (Enable2, G, _PRE);
	buf U_c3 (Enable4, G);
	buf U_c4 (Enable5, _PRE);
	and U_c5 (Enable6, G, _PRE);
	buf U_c6 (Enable7, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if (G && !PRE )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if (Enable1)
	(posedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(posedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);
       if (G )
	(negedge PRE => (QN+:D)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (negedge PRE, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, negedge PRE, 0.0, NOTIFY_REG);
	$hold(negedge G,  negedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLI1P1C1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, CLK =G, CLR=CLR, PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLI1P1C1(PRE, CLR, G, QN,D);
 input D,PRE,CLR,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_CLR(CLR_, CLR);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(QN_, D, G_, CLR, PRE, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I1 (_PRE, PRE);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, _CLR, _PRE);
	and U_c1 (Enable2, G, _CLR, _PRE);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, G, _CLR);
	buf U_c4 (Enable5, _PRE);
	and U_c5 (Enable6, G, _PRE);
	and U_c6 (Enable7, _CLR, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if (G && !CLR && !PRE )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if (Enable1)
	(posedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);
	(negedge CLR => (QN+:D)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);
	if (!CLR)
	(posedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);
        if (G && !CLR )
	(negedge PRE => (QN+:D)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE &&& Enable3, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge PRE, negedge G &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (negedge G &&& Enable3 , negedge PRE, 0.0, NOTIFY_REG);
	$recovery (negedge CLR, negedge G &&& Enable5, 0.0, NOTIFY_REG);
	$hold (negedge G &&& Enable5, negedge CLR, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable3,  negedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLN0
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, D=D ];
-----------------------------------------------------------------*/

module DLN0(G, Q,D);
 input D,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 DL2C_UDP DL_U0(Q, D, G, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	buf U_c1 (Enable2, _G);
	buf U_c3 (Enable4, _G);
	buf U_c5 (Enable6, _G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if (!G )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLN0C0
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, _CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLN0C0(CLR, G, Q,D);
 input D,CLR,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(Q, D, G, CLR_, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,CLR);
	and U_c1 (Enable2, _G, CLR);
	buf U_c2 (Enable3, CLR);
	and U_c3 (Enable4, _G, CLR);
	buf U_c5 (Enable6, _G);
	buf U_c6 (Enable7, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if (!G && CLR )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if (Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  CLR, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, posedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLN0C1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLN0C1(CLR, G, Q,D);
 input D,CLR,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(Q, D, G, CLR, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, _G, _CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _G, _CLR);
	buf U_c5 (Enable6, _G);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if (!G && !CLR )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if (Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLN0P0
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, _PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLN0P0(PRE, G, Q,D);
 input D,PRE,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 DL2C_UDP DL_U0(Q, D, G, GND, PRE_, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,PRE);	and U_c1 (Enable2, _G, PRE);
	buf U_c3 (Enable4, _G);
	buf U_c4 (Enable5, PRE);
	and U_c5 (Enable6, _G, PRE);
	buf U_c6 (Enable7, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if (!G && PRE )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if (Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
       if (!G )
       (posedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  PRE, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, posedge PRE, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLN0P1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLN0P1(PRE, G, Q,D);
 input D,PRE,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 DL2C_UDP DL_U0(Q, D, G, GND, PRE, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,_PRE);
	and U_c1 (Enable2, _G, _PRE);
	buf U_c3 (Enable4, _G);
	buf U_c4 (Enable5, _PRE);
	and U_c5 (Enable6, _G, _PRE);
	buf U_c6 (Enable7, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if (!G && !PRE )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if (Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
       if (!G )
	(negedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (negedge PRE, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, negedge PRE, 0.0, NOTIFY_REG);
	$hold(posedge G,  negedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLN0P1C1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, CLR=CLR, PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLN0P1C1(PRE, CLR, G, Q,D);
 input D,PRE,CLR,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(Q, D, G, CLR, PRE, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I1 (_PRE, PRE);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, _CLR, _PRE);
	and U_c1 (Enable2, _G, _CLR, _PRE);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _G, _CLR);
	buf U_c4 (Enable5, _PRE);
	and U_c5 (Enable6, _G, _PRE);
	and U_c6 (Enable7, _CLR, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        //check timing delay for output

	if (!G && !CLR && !PRE )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if (Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	if (!CLR)
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
        if (!G && !CLR )
	(negedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE &&& Enable3, 0.0, 0, NOTIFY_REG);
	
        $width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge PRE, posedge G &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (posedge G &&& Enable3 , negedge PRE, 0.0, NOTIFY_REG);
	$recovery (negedge CLR, posedge G &&& Enable5, 0.0, NOTIFY_REG);
	$hold (posedge G &&& Enable5, negedge CLR, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable3,  negedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLN1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, D=D ];
-----------------------------------------------------------------*/

module DLN1(G, Q,D);
 input D,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, D, G_, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	buf U_c1 (Enable2, G);
	buf U_c3 (Enable4, G);
	buf U_c5 (Enable6, G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if (G )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLN1C0
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, _CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLN1C0(CLR, G, Q,D);
 input D,CLR,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, D, G_, CLR_, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,CLR);
	and U_c1 (Enable2, G,CLR);
	buf U_c2 (Enable3, CLR);
	and U_c3 (Enable4, G, CLR);
	buf U_c5 (Enable6, G);
	buf U_c6 (Enable7, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if (G && CLR )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if (Enable1)
	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  CLR, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, posedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLN1C1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLN1C1(CLR, G, Q,D);
 input D,CLR,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, D, G_, CLR, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, G,_CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, G, _CLR);
	buf U_c5 (Enable6, G);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output

	if (G && !CLR )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if (Enable1)
	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLN1P0
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, _PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLN1P0(PRE, G, Q,D);
 input D,PRE,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, D, G_, GND, PRE_, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,PRE);	and U_c1 (Enable2, G, PRE);
	buf U_c3 (Enable4, G);
	buf U_c4 (Enable5, PRE);
	and U_c5 (Enable6, G, PRE);
	buf U_c6 (Enable7, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if (G && PRE )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if (Enable1)
	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
       if (G )
       (posedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  PRE, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, posedge PRE, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLN1P1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLN1P1(PRE, G, Q,D);
 input D,PRE,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, D, G_, GND, PRE, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,_PRE);
	and U_c1 (Enable2, G, _PRE);
	buf U_c3 (Enable4, G);
	buf U_c4 (Enable5, _PRE);
	and U_c5 (Enable6, G, _PRE);
	buf U_c6 (Enable7, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if (G && !PRE )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if (Enable1)
	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
       if (G )
	(negedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (negedge PRE, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, negedge PRE, 0.0, NOTIFY_REG);
	$hold(negedge G,  negedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLN1P1C1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, CLR=CLR, PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLN1P1C1(PRE, CLR, G, Q,D);
 input D,PRE,CLR,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_CLR(CLR_, CLR);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, D, G_, CLR, PRE, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I1 (_PRE, PRE);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, _CLR, _PRE);
	and U_c1 (Enable2, G, _CLR, _PRE);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, G, _CLR);
	buf U_c4 (Enable5, _PRE);
	and U_c5 (Enable6, G, _PRE);
	and U_c6 (Enable7, _CLR, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    LibName	="proasic3";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if (G && !CLR && !PRE )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if (Enable1)
	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	if (!CLR)
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
        if (G && !CLR )
	(negedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE &&& Enable3, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge PRE, negedge G &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (negedge G &&& Enable3 , negedge PRE, 0.0, NOTIFY_REG);
	$recovery (negedge CLR, negedge G &&& Enable5, 0.0, NOTIFY_REG);
	$hold (negedge G &&& Enable5, negedge CLR, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable3,  negedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : GND
 CELL TYPE : comb
 CELL LOGIC : Y=0
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GND(Y);
 output Y;

 supply0	Y;

       specify

		specparam MacroType = "comb";

		//pin to pin path delay 

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS15
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS15(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS15D
 CELL TYPE : comb
 CELL LOGIC : Y#Down=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS15D(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 pulldown	DN(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS15U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS15U(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS18
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS18(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS18D
 CELL TYPE : comb
 CELL LOGIC : Y#Down=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS18D(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 pulldown	DN(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS18U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS18U(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS25(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS25D
 CELL TYPE : comb
 CELL LOGIC : Y#Down=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS25D(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 pulldown	DN(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS25U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS25U(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS33
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS33(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf    BUF_U_00(Y,PAD);

      specify

        specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
        specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
        specparam MacroType = "comb";

        //pin to pin path delay

        (PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS33D
 CELL TYPE : comb
 CELL LOGIC : Y#Down=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS33D(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 pulldown       DN(PAD);
 buf    BUF_U_00(Y,PAD);

      specify

        specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
        specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
        specparam MacroType = "comb";

        //pin to pin path delay

        (PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS33U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS33U(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 pullup UP(PAD);
 buf    BUF_U_00(Y,PAD);

      specify

        specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
        specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
        specparam MacroType = "comb";

        //pin to pin path delay

        (PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS5
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS5(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS5D
 CELL TYPE : comb
 CELL LOGIC : Y#Down=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS5D(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 pulldown	DN(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS5U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS5U(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVDS
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps


module INBUF_LVDS (PADP,PADN,Y);
  
    input PADP,PADN;
    output Y;
 reg NOTIFY_REG;
    reg temp;
 
   pmos p1(Y,temp,1'b0);
    always @(PADP or PADN) begin

    if ((PADP == 1'b1) && (PADN == 1'b0))
       temp = 1'b1;
    else if ((PADP == 1'b0) && (PADN == 1'b1))
       temp = 1'b0;
    else
       temp = 1'bx;
    end


    specify

         specparam   LibName       = "proasic3";
         specparam   InputLoad$PADP = 0;
         specparam   InputLoad$PADN = 0;
         specparam   OutputLoad$Y  = 0;

         specparam   MacroType = "inbuf_lvds";


        (PADP => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (PADN => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);

         $width(negedge PADP, 0.0, 0, NOTIFY_REG);
         $width(posedge PADP, 0.0, 0, NOTIFY_REG);
         $width(negedge PADN, 0.0, 0, NOTIFY_REG);
         $width(posedge PADN, 0.0, 0, NOTIFY_REG);


    endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVPECL
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVPECL (PADP,PADN,Y);
  
    input PADP,PADN;
    output Y;
 reg NOTIFY_REG;
    reg temp;

    pmos p1(Y,temp,1'b0);
    always @(PADP or PADN) begin

    if ((PADP == 1'b1) && (PADN == 1'b0))
       temp = 1'b1;
    else if ((PADP == 1'b0) && (PADN == 1'b1))
       temp = 1'b0;
    else
       temp = 1'bx;
    end


    specify

         specparam   LibName       = "proasic3";
         specparam   InputLoad$PADP = 0;
         specparam   InputLoad$PADN = 0;
         specparam   OutputLoad$Y  = 0;

         specparam   MacroType = "inbuf_lvpecl";


        (PADP => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (PADN => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);

         $width(negedge PADP, 0.0, 0, NOTIFY_REG);
         $width(posedge PADP, 0.0, 0, NOTIFY_REG);
         $width(negedge PADN, 0.0, 0, NOTIFY_REG);
         $width(posedge PADN, 0.0, 0, NOTIFY_REG);

    endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_PCI
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_PCI(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf    BUF_U_00(Y,PAD);

       specify

                specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam MacroType = "comb";

                //pin to pin path delay

                (PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_PCIX
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_PCIX(Y,PAD);
 input PAD;
 output Y;
 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INV
 CELL TYPE : comb
 CELL LOGIC : Y = !A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INV(Y,A);
 input A;
 output Y;

 not	INV_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MAJ3
 CELL TYPE : comb
 CELL LOGIC : Y = (A & B) + (B & C) + (A & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MAJ3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 and      U510(NET_0_0, A, B);
 or       U511(NET_0_2, NET_0_0, NET_0_1);
 and      U513(NET_0_1, B, C);
 or       U514(Y, NET_0_2, NET_0_3);
 and      U516(NET_0_3, A, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MAJ3X
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & !C + A & !B & C + !A & B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MAJ3X(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_93(A_, A);
 not	INV_94(B_, B);
 not	INV_95(C_, C);
 and      U521(NET_0_0, A, B);
 UDP_MUX2   U522(NET_0_4, NET_0_0, NET_0_5, C_);
 and      U525(NET_0_5, A_, B);
 or       U526(Y, NET_0_4, NET_0_3);
 and      U529(NET_0_2, A, B_);
 and      U530(NET_0_3, NET_0_2, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MAJ3XI
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B & !C + A & !B & C + !A & B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MAJ3XI(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_96(A_, A);
 not	INV_97(B_, B);
 not	INV_98(C_, C);
 and      U535(NET_0_0, A, B);
 UDP_MUX2   U536(NET_0_4, NET_0_0, NET_0_5, C_);
 and      U539(NET_0_5, A_, B);
 nor      U540(Y, NET_0_4, NET_0_3);
 and      U543(NET_0_2, A, B_);
 and      U544(NET_0_3, NET_0_2, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MIN3
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B + !A & !C + !B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MIN3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_99(A_, A);
 not	INV_100(B_, B);
 not	INV_101(C_, C);
 and      U549(NET_0_0, A_, B_);
 or       U550(NET_0_2, NET_0_0, NET_0_1);
 and      U552(NET_0_1, A_, C_);
 or       U553(Y, NET_0_2, NET_0_3);
 and      U555(NET_0_3, B_, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MIN3X
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B & !C + !A & B & !C + !A & !B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MIN3X(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_102(A_, A);
 not	INV_103(B_, B);
 not	INV_104(C_, C);
 and      U560(NET_0_0, A, B_);
 UDP_MUX2   U561(NET_0_4, NET_0_0, NET_0_5, C_);
 and      U564(NET_0_5, A_, B_);
 or       U565(Y, NET_0_4, NET_0_3);
 and      U568(NET_0_2, A_, B);
 and      U569(NET_0_3, NET_0_2, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MIN3XI
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & !B & !C + !A & B & !C + !A & !B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MIN3XI(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_105(A_, A);
 not	INV_106(B_, B);
 not	INV_107(C_, C);
 and      U574(NET_0_0, A, B_);
 UDP_MUX2   U575(NET_0_4, NET_0_0, NET_0_5, C_);
 and      U578(NET_0_5, A_, B_);
 nor      U579(Y, NET_0_4, NET_0_3);
 and      U582(NET_0_2, A_, B);
 and      U583(NET_0_3, NET_0_2, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MX2
 CELL TYPE : comb
 CELL LOGIC : Y = (A & !S) + (B & S)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MX2(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_110(S_, S);
 UDP_MUX2   U594(Y, A, B, S_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MX2A
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & !S) + (B & S)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MX2A(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_111(A_, A);
 not	INV_112(S_, S);
 UDP_MUX2   U598(Y, A_, B, S_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MX2B
 CELL TYPE : comb
 CELL LOGIC : Y = (A & !S) + (!B & S)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MX2B(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_113(S_, S);
 not	INV_114(B_, B);
 UDP_MUX2   U602(Y, A, B_, S_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MX2C
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & !S) + (!B & S)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MX2C(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_115(A_, A);
 not	INV_116(S_, S);
 not	INV_117(B_, B);
 UDP_MUX2   U606(Y, A_, B_, S_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND2
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND2(Y,A,B);
 input A,B;
 output Y;

 nand     U610(Y, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND2A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND2A(Y,A,B);
 input A,B;
 output Y;

 not	INV_118(A_, A);
 nand     U613(Y, A_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND2B
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND2B(Y,A,B);
 input A,B;
 output Y;

 not	INV_119(A_, A);
 not	INV_120(B_, B);
 nand     U616(Y, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U620(NET_0_0, A, B);
 nand     U621(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_121(A_, A);
 and      U625(NET_0_0, A_, B);
 nand     U626(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3B
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_122(A_, A);
 not	INV_123(B_, B);
 and      U630(NET_0_0, A_, B_);
 nand     U631(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3C
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_124(A_, A);
 not	INV_125(B_, B);
 not	INV_126(C_, C);
 and      U635(NET_0_0, A_, B_);
 nand     U636(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR2
 CELL TYPE : comb
 CELL LOGIC : Y = !(A + B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR2(Y,A,B);
 input A,B;
 output Y;

 nor      U649(Y, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR2A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR2A(Y,A,B);
 input A,B;
 output Y;

 not	INV_130(A_, A);
 nor      U652(Y, A_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR2B
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + !B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR2B(Y,A,B);
 input A,B;
 output Y;

 not	INV_131(A_, A);
 not	INV_132(B_, B);
 nor      U655(Y, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3
 CELL TYPE : comb
 CELL LOGIC : Y = !(A + B + C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 or       U662(NET_0_0, A, B);
 nor      U663(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + B + C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_134(A_, A);
 or       U667(NET_0_0, A_, B);
 nor      U668(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3B
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + !B + C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_135(A_, A);
 not	INV_136(B_, B);
 or       U672(NET_0_0, A_, B_);
 nor      U673(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3C
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + !B + !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_137(A_, A);
 not	INV_138(B_, B);
 not	INV_139(C_, C);
 or       U677(NET_0_0, A_, B_);
 nor      U678(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA1
 CELL TYPE : comb
 CELL LOGIC : Y = (A + B) & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 or       U692(NET_0_0, A, B);
 and      U693(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA1A
 CELL TYPE : comb
 CELL LOGIC : Y = (!A + B) & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_143(A_, A);
 or       U697(NET_0_0, A_, B);
 and      U698(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA1B
 CELL TYPE : comb
 CELL LOGIC : Y = !C & (A + B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA1B(Y,C,A,B);
 input C,A,B;
 output Y;
 wire NET_0_0;

 not	INV_144(C_, C);
 and      U701(Y, C_, NET_0_0);
 or       U703(NET_0_0, A, B);

       specify

		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA1C
 CELL TYPE : comb
 CELL LOGIC : Y = (!A + B) & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA1C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_145(A_, A);
 not	INV_146(C_, C);
 or       U707(NET_0_0, A_, B);
 and      U708(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OAI1
 CELL TYPE : comb
 CELL LOGIC : Y = !((A + B) & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OAI1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 or       U732(NET_0_0, A, B);
 nand     U733(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR2
 CELL TYPE : comb
 CELL LOGIC : Y = A + B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR2(Y,A,B);
 input A,B;
 output Y;

 or       U756(Y, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR2A
 CELL TYPE : comb
 CELL LOGIC : Y = !A + B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR2A(Y,A,B);
 input A,B;
 output Y;

 not	INV_156(A_, A);
 or       U759(Y, A_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR2B
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR2B(Y,A,B);
 input A,B;
 output Y;

 not	INV_157(A_, A);
 not	INV_158(B_, B);
 or       U762(Y, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3
 CELL TYPE : comb
 CELL LOGIC : Y = A + B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 or       U769(NET_0_0, A, B);
 or       U770(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3A
 CELL TYPE : comb
 CELL LOGIC : Y = !A + B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_160(A_, A);
 or       U774(NET_0_0, A_, B);
 or       U775(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3B
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_161(A_, A);
 not	INV_162(B_, B);
 or       U779(NET_0_0, A_, B_);
 or       U780(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3C
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_163(A_, A);
 not	INV_164(B_, B);
 not	INV_165(C_, C);
 or       U784(NET_0_0, A_, B_);
 or       U785(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_F_12
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_F_12(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_F_16
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_F_16(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_F_8
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_F_8(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_F_24
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_F_24(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf    BUF_U_00(PAD,D);

       specify

                specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
                specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
                specparam MacroType = "comb";

                //pin to pin path delay

                (D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_LVCMOS15
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_LVCMOS15(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_LVCMOS18
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_LVCMOS18(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_LVCMOS25
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_LVCMOS25(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_LVCMOS33
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_LVCMOS33(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf    BUF_U_00(PAD,D);

      specify

        specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
        specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
        specparam MacroType = "comb";

        //pin to pin path delay

        (D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_LVCMOS5
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_LVCMOS5(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_LVDS
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_LVDS(D, PADP,PADN);

input   D;
output  PADP,PADN;
 reg NOTIFY_REG;


        buf b1(PADP,D);
        not n1(PADN,D);

specify

         specparam   LibName        = "proasic3";
         specparam   InputLoad$D    = 1;
         specparam   OutputLoad$PADP = 0;
         specparam   OutputLoad$PADN = 0;
         specparam   MacroType      = "io";

        (D => PADP) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (D => PADN) = (0.1:0.1:0.1, 0.1:0.1:0.1);

         $width(negedge D, 0.0, 0, NOTIFY_REG);
         $width(posedge D, 0.0, 0, NOTIFY_REG);


endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_LVPECL
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_LVPECL(D, PADP,PADN);

input   D;
output  PADP,PADN;
 reg NOTIFY_REG;


        buf b1(PADP,D);
        not n1(PADN,D);
specify

         specparam   LibName        = "proasic3";
         specparam   InputLoad$D    = 1;
         specparam   OutputLoad$PADP = 0;
         specparam   OutputLoad$PADN = 0;
         specparam   MacroType      = "io";

        (D => PADP) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (D => PADN) = (0.1:0.1:0.1, 0.1:0.1:0.1);

         $width(negedge D, 0.0, 0, NOTIFY_REG);
         $width(posedge D, 0.0, 0, NOTIFY_REG);


endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_PCI
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_PCI(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_PCIX
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_PCIX(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_S_12
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_S_12(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_S_16
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_S_16(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_S_8
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_S_8(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_S_24
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_S_24(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf    BUF_U_00(PAD,D);

       specify

                specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
                specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
                specparam MacroType = "comb";

                //pin to pin path delay

                (D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U798(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_12
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_12(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U801(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_12D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_12D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U804(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_12U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_12U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U807(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_16
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_16(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U810(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_16D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_16D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U813(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_16U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_16U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U816(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_8
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_8(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U828(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_8D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_8D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U831(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_8U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_8U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U834(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_24
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_24(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U819(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_24D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_24D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U822(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_24U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_24U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U825(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS15
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS15(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U846(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS15D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS15D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U849(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS15U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS15U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U852(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS18
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS18(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U855(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS18D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS18D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U858(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS18U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS18U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U861(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS25
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS25(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U864(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS25D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS25D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U867(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS25U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS25U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U870(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS33
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS33(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U11(PAD, D, E);

      specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
        specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
        specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
        specparam MacroType = "comb";

        //pin to pin path delay

      //if(~D)
        (E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS33D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS33D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U14(PAD, D, E);

      specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
        specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
        specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
        specparam MacroType = "comb";

        //pin to pin path delay

      //if(~D)
        (E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS33U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS33U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U17(PAD, D, E);

      specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
        specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
        specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
        specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
        specparam MacroType = "comb";

        //pin to pin path delay

      //if(~D)
        (E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults




/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS5
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS5(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U873(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS5D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS5D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U876(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS5U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS5U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U879(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVDS
 CELL TYPE : comb
 CELL LOGIC : PADP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVDS(PADP,PADN,D,E);
 input D,E;
 output PADP,PADN;
 reg NOTIFY_REG;

 bufif1   U99(PADP, D, E);
 not      U98(D_tmp, D);
 bufif1   U97(PADN, D_tmp, E);

      specify

	specparam tpdLH_E_to_PADP = (0.1:0.1:0.1);
	specparam tpdHL_E_to_PADP = (0.1:0.1:0.1);
        specparam tpdLZ_E_to_PADP = (0.1:0.1:0.1);
        specparam tpdZL_E_to_PADP = (0.1:0.1:0.1);
        specparam tpdHZ_E_to_PADP = (0.1:0.1:0.1);
        specparam tpdZH_E_to_PADP = (0.1:0.1:0.1);
	specparam tpdLH_E_to_PADN = (0.1:0.1:0.1);
	specparam tpdHL_E_to_PADN = (0.1:0.1:0.1);
        specparam tpdLZ_E_to_PADN = (0.1:0.1:0.1);
        specparam tpdZL_E_to_PADN = (0.1:0.1:0.1);
        specparam tpdHZ_E_to_PADN = (0.1:0.1:0.1);
        specparam tpdZH_E_to_PADN = (0.1:0.1:0.1);
        specparam tpdLH_D_to_PADP = (0.1:0.1:0.1);
        specparam tpdHL_D_to_PADP = (0.1:0.1:0.1);
        specparam tpdLH_D_to_PADN = (0.1:0.1:0.1);
        specparam tpdHL_D_to_PADN = (0.1:0.1:0.1);
        specparam MacroType = "comb";

        //pin to pin path delay 

        //if(~D)
        (E => PADP ) = ( tpdLH_E_to_PADP,tpdHL_E_to_PADP,tpdLZ_E_to_PADP,tpdZH_E_to_PADP,tpdHZ_E_to_PADP,tpdZL_E_to_PADP);
        (E => PADN ) = ( tpdLH_E_to_PADN,tpdHL_E_to_PADN,tpdLZ_E_to_PADN,tpdZH_E_to_PADN,tpdHZ_E_to_PADN,tpdZL_E_to_PADN);

        (D => PADP ) = ( tpdLH_D_to_PADP,tpdHL_D_to_PADP);
        (D => PADN ) = ( tpdLH_D_to_PADN,tpdHL_D_to_PADN);

        $width(negedge D, 0.0, 0, NOTIFY_REG);
        $width(posedge D, 0.0, 0, NOTIFY_REG);
        $width(negedge E, 0.0, 0, NOTIFY_REG);
        $width(posedge E, 0.0, 0, NOTIFY_REG);


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_PCI
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_PCI(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U882(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_PCIX
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_PCIX(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U885(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_12
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_12(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U900(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_12D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_12D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U903(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_12U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_12U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U906(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_16
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_16(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U909(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_16D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_16D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U912(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_16U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_16U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U915(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_8
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_8(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U927(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_8D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_8D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U930(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_8U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_8U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U933(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_24
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_24(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U918(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_24D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_24D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U921(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_24U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_24U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U924(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : VCC
 CELL TYPE : comb
 CELL LOGIC : Y=1
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module VCC(Y);
 output Y;

 supply1    Y;

       specify

		specparam MacroType = "comb";

		//pin to pin path delay 

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XA1
 CELL TYPE : comb
 CELL LOGIC : Y = (A ^ B) & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XA1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_169(A_, A);
 not	INV_170(B_, B);
 UDP_MUX2   U937(NET_0_0, B, B_, A_);
 and      U939(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XA1A
 CELL TYPE : comb
 CELL LOGIC : Y = !(A ^ B) & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XA1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_171(A_, A);
 not	INV_172(B_, B);
 UDPN_MUX2  U943(NET_0_0, B, B_, A_);
 and      U945(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XA1B
 CELL TYPE : comb
 CELL LOGIC : Y = (A ^ B) & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XA1B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_173(A_, A);
 not	INV_174(B_, B);
 not	INV_175(C_, C);
 UDP_MUX2   U949(NET_0_0, B, B_, A_);
 and      U951(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XA1C
 CELL TYPE : comb
 CELL LOGIC : Y = !(A ^ B) & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XA1C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_176(A_, A);
 not	INV_177(B_, B);
 not	INV_178(C_, C);
 UDPN_MUX2  U955(NET_0_0, B, B_, A_);
 and      U957(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XAI1
 CELL TYPE : comb
 CELL LOGIC : Y = !((A ^ B) & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XAI1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_179(A_, A);
 not	INV_180(B_, B);
 UDP_MUX2   U961(NET_0_0, B, B_, A_);
 nand     U963(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XAI1A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!(A ^ B) & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XAI1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_181(A_, A);
 not	INV_182(B_, B);
 UDPN_MUX2  U967(NET_0_0, B, B_, A_);
 nand     U969(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XNOR2
 CELL TYPE : comb
 CELL LOGIC : Y = !(A ^ B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XNOR2(Y,A,B);
 input A,B;
 output Y;

 not	INV_183(A_, A);
 not	INV_184(B_, B);
 UDPN_MUX2  U972(Y, B, B_, A_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XNOR3
 CELL TYPE : comb
 CELL LOGIC : Y = !(A ^ B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XNOR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_187(A_, A);
 not	INV_188(B_, B);
 UDP_MUX2   U981(NET_0_0, B, B_, A_);
 xnor     U983(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XO1
 CELL TYPE : comb
 CELL LOGIC : Y = (A ^ B) + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XO1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_189(A_, A);
 not	INV_190(B_, B);
 UDP_MUX2   U987(NET_0_0, B, B_, A_);
 or       U989(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XO1A
 CELL TYPE : comb
 CELL LOGIC : Y = !(A ^ B) + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XO1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_191(A_, A);
 not	INV_192(B_, B);
 UDPN_MUX2  U993(NET_0_0, B, B_, A_);
 or       U995(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XOR2
 CELL TYPE : comb
 CELL LOGIC : Y = A ^ B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XOR2(Y,A,B);
 input A,B;
 output Y;

 not	INV_193(A_, A);
 not	INV_194(B_, B);
 UDP_MUX2   U998(Y, B, B_, A_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XOR3
 CELL TYPE : comb
 CELL LOGIC : Y = A ^ B ^ C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XOR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_197(A_, A);
 not	INV_198(B_, B);
 UDP_MUX2   U1007(NET_0_0, B, B_, A_);
 xor      U1009(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : ZOR3
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & C + !A & !B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module ZOR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_199(A_, A);
 not	INV_200(B_, B);
 not	INV_201(C_, C);
 and      U1013(NET_0_0, A, B);
 UDP_MUX2   U1014(Y, NET_0_0, NET_0_2, C);
 and      U1017(NET_0_2, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : ZOR3I
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B & C + !A & !B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module ZOR3I(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_202(A_, A);
 not	INV_203(B_, B);
 not	INV_204(C_, C);
 and      U1021(NET_0_0, A, B);
 UDPN_MUX2  U1022(Y, NET_0_0, NET_0_2, C);
 and      U1025(NET_0_2, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BUFF
 CELL TYPE : comb
 CELL LOGIC : Y = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BUFF(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKINT
 CELL TYPE : comb
 CELL LOGIC : Y = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKINT(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOIN_IB
 CELL TYPE : comb
 CELL LOGIC : Y = YIN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOIN_IB(Y,YIN);
 input YIN;
 output Y;

 buf	BUF_U_00(Y,YIN);

       specify

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOIN_IRC
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Y,CLK =ICLK, CLR=CLR, D=YIN ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOIN_IRC(CLR, ICLK, Y,YIN);
 input YIN,CLR,ICLK;
 output Y;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(Y, YIN,ICLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,_CLR0);
       buf U_c2 (Enable02, _CLR0);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable01, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable01, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge ICLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOIN_IRP
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Y,CLK =ICLK, PRE=PRE, D=YIN ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOIN_IRP(PRE, ICLK, Y,YIN);
 input YIN,PRE,ICLK;
 output Y;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpr DF_0(Y, YIN,ICLK,VCC_0, PRE_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, _PRE0);
       buf U_c4 (Enable04, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable01, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable01, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge ICLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOIN_IREC
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Y,CLK =ICLK, E=ICE, CLR=CLR, D=YIN ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOIN_IREC(CLR, ICE, ICLK, Y,YIN);
 input YIN,CLR,ICE,ICLK;
 output Y;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);
 not INV_EN_0(ICE_0, ICE);

 Dffpr DF_0(Y, YIN,ICLK,CLR_0, VCC_0, ICE_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, ICE, _CLR0);
      and U_c2 (Enable02, ICE, _CLR0);
      buf U_c4 (Enable04, ICE);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable01, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable01, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable05, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable05, negedge ICE,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOIN_IREP
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Y,CLK =ICLK, E=ICE, PRE=PRE, D=YIN ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOIN_IREP(PRE, ICE, ICLK, Y,YIN);
 input YIN,PRE,ICE,ICLK;
 output Y;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);
 not INV_EN_0(ICE_0, ICE);

 Dffpr DF_0(Y, YIN,ICLK,VCC_0, PRE_0, ICE_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, ICE, _PRE0);
      buf U_c2 (Enable02, ICE);
      and U_c4 (Enable04, ICE, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable01, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable01, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable05, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable05, negedge ICE,0.0, NOTIFY_REG);

	$hold(posedge ICLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOTRI_OB_EB
 CELL TYPE : comb
 CELL LOGIC : DOUT=D;EOUT=E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OB_EB(DOUT,EOUT,D,E);
 input D,E;
 output DOUT,EOUT;

 buf	BUF_U_00(DOUT,D);
 buf	BUF_U_01(EOUT,E);

       specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
		specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );
		(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOTRI_OB_ERC
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=EOUT,CLK =OCLK, CLR=CLR, D=E ];
 CELL COMB EQN : "DOUT = D"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OB_ERC(CLR, OCLK, EOUT,DOUT,E,D);
 input E,D,CLR,OCLK;
 output EOUT,DOUT;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 

 buf BUF_DOUT_0(DOUT,D);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(EOUT, E,OCLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,_CLR0);
       buf U_c2 (Enable02, _CLR0);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_D_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	(D => DOUT) = (tpdLH_D_to_DOUT, tpdHL_D_to_DOUT);

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOTRI_OB_ERP
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=EOUT,CLK =OCLK, PRE=PRE, D=E ];
 CELL COMB EQN : "DOUT = D"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OB_ERP(PRE, OCLK, EOUT,DOUT,E,D);
 input E,D,PRE,OCLK;
 output EOUT,DOUT;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 

 buf BUF_DOUT_0(DOUT,D);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 not INV_PRE_0(PRE_0, PRE);

 Dffpr DF_0(EOUT, E,OCLK,VCC_0, PRE_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, _PRE0);
       buf U_c4 (Enable04, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_D_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	(D => DOUT) = (tpdLH_D_to_DOUT, tpdHL_D_to_DOUT);

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge OCLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOTRI_OB_EREC
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=EOUT,CLK =OCLK, E=OCE, CLR=CLR, D=E ];
 CELL COMB EQN : "DOUT = D"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OB_EREC(CLR, OCE, OCLK, EOUT,DOUT,E,D);
 input E,D,CLR,OCE,OCLK;
 output EOUT,DOUT;
 supply1 VCC_0;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 

 buf BUF_DOUT_0(DOUT,D);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 not INV_CLR_0(CLR_0, CLR);
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(EOUT, E,OCLK,CLR_0, VCC_0, OCE_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, OCE, _CLR0);
      and U_c2 (Enable02, OCE, _CLR0);
      buf U_c4 (Enable04, OCE);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_D_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	(D => DOUT) = (tpdLH_D_to_DOUT, tpdHL_D_to_DOUT);

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, negedge OCE,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOTRI_OB_EREP
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=EOUT,CLK =OCLK, E=OCE, PRE=PRE, D=E ];
 CELL COMB EQN : "DOUT = D"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OB_EREP(PRE, OCE, OCLK, EOUT,DOUT,E,D);
 input E,D,PRE,OCE,OCLK;
 output EOUT,DOUT;
 supply1 VCC_0;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 

 buf BUF_DOUT_0(DOUT,D);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 not INV_PRE_0(PRE_0, PRE);
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(EOUT, E,OCLK,VCC_0, PRE_0, OCE_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, OCE, _PRE0);
      buf U_c2 (Enable02, OCE);
      and U_c4 (Enable04, OCE, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_D_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	(D => DOUT) = (tpdLH_D_to_DOUT, tpdHL_D_to_DOUT);

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, negedge OCE,0.0, NOTIFY_REG);

	$hold(posedge OCLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOTRI_ORC_EB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=DOUT,CLK =OCLK, CLR=CLR, D=D ];
 CELL COMB EQN : "EOUT = E"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_ORC_EB(CLR, OCLK, DOUT,EOUT,D,E);
 input D,E,CLR,OCLK;
 output DOUT,EOUT;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 

 buf BUF_EOUT_0(EOUT,E);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(DOUT, D,OCLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,_CLR0);
       buf U_c2 (Enable02, _CLR0);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	(E => EOUT) = (tpdLH_E_to_EOUT, tpdHL_E_to_EOUT);

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOTRI_ORP_EB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=DOUT,CLK =OCLK, PRE=PRE, D=D ];
 CELL COMB EQN : "EOUT = E"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_ORP_EB(PRE, OCLK, DOUT,EOUT,D,E);
 input D,E,PRE,OCLK;
 output DOUT,EOUT;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 

 buf BUF_EOUT_0(EOUT,E);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 not INV_PRE_0(PRE_0, PRE);

 Dffpr DF_0(DOUT, D,OCLK,VCC_0, PRE_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, _PRE0);
       buf U_c4 (Enable04, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	(E => EOUT) = (tpdLH_E_to_EOUT, tpdHL_E_to_EOUT);

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge OCLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOTRI_OREC_EB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=DOUT,CLK =OCLK, E=OCE, CLR=CLR, D=D ];
 CELL COMB EQN : "EOUT = E"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OREC_EB(CLR, OCE, OCLK, DOUT,EOUT,D,E);
 input D,E,CLR,OCE,OCLK;
 output DOUT,EOUT;
 supply1 VCC_0;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 

 buf BUF_EOUT_0(EOUT,E);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 not INV_CLR_0(CLR_0, CLR);
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(DOUT, D,OCLK,CLR_0, VCC_0, OCE_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, OCE, _CLR0);
      and U_c2 (Enable02, OCE, _CLR0);
      buf U_c4 (Enable04, OCE);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	(E => EOUT) = (tpdLH_E_to_EOUT, tpdHL_E_to_EOUT);

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, negedge OCE,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK &&& Enable04, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOTRI_OREP_EB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=DOUT,CLK =OCLK, E=OCE, PRE=PRE, D=D ];
 CELL COMB EQN : "EOUT = E"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OREP_EB(PRE, OCE, OCLK, DOUT,EOUT,D,E);
 input D,E,PRE,OCE,OCLK;
 output DOUT,EOUT;
 supply1 VCC_0;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 

 buf BUF_EOUT_0(EOUT,E);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 not INV_PRE_0(PRE_0, PRE);
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(DOUT, D,OCLK,VCC_0, PRE_0, OCE_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, OCE, _PRE0);
      buf U_c2 (Enable02, OCE);
      and U_c4 (Enable04, OCE, _PRE0);
       buf U_c6 (Enable05, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	(E => EOUT) = (tpdLH_E_to_EOUT, tpdHL_E_to_EOUT);

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, negedge OCE,0.0, NOTIFY_REG);

	$hold(posedge OCLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK &&& Enable02, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOTRI_ORC_ERC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_ORC_ERC(DOUT,EOUT,D,OCLK,CLR,E);
 input D,OCLK,CLR,E;
 output DOUT,EOUT;
 supply1 VCC_0;
 supply0 GND_0;

 supply1 VCC_1;
 supply0 GND_1;


 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(DOUT, D,OCLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);

 not INV_CLR_1(CLR_1, CLR);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, GND_1, NOTIFY_REG);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& ~CLR, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& ~CLR, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& ~CLR, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& ~CLR, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& ~CLR ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& ~CLR, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& ~CLR, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& ~CLR, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& ~CLR, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& ~CLR, negedge E,0.0, NOTIFY_REG);



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOTRI_OREC_EREC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OREC_EREC(DOUT,EOUT,D,OCLK,CLR,OCE,E);
 input D,OCLK,CLR,OCE,E;
 output DOUT,EOUT;
 supply1 VCC_0;

 supply1 VCC_1;


 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(DOUT, D,OCLK,CLR_0, VCC_0, OCE_0, NOTIFY_REG);

 not INV_CLR_1(CLR_1, CLR);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, OCE_1, NOTIFY_REG);


// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, OCE, _CLR0);
      and U_c2 (Enable02, OCE, _CLR0);
      buf U_c4 (Enable04, OCE);
      buf U_c6 (Enable05, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, negedge OCE,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK &&& Enable04, 0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOTRI_ORP_ERP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_ORP_ERP(DOUT,EOUT,D,OCLK,PRE,E);
 input D,OCLK,PRE,E;
 output DOUT,EOUT;
 supply1 VCC_0;
 supply0 GND_0;

 supply1 VCC_1;
 supply0 GND_1;


 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpr DF_0(DOUT, D,OCLK,VCC_0, PRE_0, GND_0, NOTIFY_REG);

 not INV_PRE_1(PRE_1, PRE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, GND_1, NOTIFY_REG);


// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, _PRE0);
      buf U_c4 (Enable04, _PRE0);
      buf U_c6 (Enable05, _PRE0);





//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK, 0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOTRI_OREP_EREP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OREP_EREP(DOUT,EOUT,D,OCLK,OCE,PRE,E);
 input D,OCLK,OCE,PRE,E;
 output DOUT,EOUT;
 supply1 VCC_0;

 supply1 VCC_1;


 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(DOUT, D,OCLK,VCC_0, PRE_0, OCE_0, NOTIFY_REG);

 not INV_PRE_1(PRE_1, PRE);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, OCE_1, NOTIFY_REG);


// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, OCE, _PRE0);
      buf U_c2 (Enable02, OCE);
      and U_c4 (Enable04, OCE, _PRE0);
       buf U_c6 (Enable05, _PRE0);




//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, negedge OCE,0.0, NOTIFY_REG);

	$hold(posedge OCLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK &&& Enable02, 0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, negedge OCE,0.0, NOTIFY_REG);



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_OB_EB
 CELL TYPE : comb
 CELL LOGIC : DOUT=D;EOUT=E;Y=YIN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OB_EB(DOUT,EOUT,Y,D,E,YIN);
 input D,E,YIN;
 output DOUT,EOUT,Y;

 buf	BUF_U_00(DOUT,D);
 buf	BUF_U_01(EOUT,E);
 buf	BUF_U_02(Y,YIN);

       specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
		specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);
		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );
		(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );
		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_OB_ERC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OB_ERC(DOUT,EOUT,Y,D,E,OCLK,CLR,YIN);
 input D,E,OCLK,CLR,YIN;
 output DOUT,EOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;



 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_CLR_1(CLR_1, CLR);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, GND_1, NOTIFY_REG);

 buf	BUF_U_20(Y,YIN);



// some temp signals created for timing checking sections

      not U1_I2 (_CLR1, CLR);
      buf U_c0 (Enable11,_CLR1);
       buf U_c2 (Enable12, _CLR1);
      buf U_c6 (Enable15, _CLR1);




//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);


		//pin to pin path delay 

		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_OB_EREC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OB_EREC(DOUT,EOUT,Y,D,E,OCLK,CLR,OCE,YIN);
 input D,E,OCLK,CLR,OCE,YIN;
 output DOUT,EOUT,Y;

 supply1 VCC_1;



 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_CLR_1(CLR_1, CLR);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, OCE_1, NOTIFY_REG);

 buf	BUF_U_20(Y,YIN);



// some temp signals created for timing checking sections

      not U1_I2 (_CLR1, CLR);
      and U_c0 (Enable11, OCE, _CLR1);
      and U_c2 (Enable12, OCE, _CLR1);
      buf U_c4 (Enable14, OCE);
      buf U_c6 (Enable15, _CLR1);




//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

        	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
        	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	        specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	        specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable15,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable15, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, negedge OCE,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable14, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK &&& Enable14, 0.0, NOTIFY_REG);


		//pin to pin path delay 

		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_OB_ERP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OB_ERP(DOUT,EOUT,Y,D,E,OCLK,PRE,YIN);
 input D,E,OCLK,PRE,YIN;
 output DOUT,EOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;



 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_PRE_1(PRE_1, PRE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, GND_1, NOTIFY_REG);

 buf	BUF_U_20(Y,YIN);



// some temp signals created for timing checking sections

      not U1_I1 (_PRE1, PRE);
      buf U_c0 (Enable11, _PRE1);
      buf U_c4 (Enable14, _PRE1);
      buf U_c6 (Enable15, _PRE1);




//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

		specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
		specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
		specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
		specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge OCLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK, 0.0, NOTIFY_REG);


		//pin to pin path delay 

		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_OB_EREP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OB_EREP(DOUT,EOUT,Y,D,E,OCLK,OCE,PRE,YIN);
 input D,E,OCLK,OCE,PRE,YIN;
 output DOUT,EOUT,Y;

 supply1 VCC_1;



 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_PRE_1(PRE_1, PRE);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, OCE_1, NOTIFY_REG);

 buf	BUF_U_20(Y,YIN);



// some temp signals created for timing checking sections

      not U1_I1 (_PRE1, PRE);
      and U_c0 (Enable11, OCE, _PRE1);
      buf U_c2 (Enable12, OCE);
      and U_c4 (Enable14, OCE, _PRE1);
       buf U_c6 (Enable15, _PRE1);




//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

		specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
		specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
		specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
		specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable15,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable15, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, negedge OCE,0.0, NOTIFY_REG);

	$hold(posedge OCLK &&& Enable12, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK &&& Enable12, 0.0, NOTIFY_REG);


		//pin to pin path delay 

		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : IOBI_IB_OD_EB
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OD_EB(DR, DF, CLR, E, OCLK, YIN, DOUT, EOUT, Y);
input DR, DF, CLR, E, OCLK, YIN;
output DOUT, EOUT, Y;

wire tmp1_zd, tmp2_zd;
supply1 VCC;
supply0 GND;

reg NOTIFY_REG;

    buf buf_D(Y, YIN);
    buf buf_E(EOUT, E);
 
    not INV_CLR(CLR_, CLR);
    Dffpr DF_1(tmp1_zd, DR, OCLK, CLR_, VCC, GND, NOTIFY_REG);
    Dffpr DF_2(tmp2_zd, DF, OCLK, CLR_, VCC, GND, NOTIFY_REG);
    UDP_MUX2 mux1(DOUT, tmp1_zd, tmp2_zd , OCLK);

    specify

        //check timing delay for output

        (YIN => Y )  = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (E => EOUT ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        
        (posedge CLR  => (DOUT +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (OCLK => DOUT)=(0.1:0.1:0.1, 0.1:0.1:0.1);
        //(posedge OCLK => (DOUT +: DR))   = (0.1:0.1:0.1, 0.1:0.1:0.1);
        //(negedge OCLK => (DOUT +: DF))   = (0.1:0.1:0.1, 0.1:0.1:0.1);

        //checking setup and hold timing for inputs

        $setup(posedge DR, posedge OCLK, 0.0, NOTIFY_REG);
        $setup(negedge DR, posedge OCLK, 0.0, NOTIFY_REG);
        $hold(posedge OCLK, posedge DR, 0.0, NOTIFY_REG);
        $hold(posedge OCLK, negedge DR, 0.0, NOTIFY_REG);

        $setup(posedge DF, posedge OCLK, 0.0, NOTIFY_REG);
        $setup(negedge DF, posedge OCLK, 0.0, NOTIFY_REG);
        $hold(posedge OCLK, posedge DF, 0.0, NOTIFY_REG);
        $hold(posedge OCLK, negedge DF, 0.0, NOTIFY_REG);

        $recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);
        $hold(posedge OCLK, negedge CLR, 0.0, NOTIFY_REG);

        //checking the pulse width

        $width(posedge OCLK, 0, 0, NOTIFY_REG);
        $width(negedge OCLK, 0, 0, NOTIFY_REG);
        $width(posedge CLR,  0, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_ORC_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_ORC_EB(EOUT,DOUT,Y,E,D,OCLK,CLR,YIN);
 input E,D,OCLK,CLR,YIN;
 output EOUT,DOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;



 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);

 not INV_CLR_1(CLR_1, CLR);

 Dffpr DF_1(DOUT, D,OCLK,CLR_1, VCC_1, GND_1, NOTIFY_REG);

 buf	BUF_U_20(Y,YIN);



// some temp signals created for timing checking sections

      not U1_I2 (_CLR1, CLR);
      buf U_c0 (Enable11,_CLR1);
       buf U_c2 (Enable12, _CLR1);
      buf U_c6 (Enable15, _CLR1);




//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
		specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

		specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
		specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
		specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
		specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );




	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);


		//pin to pin path delay 

		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_OREC_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OREC_EB(EOUT,DOUT,Y,E,D,OCLK,CLR,OCE,YIN);
 input E,D,OCLK,CLR,OCE,YIN;
 output EOUT,DOUT,Y;

 supply1 VCC_1;



 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);

 not INV_CLR_1(CLR_1, CLR);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(DOUT, D,OCLK,CLR_1, VCC_1, OCE_1, NOTIFY_REG);

 buf	BUF_U_20(Y,YIN);



// some temp signals created for timing checking sections

      not U1_I2 (_CLR1, CLR);
      and U_c0 (Enable11, OCE, _CLR1);
      and U_c2 (Enable12, OCE, _CLR1);
      buf U_c4 (Enable14, OCE);
      buf U_c6 (Enable15, _CLR1);




//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
		specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	        specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
         	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	        specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
		specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );




	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable15,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable15, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, negedge OCE,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable14, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK &&& Enable14, 0.0, NOTIFY_REG);


		//pin to pin path delay 

		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_ORP_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_ORP_EB(EOUT,DOUT,Y,E,D,OCLK,PRE,YIN);
 input E,D,OCLK,PRE,YIN;
 output EOUT,DOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;



 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);

 not INV_PRE_1(PRE_1, PRE);

 Dffpr DF_1(DOUT, D,OCLK,VCC_1, PRE_1, GND_1, NOTIFY_REG);

 buf	BUF_U_20(Y,YIN);



// some temp signals created for timing checking sections

      not U1_I1 (_PRE1, PRE);
      buf U_c0 (Enable11, _PRE1);
       buf U_c4 (Enable14, _PRE1);
       buf U_c6 (Enable15, _PRE1);




//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
		specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

		specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
		specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
		specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
		specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );




	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge OCLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK, 0.0, NOTIFY_REG);


		//pin to pin path delay 

		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_OREP_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OREP_EB(EOUT,DOUT,Y,E,D,OCLK,OCE,PRE,YIN);
 input E,D,OCLK,OCE,PRE,YIN;
 output EOUT,DOUT,Y;

 supply1 VCC_1;



 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);

 not INV_PRE_1(PRE_1, PRE);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(DOUT, D,OCLK,VCC_1, PRE_1, OCE_1, NOTIFY_REG);

 buf	BUF_U_20(Y,YIN);



// some temp signals created for timing checking sections

      not U1_I1 (_PRE1, PRE);
      and U_c0 (Enable11, OCE, _PRE1);
      buf U_c2 (Enable12, OCE);
      and U_c4 (Enable14, OCE, _PRE1);
       buf U_c6 (Enable15, _PRE1);




//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
		specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

		specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
		specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
		specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
		specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );




	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable15,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable15, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, negedge OCE,0.0, NOTIFY_REG);

	$hold(posedge OCLK &&& Enable12, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK &&& Enable12, 0.0, NOTIFY_REG);


		//pin to pin path delay 

		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_ORC_ERC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_ORC_ERC(DOUT,EOUT,Y,D,OCLK,CLR,E,YIN);
 input D,OCLK,CLR,E,YIN;
 output DOUT,EOUT,Y;
 supply1 VCC_0;
 supply0 GND_0;

 supply1 VCC_1;
 supply0 GND_1;



 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(DOUT, D,OCLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);

 not INV_CLR_1(CLR_1, CLR);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, GND_1, NOTIFY_REG);

 buf	BUF_U_20(Y,YIN);


// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,_CLR0);
      buf U_c2 (Enable02, _CLR0);
      buf U_c6 (Enable05, _CLR0);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

	specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
	specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);


		//pin to pin path delay 

	(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_OREC_EREC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OREC_EREC(DOUT,EOUT,Y,D,OCLK,CLR,OCE,E,YIN);
 input D,OCLK,CLR,OCE,E,YIN;
 output DOUT,EOUT,Y;
 supply1 VCC_0;

 supply1 VCC_1;



 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(DOUT, D,OCLK,CLR_0, VCC_0, OCE_0, NOTIFY_REG);

 not INV_CLR_1(CLR_1, CLR);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, OCE_1, NOTIFY_REG);

 buf	BUF_U_20(Y,YIN);


// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, OCE, _CLR0);
      and U_c2 (Enable02, OCE, _CLR0);
      buf U_c4 (Enable04, OCE);
      buf U_c6 (Enable05, _CLR0);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, negedge OCE,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK &&& Enable04, 0.0, NOTIFY_REG);




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);


		//pin to pin path delay 

	(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_ORP_ERP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_ORP_ERP(DOUT,EOUT,Y,D,OCLK,PRE,E,YIN);
 input D,OCLK,PRE,E,YIN;
 output DOUT,EOUT,Y;
 supply1 VCC_0;
 supply0 GND_0;

 supply1 VCC_1;
 supply0 GND_1;



 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpr DF_0(DOUT, D,OCLK,VCC_0, PRE_0, GND_0, NOTIFY_REG);

 not INV_PRE_1(PRE_1, PRE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, GND_1, NOTIFY_REG);

 buf	BUF_U_20(Y,YIN);


// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, _PRE0);
      buf U_c4 (Enable04, _PRE0);
      buf U_c6 (Enable05, _PRE0);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

	specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
	specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge OCLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK, 0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals


	//pin to pin path delay 

	(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_OREP_EREP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OREP_EREP(DOUT,EOUT,Y,D,OCLK,OCE,PRE,E,YIN);
 input D,OCLK,OCE,PRE,E,YIN;
 output DOUT,EOUT,Y;
 supply1 VCC_0;

 supply1 VCC_1;



 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(DOUT, D,OCLK,VCC_0, PRE_0, OCE_0, NOTIFY_REG);

 not INV_PRE_1(PRE_1, PRE);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, OCE_1, NOTIFY_REG);

 buf	BUF_U_20(Y,YIN);


// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, OCE, _PRE0);
      buf U_c2 (Enable02, OCE);
      and U_c4 (Enable04, OCE, _PRE0);
       buf U_c6 (Enable05, _PRE0);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, negedge OCE,0.0, NOTIFY_REG);

	$hold(posedge OCLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK &&& Enable02, 0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	//pin to pin path delay 

	(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRC_OB_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRC_OB_EB(DOUT,EOUT,Y,D,E,YIN,ICLK,CLR);
 input D,E,YIN,ICLK,CLR;
 output DOUT,EOUT,Y;


 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 buf	BUF_U_10(EOUT,E);

 not INV_CLR_2(CLR_2, CLR);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, GND_2, NOTIFY_REG);




// some temp signals created for timing checking sections

      not U2_I2 (_CLR2, CLR);
      buf U_c0 (Enable21,_CLR2);
      buf U_c2 (Enable22, _CLR2);
      buf U_c6 (Enable25, _CLR2);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

		specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
		specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

		specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
		specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
		specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
		specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );


		//pin to pin path delay 

		(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );




	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge ICLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREC_OB_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREC_OB_EB(DOUT,EOUT,Y,D,E,YIN,ICLK,CLR,ICE);
 input D,E,YIN,ICLK,CLR,ICE;
 output DOUT,EOUT,Y;


 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 buf	BUF_U_10(EOUT,E);

 not INV_CLR_2(CLR_2, CLR);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, ICE_2, NOTIFY_REG);




// some temp signals created for timing checking sections

      not U2_I2 (_CLR2, CLR);
      and U_c0 (Enable21, ICE, _CLR2);
      and U_c2 (Enable22, ICE, _CLR2);
      buf U_c4 (Enable24, ICE);
      buf U_c6 (Enable25, _CLR2);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

		specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
		specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

		specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
		specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
		specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
		specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );


		//pin to pin path delay 

		(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );




	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable25,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable25, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, negedge ICE,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable24, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK &&& Enable24, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRP_OB_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRP_OB_EB(DOUT,EOUT,Y,D,E,YIN,ICLK,PRE);
 input D,E,YIN,ICLK,PRE;
 output DOUT,EOUT,Y;


 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 buf	BUF_U_10(EOUT,E);

 not INV_PRE_2(PRE_2, PRE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, GND_2, NOTIFY_REG);




// some temp signals created for timing checking sections

      not U2_I1 (_PRE2, PRE);
      buf U_c0 (Enable21, _PRE2);
       buf U_c4 (Enable24, _PRE2);
       buf U_c6 (Enable25, _PRE2);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

		specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
		specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

		specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
		specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
		specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
		specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );


		//pin to pin path delay 

		(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );




	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge ICLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREP_OB_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREP_OB_EB(DOUT,EOUT,Y,D,E,YIN,ICLK,ICE,PRE);
 input D,E,YIN,ICLK,ICE,PRE;
 output DOUT,EOUT,Y;


 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 buf	BUF_U_10(EOUT,E);

 not INV_PRE_2(PRE_2, PRE);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, ICE_2, NOTIFY_REG);




// some temp signals created for timing checking sections

      not U2_I1 (_PRE2, PRE);
      and U_c0 (Enable21, ICE, _PRE2);
      buf U_c2 (Enable22, ICE);
      and U_c4 (Enable24, ICE, _PRE2);
       buf U_c6 (Enable25, _PRE2);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

		specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
		specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

		specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
		specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
		specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
		specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );


		//pin to pin path delay 

		(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );




	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable25,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable25, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, negedge ICE,0.0, NOTIFY_REG);

	$hold(posedge ICLK &&& Enable22, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK &&& Enable22, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRC_OB_ERC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRC_OB_ERC(DOUT,EOUT,Y,D,E,OCLK,CLR,YIN,ICLK);
 input D,E,OCLK,CLR,YIN,ICLK;
 output DOUT,EOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_CLR_1(CLR_1, CLR);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, GND_1, NOTIFY_REG);

 not INV_CLR_2(CLR_2, CLR);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, GND_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I2 (_CLR1, CLR);
      buf U_c0 (Enable11,_CLR1);
      buf U_c2 (Enable12, _CLR1);
      buf U_c6 (Enable15, _CLR1);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

		//pin to pin path delay 

	(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable11, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable11, negedge YIN,0.0, NOTIFY_REG);

        $hold(posedge ICLK, negedge CLR,0.0, NOTIFY_REG);
        $recovery(negedge CLR, posedge ICLK, 0.0, NOTIFY_REG);

        $width(posedge ICLK &&& Enable12, 0, 0, NOTIFY_REG);
        $width(negedge ICLK &&& Enable12, 0, 0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREC_OB_ERC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREC_OB_ERC(DOUT,EOUT,Y,D,E,OCLK,CLR,YIN,ICLK,ICE);
 input D,E,OCLK,CLR,YIN,ICLK,ICE;
 output DOUT,EOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_CLR_1(CLR_1, CLR);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, GND_1, NOTIFY_REG);

 not INV_CLR_2(CLR_2, CLR);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, ICE_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I2 (_CLR1, CLR);
      buf U_c0 (Enable11,_CLR1);
      buf U_c2 (Enable12, _CLR1);
      buf U_c6 (Enable15, _CLR1);


// some temp signals created for timing checking sections

      and U_c00 (Enable21, ICE, _CLR1);
      and U_c02 (Enable22, ICE, _CLR1);
      buf U_c04 (Enable24, ICE);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable15,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable15, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable15, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable15, negedge ICE,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable24, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK &&& Enable24, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRC_OB_EREC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRC_OB_EREC(DOUT,EOUT,Y,D,E,OCLK,CLR,OCE,YIN,ICLK);
 input D,E,OCLK,CLR,OCE,YIN,ICLK;
 output DOUT,EOUT,Y;

 supply1 VCC_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_CLR_1(CLR_1, CLR);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, OCE_1, NOTIFY_REG);

 not INV_CLR_2(CLR_2, CLR);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, GND_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I02 (_CLR1, CLR);
      and U_c00 (Enable11, OCE, _CLR1);
      and U_c02 (Enable12, OCE, _CLR1);
      buf U_c04 (Enable14, OCE);
      buf U_c06 (Enable15, _CLR1);


// some temp signals created for timing checking sections

      buf U_c0 (Enable21,_CLR1);
      buf U_c2 (Enable22, _CLR1);
      buf U_c6 (Enable25, _CLR1);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

		specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
		specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
		specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
		specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

		specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
		specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
		specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
		specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable15,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable15, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, negedge OCE,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable14, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK &&& Enable14, 0.0, NOTIFY_REG);




	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge ICLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREC_OB_EREC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREC_OB_EREC(DOUT,EOUT,Y,D,E,OCLK,CLR,OCE,YIN,ICLK,ICE);
 input D,E,OCLK,CLR,OCE,YIN,ICLK,ICE;
 output DOUT,EOUT,Y;

 supply1 VCC_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_CLR_1(CLR_1, CLR);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, OCE_1, NOTIFY_REG);

 not INV_CLR_2(CLR_2, CLR);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, ICE_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I02 (_CLR1, CLR);
      and U_c00 (Enable11, OCE, _CLR1);
      and U_c02 (Enable12, OCE, _CLR1);
      buf U_c04 (Enable14, OCE);
      buf U_c06 (Enable15, _CLR1);


// some temp signals created for timing checking sections

      and U_c0 (Enable21, ICE, _CLR1);
      and U_c2 (Enable22, ICE, _CLR1);
      buf U_c4 (Enable24, ICE);
      buf U_c6 (Enable25, _CLR1);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

	(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable15,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable15, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, negedge OCE,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable14, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK &&& Enable14, 0.0, NOTIFY_REG);




	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable25,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable25, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, negedge ICE,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable24, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK &&& Enable24, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRP_OB_ERP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRP_OB_ERP(DOUT,EOUT,Y,D,E,OCLK,PRE,YIN,ICLK);
 input D,E,OCLK,PRE,YIN,ICLK;
 output DOUT,EOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_PRE_1(PRE_1, PRE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, GND_1, NOTIFY_REG);

 not INV_PRE_2(PRE_2, PRE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, GND_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I1 (_PRE1, PRE);
      buf U_c0 (Enable11, _PRE1);
      buf U_c4 (Enable14, _PRE1);
      buf U_c6 (Enable15, _PRE1);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

	(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge OCLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK, 0.0, NOTIFY_REG);




	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable11, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable11, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge ICLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable15, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREP_OB_ERP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREP_OB_ERP(DOUT,EOUT,Y,D,E,OCLK,PRE,YIN,ICLK,ICE);
 input D,E,OCLK,PRE,YIN,ICLK,ICE;
 output DOUT,EOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_PRE_1(PRE_1, PRE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, GND_1, NOTIFY_REG);

 not INV_PRE_2(PRE_2, PRE);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, ICE_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I01 (_PRE1, PRE);
      buf U_c00 (Enable11, _PRE1);
      buf U_c04 (Enable14, _PRE1);
      buf U_c06 (Enable15, _PRE1);

      and U_c0 (Enable21, ICE, _PRE1);
      buf U_c2 (Enable22, ICE);
      and U_c4 (Enable24, ICE, _PRE1);
      buf U_c6 (Enable25, _PRE1);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

		//pin to pin path delay 

	(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge OCLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK, 0.0, NOTIFY_REG);




	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable25,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable25, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, negedge ICE,0.0, NOTIFY_REG);

	$hold(posedge ICLK &&& Enable22, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK &&& Enable22, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRP_OB_EREP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRP_OB_EREP(DOUT,EOUT,Y,D,E,OCLK,OCE,PRE,YIN,ICLK);
 input D,E,OCLK,OCE,PRE,YIN,ICLK;
 output DOUT,EOUT,Y;

 supply1 VCC_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_PRE_1(PRE_1, PRE);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, OCE_1, NOTIFY_REG);

 not INV_PRE_2(PRE_2, PRE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, GND_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I1 (_PRE1, PRE);
      and U_c00 (Enable11, OCE, _PRE1);
      buf U_c02 (Enable12, OCE);
      and U_c04 (Enable14, OCE, _PRE1);
      buf U_c06 (Enable15, _PRE1);

      buf U_c0 (Enable21, _PRE1);
      buf U_c4 (Enable24, _PRE1);
      buf U_c6 (Enable25, _PRE1);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

		//pin to pin path delay 

	(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable15,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable15, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, negedge OCE,0.0, NOTIFY_REG);

	$hold(posedge OCLK &&& Enable12, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK &&& Enable12, 0.0, NOTIFY_REG);




	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge ICLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREP_OB_EREP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREP_OB_EREP(DOUT,EOUT,Y,D,E,OCLK,OCE,PRE,YIN,ICLK,ICE);
 input D,E,OCLK,OCE,PRE,YIN,ICLK,ICE;
 output DOUT,EOUT,Y;

 supply1 VCC_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_PRE_1(PRE_1, PRE);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, OCE_1, NOTIFY_REG);

 not INV_PRE_2(PRE_2, PRE);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, ICE_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I1 (_PRE1, PRE);
      and U_c0 (Enable11, OCE, _PRE1);
      buf U_c2 (Enable12, OCE);
      and U_c4 (Enable14, OCE, _PRE1);
      buf U_c6 (Enable15, _PRE1);

      and U_c7 (Enable21, ICE, _PRE1);
      buf U_c8 (Enable22, ICE);
      and U_c9 (Enable24, ICE, _PRE1);
      buf U_c10 (Enable25, _PRE1);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

		//pin to pin path delay 

	(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable15,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable15, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, negedge OCE,0.0, NOTIFY_REG);

	$hold(posedge OCLK &&& Enable12, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK &&& Enable12, 0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable25,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable25, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, negedge ICE,0.0, NOTIFY_REG);

	$hold(posedge ICLK &&& Enable22, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK &&& Enable22, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRC_ORC_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRC_ORC_EB(EOUT,DOUT,Y,E,D,OCLK,CLR,YIN,ICLK);
 input E,D,OCLK,CLR,YIN,ICLK;
 output EOUT,DOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);

 not INV_CLR_1(CLR_1, CLR);

 Dffpr DF_1(DOUT, D,OCLK,CLR_1, VCC_1, GND_1, NOTIFY_REG);

 not INV_CLR_2(CLR_2, CLR);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, GND_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I2 (_CLR1, CLR);
      buf U_c0 (Enable11,_CLR1);
      buf U_c2 (Enable12, _CLR1);
      buf U_c6 (Enable15, _CLR1);

      buf U_c3 (Enable21,_CLR1);
      buf U_c4 (Enable22, _CLR1);
      buf U_c5 (Enable25, _CLR1);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

		//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );


	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge ICLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREC_ORC_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREC_ORC_EB(EOUT,DOUT,Y,E,D,OCLK,CLR,YIN,ICLK,ICE);
 input E,D,OCLK,CLR,YIN,ICLK,ICE;
 output EOUT,DOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);

 not INV_CLR_1(CLR_1, CLR);

 Dffpr DF_1(DOUT, D,OCLK,CLR_1, VCC_1, GND_1, NOTIFY_REG);

 not INV_CLR_2(CLR_2, CLR);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, ICE_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I2 (_CLR1, CLR);
      buf U_c0 (Enable11,_CLR1);
      buf U_c1 (Enable12, _CLR1);
      buf U_c2 (Enable15, _CLR1);

      and U_c3 (Enable21, ICE, _CLR1);
      and U_c4 (Enable22, ICE, _CLR1);
      buf U_c5 (Enable24, ICE);
      buf U_c6 (Enable25, _CLR1);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

		//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );


	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);




	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable25,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable25, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, negedge ICE,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable24, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK &&& Enable24, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRC_OREC_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRC_OREC_EB(EOUT,DOUT,Y,E,D,OCLK,CLR,OCE,YIN,ICLK);
 input E,D,OCLK,CLR,OCE,YIN,ICLK;
 output EOUT,DOUT,Y;

 supply1 VCC_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);

 not INV_CLR_1(CLR_1, CLR);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(DOUT, D,OCLK,CLR_1, VCC_1, OCE_1, NOTIFY_REG);

 not INV_CLR_2(CLR_2, CLR);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, GND_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I2 (_CLR1, CLR);
      and U_c0 (Enable11, OCE, _CLR1);
      and U_c1 (Enable12, OCE, _CLR1);
      buf U_c2 (Enable14, OCE);
      buf U_c3 (Enable15, _CLR1);

      buf U_c4 (Enable21,_CLR1);
      buf U_c5 (Enable22, _CLR1);
      buf U_c6 (Enable25, _CLR1);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

	//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );


	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable15,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable15, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, negedge OCE,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable14, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK &&& Enable14, 0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge ICLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREC_OREC_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREC_OREC_EB(EOUT,DOUT,Y,E,D,OCLK,CLR,OCE,YIN,ICLK,ICE);
 input E,D,OCLK,CLR,OCE,YIN,ICLK,ICE;
 output EOUT,DOUT,Y;

 supply1 VCC_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);

 not INV_CLR_1(CLR_1, CLR);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(DOUT, D,OCLK,CLR_1, VCC_1, OCE_1, NOTIFY_REG);

 not INV_CLR_2(CLR_2, CLR);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, ICE_2, NOTIFY_REG);


// some temp signals created for timing checking sections

      not U1_I2 (_CLR1, CLR);
      and U_c0 (Enable11, OCE, _CLR1);
      and U_c1 (Enable12, OCE, _CLR1);
      buf U_c2 (Enable14, OCE);
      buf U_c3 (Enable15, _CLR1);

      and U_c4 (Enable21, ICE, _CLR1);
      and U_c5 (Enable22, ICE, _CLR1);
      buf U_c6 (Enable24, ICE);
      buf U_c7 (Enable25, _CLR1);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

	//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable15,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable15, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, negedge OCE,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable14, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK &&& Enable14, 0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable25,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable25, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, negedge ICE,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable24, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK &&& Enable24, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRP_ORP_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRP_ORP_EB(EOUT,DOUT,Y,E,D,OCLK,PRE,YIN,ICLK);
 input E,D,OCLK,PRE,YIN,ICLK;
 output EOUT,DOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);

 not INV_PRE_1(PRE_1, PRE);

 Dffpr DF_1(DOUT, D,OCLK,VCC_1, PRE_1, GND_1, NOTIFY_REG);

 not INV_PRE_2(PRE_2, PRE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, GND_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I1 (_PRE1, PRE);
      buf U_c0 (Enable11, _PRE1);
      buf U_c1 (Enable14, _PRE1);
      buf U_c2 (Enable15, _PRE1);

      buf U_c3 (Enable21, _PRE1);
      buf U_c4 (Enable24, _PRE1);
      buf U_c5 (Enable25, _PRE1);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );


	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge OCLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK, 0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge ICLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRP_OREP_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRP_OREP_EB(EOUT,DOUT,Y,E,D,OCLK,OCE,PRE,YIN,ICLK);
 input E,D,OCLK,OCE,PRE,YIN,ICLK;
 output EOUT,DOUT,Y;

 supply1 VCC_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);

 not INV_PRE_1(PRE_1, PRE);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(DOUT, D,OCLK,VCC_1, PRE_1, OCE_1, NOTIFY_REG);

 not INV_PRE_2(PRE_2, PRE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, GND_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I1 (_PRE1, PRE);
      and U_c0 (Enable11, OCE, _PRE1);
      buf U_c1 (Enable12, OCE);
      and U_c2 (Enable14, OCE, _PRE1);
      buf U_c3 (Enable15, _PRE1);

      buf U_c4 (Enable21, _PRE1);
      buf U_c5 (Enable24, _PRE1);
      buf U_c6 (Enable25, _PRE1);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

		//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable15,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable15, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, negedge OCE,0.0, NOTIFY_REG);

	$hold(posedge OCLK &&& Enable12, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK &&& Enable12, 0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge ICLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREP_ORP_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREP_ORP_EB(EOUT,DOUT,Y,E,D,OCLK,PRE,YIN,ICLK,ICE);
 input E,D,OCLK,PRE,YIN,ICLK,ICE;
 output EOUT,DOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);

 not INV_PRE_1(PRE_1, PRE);

 Dffpr DF_1(DOUT, D,OCLK,VCC_1, PRE_1, GND_1, NOTIFY_REG);

 not INV_PRE_2(PRE_2, PRE);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, ICE_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I1 (_PRE1, PRE);
      buf U_c0 (Enable11, _PRE1);
      buf U_c1 (Enable14, _PRE1);
      buf U_c2 (Enable15, _PRE1);

      and U_c3 (Enable21, ICE, _PRE1);
      buf U_c4 (Enable22, ICE);
      and U_c5 (Enable24, ICE, _PRE1);
      buf U_c6 (Enable25, _PRE1);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

		//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge OCLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK, 0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable25,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable25, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, negedge ICE,0.0, NOTIFY_REG);

	$hold(posedge ICLK &&& Enable22, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK &&& Enable22, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREP_OREP_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREP_OREP_EB(EOUT,DOUT,Y,E,D,OCLK,OCE,PRE,YIN,ICLK,ICE);
 input E,D,OCLK,OCE,PRE,YIN,ICLK,ICE;
 output EOUT,DOUT,Y;

 supply1 VCC_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);

 not INV_PRE_1(PRE_1, PRE);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(DOUT, D,OCLK,VCC_1, PRE_1, OCE_1, NOTIFY_REG);

 not INV_PRE_2(PRE_2, PRE);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, ICE_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      not U1_I1 (_PRE1, PRE);
      and U_c0 (Enable11, OCE, _PRE1);
      buf U_c1 (Enable12, OCE);
      and U_c2 (Enable14, OCE, _PRE1);
      buf U_c3 (Enable15, _PRE1);

      and U_c4 (Enable21, ICE, _PRE1);
      buf U_c5 (Enable22, ICE);
      and U_c6 (Enable24, ICE, _PRE1);
      buf U_c7 (Enable25, _PRE1);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

		//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable15,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable15, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable15, negedge OCE,0.0, NOTIFY_REG);

	$hold(posedge OCLK &&& Enable12, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable15 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable15, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK &&& Enable12, 0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable25,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable25, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, negedge ICE,0.0, NOTIFY_REG);

	$hold(posedge ICLK &&& Enable22, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);
	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK &&& Enable22, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRC_ORC_ERC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRC_ORC_ERC(DOUT,EOUT,Y,D,OCLK,CLR,E,YIN,ICLK);
 input D,OCLK,CLR,E,YIN,ICLK;
 output DOUT,EOUT,Y;
 supply1 VCC_0;
 supply0 GND_0;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(DOUT, D,OCLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);

 not INV_CLR_1(CLR_1, CLR);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, GND_1, NOTIFY_REG);

 not INV_CLR_2(CLR_2, CLR);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, GND_2, NOTIFY_REG);


// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,_CLR0);
      buf U_c1 (Enable02, _CLR0);
      buf U_c2 (Enable05, _CLR0);

      buf U_c3 (Enable11,_CLR0);
      buf U_c4 (Enable12, _CLR0);
      buf U_c5 (Enable15, _CLR0);

      buf U_c6 (Enable21,_CLR0);
      buf U_c7 (Enable22, _CLR0);
      buf U_c8 (Enable25, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge ICLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRC_OREC_EREC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRC_OREC_EREC(DOUT,EOUT,Y,D,OCLK,CLR,OCE,E,YIN,ICLK);
 input D,OCLK,CLR,OCE,E,YIN,ICLK;
 output DOUT,EOUT,Y;
 supply1 VCC_0;

 supply1 VCC_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(DOUT, D,OCLK,CLR_0, VCC_0, OCE_0, NOTIFY_REG);

 not INV_CLR_1(CLR_1, CLR);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, OCE_1, NOTIFY_REG);

 not INV_CLR_2(CLR_2, CLR);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, GND_2, NOTIFY_REG);


// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, OCE, _CLR0);
      and U_c1 (Enable02, OCE, _CLR0);
      buf U_c2 (Enable04, OCE);
      buf U_c3 (Enable05, _CLR0);

      and U_c4 (Enable11, OCE, _CLR0);
      and U_c5 (Enable12, OCE, _CLR0);
      buf U_c6 (Enable14, OCE);
      buf U_c7 (Enable15, _CLR0);

      buf U_c8 (Enable21,_CLR0);
      buf U_c9 (Enable22, _CLR0);
      buf U_c10 (Enable25, _CLR0);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, negedge OCE,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK &&& Enable04, 0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge ICLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREC_ORC_ERC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREC_ORC_ERC(DOUT,EOUT,Y,D,OCLK,CLR,E,YIN,ICLK,ICE);
 input D,OCLK,CLR,E,YIN,ICLK,ICE;
 output DOUT,EOUT,Y;
 supply1 VCC_0;
 supply0 GND_0;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(DOUT, D,OCLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);

 not INV_CLR_1(CLR_1, CLR);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, GND_1, NOTIFY_REG);

 not INV_CLR_2(CLR_2, CLR);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, ICE_2, NOTIFY_REG);


// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      buf U_c0 (Enable01,_CLR0);
      buf U_c1 (Enable02, _CLR0);
      buf U_c2 (Enable05, _CLR0);

      buf U_c3 (Enable11,_CLR0);
      buf U_c4 (Enable12, _CLR0);
      buf U_c5 (Enable15, _CLR0);

      and U_c6 (Enable21, ICE, _CLR0);
      and U_c7 (Enable22, ICE, _CLR0);
      buf U_c8 (Enable24, ICE);
      buf U_c9 (Enable25, _CLR0);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge CLR,0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable25,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable25, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, negedge ICE,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable24, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK &&& Enable24, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREC_OREC_EREC
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREC_OREC_EREC(DOUT,EOUT,Y,D,OCLK,CLR,OCE,E,YIN,ICLK,ICE);
 input D,OCLK,CLR,OCE,E,YIN,ICLK,ICE;
 output DOUT,EOUT,Y;
 supply1 VCC_0;

 supply1 VCC_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(DOUT, D,OCLK,CLR_0, VCC_0, OCE_0, NOTIFY_REG);

 not INV_CLR_1(CLR_1, CLR);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,CLR_1, VCC_1, OCE_1, NOTIFY_REG);

 not INV_CLR_2(CLR_2, CLR);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,CLR_2, VCC_2, ICE_2, NOTIFY_REG);


// some temp signals created for timing checking sections

      not U0_I2 (_CLR0, CLR);
      and U_c0 (Enable01, OCE, _CLR0);
      and U_c1 (Enable02, OCE, _CLR0);
      buf U_c2 (Enable04, OCE);
      buf U_c3 (Enable05, _CLR0);

      and U_c4 (Enable11, OCE, _CLR0);
      and U_c5 (Enable12, OCE, _CLR0);
      buf U_c6 (Enable14, OCE);
      buf U_c7 (Enable15, _CLR0);

      and U_c8 (Enable21, ICE, _CLR0);
      and U_c9 (Enable22, ICE, _CLR0);
      buf U_c10 (Enable24, ICE);
      buf U_c11 (Enable25, _CLR0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge CLR => (DOUT +: 1'b0)) = (tpdLH_CLR_to_DOUT, tpdHL_CLR_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, negedge OCE,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable04, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge OCLK &&& Enable04, 0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge CLR => (EOUT +: 1'b0)) = (tpdLH_CLR_to_EOUT, tpdHL_CLR_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge CLR => (Y +: 1'b0)) = (tpdLH_CLR_to_Y, tpdHL_CLR_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable25,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable25, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, negedge ICE,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable24, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge ICLK &&& Enable24, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRP_ORP_ERP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRP_ORP_ERP(DOUT,EOUT,Y,D,OCLK,PRE,E,YIN,ICLK);
 input D,OCLK,PRE,E,YIN,ICLK;
 output DOUT,EOUT,Y;
 supply1 VCC_0;
 supply0 GND_0;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpr DF_0(DOUT, D,OCLK,VCC_0, PRE_0, GND_0, NOTIFY_REG);

 not INV_PRE_1(PRE_1, PRE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, GND_1, NOTIFY_REG);

 not INV_PRE_2(PRE_2, PRE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, GND_2, NOTIFY_REG);


// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, _PRE0);
      buf U_c1 (Enable04, _PRE0);
      buf U_c2 (Enable05, _PRE0);

      buf U_c3 (Enable11, _PRE0);
      buf U_c4 (Enable14, _PRE0);
      buf U_c5 (Enable15, _PRE0);

      buf U_c6 (Enable21, _PRE0);
      buf U_c7 (Enable24, _PRE0);
      buf U_c8 (Enable25, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge OCLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK, 0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge OCLK, negedge PRE,0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge ICLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);
	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRP_OREP_EREP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRP_OREP_EREP(DOUT,EOUT,Y,D,OCLK,OCE,PRE,E,YIN,ICLK);
 input D,OCLK,OCE,PRE,E,YIN,ICLK;
 output DOUT,EOUT,Y;
 supply1 VCC_0;

 supply1 VCC_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(DOUT, D,OCLK,VCC_0, PRE_0, OCE_0, NOTIFY_REG);

 not INV_PRE_1(PRE_1, PRE);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, OCE_1, NOTIFY_REG);

 not INV_PRE_2(PRE_2, PRE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, GND_2, NOTIFY_REG);


// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, OCE, _PRE0);
      buf U_c1 (Enable02, OCE);
      and U_c2 (Enable04, OCE, _PRE0);
      buf U_c3 (Enable05, _PRE0);

      and U_c4 (Enable11, OCE, _PRE0);
      buf U_c5 (Enable12, OCE);
      and U_c6 (Enable14, OCE, _PRE0);
      buf U_c7 (Enable15, _PRE0);

      buf U_c8 (Enable21, _PRE0);
      buf U_c9 (Enable24, _PRE0);
      buf U_c10 (Enable25, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, negedge OCE,0.0, NOTIFY_REG);

	$hold(posedge OCLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK &&& Enable02, 0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge ICLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREP_ORP_ERP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREP_ORP_ERP(DOUT,EOUT,Y,D,OCLK,PRE,E,YIN,ICLK,ICE);
 input D,OCLK,PRE,E,YIN,ICLK,ICE;
 output DOUT,EOUT,Y;
 supply1 VCC_0;
 supply0 GND_0;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpr DF_0(DOUT, D,OCLK,VCC_0, PRE_0, GND_0, NOTIFY_REG);

 not INV_PRE_1(PRE_1, PRE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, GND_1, NOTIFY_REG);

 not INV_PRE_2(PRE_2, PRE);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, ICE_2, NOTIFY_REG);


// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      buf U_c0 (Enable01, _PRE0);
      buf U_c1 (Enable04, _PRE0);
      buf U_c2 (Enable05, _PRE0);

      buf U_c3 (Enable11, _PRE0);
      buf U_c4 (Enable14, _PRE0);
      buf U_c5 (Enable15, _PRE0);

      and U_c6 (Enable21, ICE, _PRE0);
      buf U_c7 (Enable22, ICE);
      and U_c8 (Enable24, ICE, _PRE0);
      buf U_c9 (Enable25, _PRE0);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge OCLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK, 0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable25,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable25, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, negedge ICE,0.0, NOTIFY_REG);

	$hold(posedge ICLK &&& Enable22, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK &&& Enable22, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IREP_OREP_EREP
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IREP_OREP_EREP(DOUT,EOUT,Y,D,OCLK,OCE,PRE,E,YIN,ICLK,ICE);
 input D,OCLK,OCE,PRE,E,YIN,ICLK,ICE;
 output DOUT,EOUT,Y;
 supply1 VCC_0;

 supply1 VCC_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(DOUT, D,OCLK,VCC_0, PRE_0, OCE_0, NOTIFY_REG);

 not INV_PRE_1(PRE_1, PRE);
 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, PRE_1, OCE_1, NOTIFY_REG);

 not INV_PRE_2(PRE_2, PRE);
 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, PRE_2, ICE_2, NOTIFY_REG);


// some temp signals created for timing checking sections

      not U0_I1 (_PRE0, PRE);
      and U_c0 (Enable01, OCE, _PRE0);
      buf U_c1 (Enable02, OCE);
      and U_c2 (Enable04, OCE, _PRE0);
      buf U_c3 (Enable05, _PRE0);

      not U1_I4 (_PRE1, PRE);
      and U_c4 (Enable11, OCE, _PRE0);
      buf U_c5 (Enable12, OCE);
      and U_c6 (Enable14, OCE, _PRE0);
      buf U_c7 (Enable15, _PRE0);

      and U_c8 (Enable21, ICE, _PRE0);
      buf U_c9 (Enable22, ICE);
      and U_c10 (Enable24, ICE, _PRE0);
      buf U_c11 (Enable25, _PRE0);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);
	(posedge PRE => (DOUT +: 1'b1)) = (tpdLH_PRE_to_DOUT, tpdHL_PRE_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK &&& Enable05,  0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK &&& Enable05, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable05, negedge OCE,0.0, NOTIFY_REG);

	$hold(posedge OCLK &&& Enable02, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK &&& Enable05 ,0,  0, NOTIFY_REG);
	$width(negedge OCLK &&& Enable05, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge OCLK &&& Enable02, 0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);
	(posedge PRE => (EOUT +: 1'b1)) = (tpdLH_PRE_to_EOUT, tpdHL_PRE_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);
	(posedge PRE => (Y +: 1'b1)) = (tpdLH_PRE_to_Y, tpdHL_PRE_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK &&& Enable25,  0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK &&& Enable25, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable25, negedge ICE,0.0, NOTIFY_REG);

	$hold(posedge ICLK &&& Enable22, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK &&& Enable25 ,0,  0, NOTIFY_REG);
	$width(negedge ICLK &&& Enable25, 0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge ICLK &&& Enable22, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME : IOPAD_IN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_IN(Y,PAD);
 input PAD;
 output Y;

 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPADP_BI
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPADP_BI(Y,PAD,N2PIN,D,E);
 input D,E,N2PIN;
 inout PAD;
 output Y;
 reg NOTIFY_REG;
 reg temp;

   bufif1   U89(PAD, D, E);
   pmos     U86(Y,temp,1'b0);

   always @(PAD or N2PIN) begin
     if ((PAD == 1'b1) && (N2PIN == 1'b0))
        temp = 1'b1;
     else if ((PAD == 1'b0) && (N2PIN == 1'b1))
        temp = 1'b0;
     else
        temp = 1'bx;
    end


      specify

	specparam tpdLH_E_to_PAD   = ( 0.1:0.1:0.1 );
	specparam tpdHL_E_to_PAD   = ( 0.1:0.1:0.1 );
        specparam tpdLZ_E_to_PAD   = ( 0.1:0.1:0.1 );
        specparam tpdZL_E_to_PAD   = ( 0.1:0.1:0.1 );
        specparam tpdHZ_E_to_PAD   = ( 0.1:0.1:0.1 );
        specparam tpdZH_E_to_PAD   = ( 0.1:0.1:0.1 );
        specparam tpdLH_D_to_PAD   = ( 0.1:0.1:0.1 );
        specparam tpdHL_D_to_PAD   = ( 0.1:0.1:0.1 );
        specparam tpdLH_PAD_to_Y   = ( 0.1:0.1:0.1 );
        specparam tpdHL_PAD_to_Y   = ( 0.1:0.1:0.1 );
        specparam tpdLH_N2PIN_to_Y = ( 0.1:0.1:0.1 );
        specparam tpdHL_N2PIN_to_Y = ( 0.1:0.1:0.1 );
        specparam MacroType = "comb";

        //pin to pin path delay 

        //if(~D)
        ( E => PAD )   = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD );
        ( D => PAD )   = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD );

        ( D => Y )     = ( 0.1:0.1:0.1, 0.1:0.1:0.1 );
        ( E => Y )     = ( 0.1:0.1:0.1, 0.1:0.1:0.1 );
        ( PAD   => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
        ( N2PIN => Y ) = ( tpdLH_N2PIN_to_Y, tpdHL_N2PIN_to_Y );

        specparam PATHPULSE$D$PAD = (0.1, 0.1);
        specparam PATHPULSE$E$PAD = (0.1, 0.1);
        specparam PATHPULSE$PAD$Y = (0.1, 0.1);
        specparam PATHPULSE$D$Y   = (0.1, 0.1);
        specparam PATHPULSE$E$Y   = (0.1, 0.1);

        $width( negedge PAD, 0.0, 0, NOTIFY_REG );
        $width( posedge PAD, 0.0, 0, NOTIFY_REG );
        $width( negedge N2PIN, 0.0, 0, NOTIFY_REG );
        $width( posedge N2PIN, 0.0, 0, NOTIFY_REG );
        $width( negedge D, 0.0, 0, NOTIFY_REG );
        $width( posedge D, 0.0, 0, NOTIFY_REG );
        $width( negedge E, 0.0, 0, NOTIFY_REG );
        $width( posedge E, 0.0, 0, NOTIFY_REG );


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME  : IOPADP_IN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPADP_IN(PAD,N2PIN,Y);

output  Y;
input  PAD,N2PIN;
    
 reg NOTIFY_REG;

     buf          BF1   (Y, PAD);

specify 
    specparam   LibName       = "proasic3";
    specparam   InputLoad$PAD = 1;
    specparam   OutputLoad$Y  = 0;
    specparam   MacroType     = "io";

 
        (PAD => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1); 
        (N2PIN => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                specparam PATHPULSE$N2PIN$Y = (0.1, 0.1);
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge N2PIN, 0.0, 0, NOTIFY_REG);
                $width(posedge N2PIN, 0.0, 0, NOTIFY_REG);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);


endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : IOPADN_BI
 CELL TYPE : comb
 CELL LOGIC : PAD=!DB@E ; N2POUT=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPADN_BI(N2POUT,PAD,DB,E);
 input DB,E;
 inout PAD;
 output N2POUT;
 reg NOTIFY_REG;
 reg temp;

   not      U79(DB_tmp,DB);
   bufif1   U78(PAD, DB_tmp, E);
   buf      U77(N2POUT,PAD);

      specify

	specparam tpdLH_E_to_PAD  = ( 0.1:0.1:0.1 );
	specparam tpdHL_E_to_PAD  = ( 0.1:0.1:0.1 );
        specparam tpdLZ_E_to_PAD  = ( 0.1:0.1:0.1 );
        specparam tpdZL_E_to_PAD  = ( 0.1:0.1:0.1 );
        specparam tpdHZ_E_to_PAD  = ( 0.1:0.1:0.1 );
        specparam tpdZH_E_to_PAD  = ( 0.1:0.1:0.1 );
        specparam tpdLH_DB_to_PAD = ( 0.1:0.1:0.1 );
        specparam tpdHL_DB_to_PAD = ( 0.1:0.1:0.1 );
        specparam tpdLH_PAD_to_N2POUT = ( 0.1:0.1:0.1 );
        specparam tpdHL_PAD_to_N2POUT = ( 0.1:0.1:0.1 );
        specparam MacroType = "comb";

        //pin to pin path delay 

        //if(~D)
        ( E => PAD )  = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD );
        ( DB => PAD ) = ( tpdLH_DB_to_PAD,tpdHL_DB_to_PAD );

        ( PAD   => N2POUT ) = ( tpdLH_PAD_to_N2POUT, tpdHL_PAD_to_N2POUT );

        specparam PATHPULSE$DB$PAD     = (0.1, 0.1);
        specparam PATHPULSE$E$PAD      = (0.1, 0.1);
        specparam PATHPULSE$PAD$N2POUT = (0.1, 0.1);

        $width( negedge PAD, 0.0, 0, NOTIFY_REG );
        $width( posedge PAD, 0.0, 0, NOTIFY_REG );
        $width( negedge DB, 0.0, 0, NOTIFY_REG );
        $width( posedge DB, 0.0, 0, NOTIFY_REG );
        $width( negedge E, 0.0, 0, NOTIFY_REG );
        $width( posedge E, 0.0, 0, NOTIFY_REG );


      endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME  : IOPADN_IN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPADN_IN(PAD,N2POUT);

output  N2POUT;
input  PAD;

 reg NOTIFY_REG;
    
     buf          BF1   (N2POUT, PAD);

specify 
    specparam   LibName       = "proasic3";
    specparam   InputLoad$PAD = 1;
    specparam   OutputLoad$Y  = 0;
    specparam   MacroType     = "io";

 
        (PAD => N2POUT) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                specparam PATHPULSE$PAD$N2POUT = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME : IOPAD_TRI
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_TRI(PAD,D,E);
 input D,E;
 output PAD;

 reg NOTIFY_REG;

 bufif1   U1210(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME  : IOPADP_TRI
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPADP_TRI(D, E, PAD);

output  PAD;
input  D, E;

 reg NOTIFY_REG;

   bufif1       BF1   (PAD, D, E);

specify 
 
         specparam   LibName     = "proasic3";
         specparam   OutputLoad$PAD = 0;
         specparam   InputLoad$D = 1;
         specparam   InputLoad$E = 1;
 
         specparam   MacroType = "io";


        (E => PAD) = (0.0:0.0:0.0,0.0:0.0:0.0,0.1:0.1:0.1,0.1:0.1:0.1,0.1:0.1:0.1,0.1:0.1:0.1); 
        (D => PAD) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

 
endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : IOPADN_TRI
---------------------------------------------------------------------*/      

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPADN_TRI(DB, E, PAD);

output  PAD;
input  DB, E;

 reg NOTIFY_REG;

   not          INVT (net1,DB);
   bufif1       BF1  (PAD, net1, E);

specify 
 
         specparam   LibName     = "proasic3";
         specparam   OutputLoad$PAD = 0;
         specparam   InputLoad$DB = 1;
         specparam   InputLoad$E = 1;
 
         specparam   MacroType = "io";

        (E => PAD) = (0.0:0.0:0.0,0.0:0.0:0.0,0.1:0.1:0.1,0.1:0.1:0.1,0.1:0.1:0.1,0.1:0.1:0.1); 
        (DB => PAD) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                specparam PATHPULSE$DB$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                $width(negedge DB, 0.0, 0, NOTIFY_REG);
                $width(posedge DB, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

 
endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME : IOPAD_BI
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_BI(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 reg NOTIFY_REG;

 bufif1   U1213(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                specparam PATHPULSE$D$Y = (0.1, 0.1);
                specparam PATHPULSE$E$Y = (0.1, 0.1);
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : IOPAD_IN_U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_IN_U(Y,PAD);
 input PAD;
 output Y;

 reg NOTIFY_REG;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_IN_D
 CELL TYPE : comb
 CELL LOGIC : Y#DOWN=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_IN_D(Y,PAD);
 input PAD;
 output Y;

 reg NOTIFY_REG;

 pulldown	DN(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_TRI_U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_TRI_U(PAD,D,E);
 input D,E;
 output PAD;

 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U2089(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_TRI_D
 CELL TYPE : comb
 CELL LOGIC : PAD#DOWN=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_TRI_D(PAD,D,E);
 input D,E;
 output PAD;

 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U2092(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_BI_U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_BI_U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U2095(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                specparam PATHPULSE$D$Y = (0.1, 0.1);
                specparam PATHPULSE$E$Y = (0.1, 0.1);
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_BI_D
 CELL TYPE : comb
 CELL LOGIC : PAD#DOWN=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_BI_D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U2098(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                specparam PATHPULSE$D$Y = (0.1, 0.1);
                specparam PATHPULSE$E$Y = (0.1, 0.1);
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME : IOPADN_OUT
 CELL TYPE : comb
 CELL LOGIC : PAD=!DB
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPADN_OUT(PAD,DB);
 input DB;
 output PAD;

 reg NOTIFY_REG;

 not	INV_U_00(PAD,DB);

       specify

		specparam tpdLH_DB_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(DB => PAD ) = ( tpdLH_DB_to_PAD, tpdHL_DB_to_PAD );

                specparam PATHPULSE$DB$PAD = (0.1, 0.1);
                $width(negedge DB, 0.0, 0, NOTIFY_REG);
                $width(posedge DB, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_2
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_2(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U1052(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_2D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_2D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U1055(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_2U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_2U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U1058(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_4
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_4(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U1061(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_4D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_4D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U1064(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_4U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_4U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U1067(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_6
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_6(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U1079(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_6D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_6D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U1082(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_6U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_6U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U1085(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_2
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_2(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U1103(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_2D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_2D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U1106(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_2U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_2U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U1109(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_4
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_4(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U1112(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_4D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_4D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U1115(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_4U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_4U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U1118(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_6
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_6(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U1121(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_6D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_6D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U1124(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_6U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_6U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U1127(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_F_2
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_F_2(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_F_4
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_F_4(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_F_6
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_F_6(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_S_2
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_S_2(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_S_4
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_S_4(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_S_6
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_S_6(PAD,D);
 input D;
 output PAD;
 reg NOTIFY_REG;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_2
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_2(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U1139(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_2D
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_2D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U1142(PAD, D, E);
 tri0 PAD;

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_2U
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_2U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U1145(PAD, D, E);
       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_4
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_4(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U1148(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_4D
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_4D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U1151(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_4U
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_4U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U1154(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_6
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_6(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U1157(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_6D
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_6D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U1160(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_6U
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_6U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U1163(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_2
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_2(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U1190(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_2D
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_2D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U1193(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_2U
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_2U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U1196(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_4
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_4(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U1199(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_4D
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_4D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U1202(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_4U
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_4U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U1205(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_6
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_6(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 bufif1   U1208(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_6D
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_6D(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U1211(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_6U
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_6U(PAD,D,E);
 input D,E;
 output PAD;
 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U1214(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if (~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);

                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BUFD
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BUFD(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INVD
 CELL TYPE : comb
 CELL LOGIC : Y=!A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INVD(Y,A);
 input A;
 output Y;

 not	INV_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOIN_IR
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Y,CLK =ICLK, D=YIN ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOIN_IR(ICLK, Y,YIN);
 input YIN,ICLK;
 output Y;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Y, YIN,ICLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOIN_IRE
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Y,CLK =ICLK, E=ICE, D=YIN ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOIN_IRE(ICE, ICLK, Y,YIN);
 input YIN,ICE,ICLK;
 output Y;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not INV_EN_0(ICE_0, ICE);

 Dffpr DF_0(Y, YIN,ICLK,VCC_0, VCC_0, ICE_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      buf U_c0 (Enable01,ICE);
      buf U_c2 (Enable02, ICE);
      buf U_c4 (Enable04, ICE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable01, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable01, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK,  0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge ICE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOTRI_OB_ER
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=EOUT,CLK =OCLK, D=E ];
 CELL COMB EQN : "DOUT = D"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OB_ER(OCLK, EOUT,DOUT,E,D);
 input E,D,OCLK;
 output EOUT,DOUT;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 

 buf BUF_DOUT_0(DOUT,D);

	// create the sequential logic -- DFF flip-flop plus comb input logic

 Dffpr DF_0(EOUT, E,OCLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_D_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	(D => DOUT) = (tpdLH_D_to_DOUT, tpdHL_D_to_DOUT);

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOTRI_OB_ERE
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=EOUT,CLK =OCLK, E=OCE, D=E ];
 CELL COMB EQN : "DOUT = D"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OB_ERE(OCE, OCLK, EOUT,DOUT,E,D);
 input E,D,OCE,OCLK;
 output EOUT,DOUT;
 supply1 VCC_0;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 

 buf BUF_DOUT_0(DOUT,D);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(EOUT, E,OCLK,VCC_0, VCC_0, OCE_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      buf U_c0 (Enable01,OCE);
      buf U_c2 (Enable02, OCE);
      buf U_c4 (Enable04, OCE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_D_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	(D => DOUT) = (tpdLH_D_to_DOUT, tpdHL_D_to_DOUT);

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK,  0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge OCE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOTRI_OR_EB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=DOUT,CLK =OCLK, D=D ];
 CELL COMB EQN : "EOUT = E"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OR_EB(OCLK, DOUT,EOUT,D,E);
 input D,E,OCLK;
 output DOUT,EOUT;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 

 buf BUF_EOUT_0(EOUT,E);

	// create the sequential logic -- DFF flip-flop plus comb input logic

 Dffpr DF_0(DOUT, D,OCLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	(E => EOUT) = (tpdLH_E_to_EOUT, tpdHL_E_to_EOUT);

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOTRI_ORE_EB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=DOUT,CLK =OCLK, E=OCE, D=D ];
 CELL COMB EQN : "EOUT = E"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_ORE_EB(OCE, OCLK, DOUT,EOUT,D,E);
 input D,E,OCE,OCLK;
 output DOUT,EOUT;
 supply1 VCC_0;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 

 buf BUF_EOUT_0(EOUT,E);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(DOUT, D,OCLK,VCC_0, VCC_0, OCE_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      buf U_c0 (Enable01,OCE);
      buf U_c2 (Enable02, OCE);
      buf U_c4 (Enable04, OCE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	(E => EOUT) = (tpdLH_E_to_EOUT, tpdHL_E_to_EOUT);

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK,  0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge OCE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOTRI_ORE_ERE
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_ORE_ERE(EOUT,DOUT,E,OCLK,OCE,D);
 input E,OCLK,OCE,D;
 output EOUT,DOUT;
 supply1 VCC_0;

 supply1 VCC_1;


 reg NOTIFY_REG;

 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(EOUT, E,OCLK,VCC_0, VCC_0, OCE_0, NOTIFY_REG);

 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(DOUT, D,OCLK,VCC_1, VCC_1, OCE_1, NOTIFY_REG);


// some temp signals created for timing checking sections

      buf U_c0 (Enable01,OCE);
      buf U_c2 (Enable02, OCE);
      buf U_c4 (Enable04, OCE);

      buf U_c3 (Enable11,OCE);
      buf U_c5 (Enable12, OCE);
      buf U_c6 (Enable14, OCE);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

	specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK,  0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge OCE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOTRI_OR_ER
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OR_ER(EOUT,DOUT,E,OCLK,D);
 input E,OCLK,D;
 output EOUT,DOUT;
 supply1 VCC_0;
 supply0 GND_0;

 supply1 VCC_1;
 supply0 GND_1;


 reg NOTIFY_REG;


 Dffpr DF_0(EOUT, E,OCLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

 Dffpr DF_1(DOUT, D,OCLK,VCC_1, VCC_1, GND_1, NOTIFY_REG);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

	specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge E,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);


	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge D,0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_OB_ER
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OB_ER(DOUT,Y,EOUT,D,YIN,E,OCLK);
 input D,YIN,E,OCLK;
 output DOUT,Y,EOUT;


 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 buf	BUF_U_10(Y,YIN);


 Dffpr DF_2(EOUT, E,OCLK,VCC_2, VCC_2, GND_2, NOTIFY_REG);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
		specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );


		//pin to pin path delay 

		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//checing the recovery data



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_OB_ERE
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OB_ERE(DOUT,Y,EOUT,D,YIN,E,OCLK,OCE);
 input D,YIN,E,OCLK,OCE;
 output DOUT,Y,EOUT;


 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 buf	BUF_U_10(Y,YIN);

 not INV_EN_2(OCE_2, OCE);

 Dffpr DF_2(EOUT, E,OCLK,VCC_2, VCC_2, OCE_2, NOTIFY_REG);

// some temp signals created for timing checking sections

      buf U_c0 (Enable21,OCE);
      buf U_c2 (Enable22, OCE);
      buf U_c4 (Enable24, OCE);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
		specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
		specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );


		//pin to pin path delay 

		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable21, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable21, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK,  0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge OCE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//checing the recovery data



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOBI_IB_OR_EB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=DOUT,CLK =OCLK, D=D ];
 CELL COMB EQN : "EOUT = E, Y = YIN"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OR_EB(OCLK, DOUT,Y, EOUT,D,E, YIN);
 input D,E,OCLK,YIN;
 output DOUT,EOUT,Y;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 

 buf BUF_EOUT_0(EOUT,E);
 buf U0 (Y,YIN);

	// create the sequential logic -- DFF flip-flop plus comb input logic

 Dffpr DF_0(DOUT, D,OCLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_E_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	(E => EOUT) = (tpdLH_E_to_EOUT, tpdHL_E_to_EOUT);

        (YIN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_ORE_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_ORE_EB(EOUT,Y,DOUT,E,YIN,D,OCLK,OCE);
 input E,YIN,D,OCLK,OCE;
 output EOUT,Y,DOUT;


 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);

 buf	BUF_U_10(Y,YIN);

 not INV_EN_2(OCE_2, OCE);

 Dffpr DF_2(DOUT, D,OCLK,VCC_2, VCC_2, OCE_2, NOTIFY_REG);




// some temp signals created for timing checking sections

      buf U_c0 (Enable21,OCE);
      buf U_c2 (Enable22, OCE);
      buf U_c4 (Enable24, OCE);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
		specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
		specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );


		//pin to pin path delay 

		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );




	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable21, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable21, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK,  0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge OCE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//checing the recovery data



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_OR_ER
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_OR_ER(Y,DOUT,EOUT,YIN,D,OCLK,E);
 input YIN,D,OCLK,E;
 output Y,DOUT,EOUT;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(Y,YIN);


 Dffpr DF_1(DOUT, D,OCLK,VCC_1, VCC_1, GND_1, NOTIFY_REG);
 Dffpr DF_2(EOUT, E,OCLK,VCC_2, VCC_2, GND_2, NOTIFY_REG);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

		specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

		specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
		specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

		specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
		specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

		specparam MacroType = "multi";

		//pin to pin path delay 

		(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );




	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);


	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge E,0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IB_ORE_ERE
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IB_ORE_ERE(Y,DOUT,EOUT,YIN,D,OCLK,OCE,E);
 input YIN,D,OCLK,OCE,E;
 output Y,DOUT,EOUT;

 supply1 VCC_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(Y,YIN);
 not INV_EN_1(OCE_1, OCE);
 Dffpr DF_1(DOUT, D,OCLK,VCC_1, VCC_1, OCE_1, NOTIFY_REG);
 not INV_EN_2(OCE_2, OCE);
 Dffpr DF_2(EOUT, E,OCLK,VCC_2, VCC_2, OCE_2, NOTIFY_REG);


// some temp signals created for timing checking sections

      buf U_c0 (Enable11,OCE);
      buf U_c2 (Enable12, OCE);
      buf U_c4 (Enable14, OCE);

      buf U_c1 (Enable21,OCE);
      buf U_c3 (Enable22, OCE);
      buf U_c5 (Enable24, OCE);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_YIN_to_Y = (0.1:0.1:0.1);
	specparam tpdHL_YIN_to_Y = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

	specparam MacroType = "multi";

	//pin to pin path delay 

	(YIN => Y ) = ( tpdLH_YIN_to_Y, tpdHL_YIN_to_Y );


	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK,  0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge OCE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);


	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable21, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable21, negedge E,0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IR_OB_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IR_OB_EB(DOUT,EOUT,Y,D,E,YIN,ICLK);
 input D,E,YIN,ICLK;
 output DOUT,EOUT,Y;


 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 buf	BUF_U_10(EOUT,E);


 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, GND_2, NOTIFY_REG);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

	//pin to pin path delay 

	(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );


	//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRE_OB_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRE_OB_EB(DOUT,EOUT,Y,D,E,YIN,ICLK,ICE);
 input D,E,YIN,ICLK,ICE;
 output DOUT,EOUT,Y;


 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);
 buf	BUF_U_10(EOUT,E);
 not INV_EN_2(ICE_2, ICE);
 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, ICE_2, NOTIFY_REG);

// some temp signals created for timing checking sections

      buf U_c0 (Enable21,ICE);
      buf U_c2 (Enable22, ICE);
      buf U_c4 (Enable24, ICE);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

		//pin to pin path delay 

	(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );

		//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK,  0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge ICE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IR_OB_ER
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IR_OB_ER(DOUT,EOUT,Y,D,E,OCLK,YIN,ICLK);
 input D,E,OCLK,YIN,ICLK;
 output DOUT,EOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);


 Dffpr DF_1(EOUT, E,OCLK,VCC_1, VCC_1, GND_1, NOTIFY_REG);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, GND_2, NOTIFY_REG);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

	//pin to pin path delay 

	(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRE_OB_ER
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRE_OB_ER(DOUT,EOUT,Y,D,E,OCLK,YIN,ICLK,ICE);
 input D,E,OCLK,YIN,ICLK,ICE;
 output DOUT,EOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);


 Dffpr DF_1(EOUT, E,OCLK,VCC_1, VCC_1, GND_1, NOTIFY_REG);

 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, ICE_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      buf U_c0 (Enable21,ICE);
      buf U_c2 (Enable22, ICE);
      buf U_c4 (Enable24, ICE);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

	//pin to pin path delay 

	(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );


	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK,  0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge ICE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IR_OB_ERE
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IR_OB_ERE(DOUT,EOUT,Y,D,E,OCLK,OCE,YIN,ICLK);
 input D,E,OCLK,OCE,YIN,ICLK;
 output DOUT,EOUT,Y;

 supply1 VCC_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, VCC_1, OCE_1, NOTIFY_REG);
 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, GND_2, NOTIFY_REG);


// some temp signals created for timing checking sections

      buf U_c0 (Enable11,OCE);
      buf U_c2 (Enable12, OCE);
      buf U_c4 (Enable14, OCE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

	//pin to pin path delay 

	(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );




	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK,  0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge OCE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRE_OB_ERE
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRE_OB_ERE(DOUT,EOUT,Y,D,E,OCLK,OCE,YIN,ICLK,ICE);
 input D,E,OCLK,OCE,YIN,ICLK,ICE;
 output DOUT,EOUT,Y;

 supply1 VCC_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(DOUT,D);

 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(EOUT, E,OCLK,VCC_1, VCC_1, OCE_1, NOTIFY_REG);

 not INV_EN_2(ICE_2, ICE);

 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, ICE_2, NOTIFY_REG);



// some temp signals created for timing checking sections

      buf U_c0 (Enable11,OCE);
      buf U_c2 (Enable12, OCE);
      buf U_c4 (Enable14, OCE);

      buf U_c1 (Enable21,ICE);
      buf U_c3 (Enable22, ICE);
      buf U_c5 (Enable24, ICE);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_D_to_DOUT = (0.1:0.1:0.1);
	specparam tpdHL_D_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";

	//pin to pin path delay 

	(D => DOUT ) = ( tpdLH_D_to_DOUT, tpdHL_D_to_DOUT );

	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK,  0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge OCE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK,  0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge ICE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IR_OR_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IR_OR_EB(EOUT,DOUT,Y,E,D,OCLK,YIN,ICLK);
 input E,D,OCLK,YIN,ICLK;
 output EOUT,DOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);


 Dffpr DF_1(DOUT, D,OCLK,VCC_1, VCC_1, GND_1, NOTIFY_REG);
 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, GND_2, NOTIFY_REG);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

	//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRE_OR_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRE_OR_EB(EOUT,DOUT,Y,E,D,OCLK,YIN,ICLK,ICE);
 input E,D,OCLK,YIN,ICLK,ICE;
 output EOUT,DOUT,Y;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);


 Dffpr DF_1(DOUT, D,OCLK,VCC_1, VCC_1, GND_1, NOTIFY_REG);
 not INV_EN_2(ICE_2, ICE);
 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, ICE_2, NOTIFY_REG);

// some temp signals created for timing checking sections

      buf U_c0 (Enable21,ICE);
      buf U_c2 (Enable22, ICE);
      buf U_c4 (Enable24, ICE);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

	//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );


	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK,  0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge ICE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IR_ORE_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IR_ORE_EB(EOUT,DOUT,Y,E,D,OCLK,OCE,YIN,ICLK);
 input E,D,OCLK,OCE,YIN,ICLK;
 output EOUT,DOUT,Y;

 supply1 VCC_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);
 not INV_EN_1(OCE_1, OCE);
 Dffpr DF_1(DOUT, D,OCLK,VCC_1, VCC_1, OCE_1, NOTIFY_REG);
 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, GND_2, NOTIFY_REG);

// some temp signals created for timing checking sections

      buf U_c0 (Enable11,OCE);
      buf U_c2 (Enable12, OCE);
      buf U_c4 (Enable14, OCE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

	//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK,  0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge OCE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRE_ORE_EB
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRE_ORE_EB(EOUT,DOUT,Y,E,D,OCLK,OCE,YIN,ICLK,ICE);
 input E,D,OCLK,OCE,YIN,ICLK,ICE;
 output EOUT,DOUT,Y;

 supply1 VCC_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 buf	BUF_U_00(EOUT,E);
 not INV_EN_1(OCE_1, OCE);
 Dffpr DF_1(DOUT, D,OCLK,VCC_1, VCC_1, OCE_1, NOTIFY_REG);
 not INV_EN_2(ICE_2, ICE);
 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, ICE_2, NOTIFY_REG);

// some temp signals created for timing checking sections

      buf U_c0 (Enable11,OCE);
      buf U_c2 (Enable12, OCE);
      buf U_c4 (Enable14, OCE);

      buf U_c1 (Enable21,ICE);
      buf U_c3 (Enable22, ICE);
      buf U_c5 (Enable24, ICE);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam tpdLH_E_to_EOUT = (0.1:0.1:0.1);
	specparam tpdHL_E_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

	specparam MacroType = "multi";

	//pin to pin path delay 

	(E => EOUT ) = ( tpdLH_E_to_EOUT, tpdHL_E_to_EOUT );


	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK,  0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge OCE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK,  0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge ICE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IR_OR_ER
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IR_OR_ER(EOUT,DOUT,Y,E,OCLK,D,YIN,ICLK);
 input E,OCLK,D,YIN,ICLK;
 output EOUT,DOUT,Y;
 supply1 VCC_0;
 supply0 GND_0;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;


 Dffpr DF_0(EOUT, E,OCLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);
 Dffpr DF_1(DOUT, D,OCLK,VCC_1, VCC_1, GND_1, NOTIFY_REG);
 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, GND_2, NOTIFY_REG);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge E,0.0, NOTIFY_REG);

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge YIN,0.0, NOTIFY_REG);


	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IR_ORE_ERE
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IR_ORE_ERE(EOUT,DOUT,Y,E,OCLK,OCE,D,YIN,ICLK);
 input E,OCLK,OCE,D,YIN,ICLK;
 output EOUT,DOUT,Y;
 supply1 VCC_0;

 supply1 VCC_1;

 supply1 VCC_2;
 supply0 GND_2;


 reg NOTIFY_REG;

 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(EOUT, E,OCLK,VCC_0, VCC_0, OCE_0, NOTIFY_REG);

 not INV_EN_1(OCE_1, OCE);

 Dffpr DF_1(DOUT, D,OCLK,VCC_1, VCC_1, OCE_1, NOTIFY_REG);


 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, GND_2, NOTIFY_REG);


// some temp signals created for timing checking sections

      buf U_c0 (Enable01,OCE);
      buf U_c2 (Enable02, OCE);
      buf U_c4 (Enable04, OCE);

      buf U_c1 (Enable11,OCE);
      buf U_c3 (Enable12, OCE);
      buf U_c5 (Enable14, OCE);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK,  0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge OCE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);



	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

	//checing the recovery data



 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRE_OR_ER
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRE_OR_ER(EOUT,DOUT,Y,E,OCLK,D,YIN,ICLK,ICE);
 input E,OCLK,D,YIN,ICLK,ICE;
 output EOUT,DOUT,Y;
 supply1 VCC_0;
 supply0 GND_0;

 supply1 VCC_1;
 supply0 GND_1;

 supply1 VCC_2;


 reg NOTIFY_REG;


 Dffpr DF_0(EOUT, E,OCLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);
 Dffpr DF_1(DOUT, D,OCLK,VCC_1, VCC_1, GND_1, NOTIFY_REG);
 not INV_EN_2(ICE_2, ICE);
 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, ICE_2, NOTIFY_REG);

      buf U_c0 (Enable21,ICE);
      buf U_c2 (Enable22, ICE);
      buf U_c4 (Enable24, ICE);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge D,0.0, NOTIFY_REG);


	//check timing delay for output

	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK,  0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge ICE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBI_IRE_ORE_ERE
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_IRE_ORE_ERE(EOUT,DOUT,Y,E,OCLK,OCE,D,YIN,ICLK,ICE);
 input E,OCLK,OCE,D,YIN,ICLK,ICE;
 output EOUT,DOUT,Y;
 supply1 VCC_0;

 supply1 VCC_1;

 supply1 VCC_2;


 reg NOTIFY_REG;

 not INV_EN_0(OCE_0, OCE);

 Dffpr DF_0(EOUT, E,OCLK,VCC_0, VCC_0, OCE_0, NOTIFY_REG);
 not INV_EN_1(OCE_1, OCE);
 Dffpr DF_1(DOUT, D,OCLK,VCC_1, VCC_1, OCE_1, NOTIFY_REG);
 not INV_EN_2(ICE_2, ICE);
 Dffpr DF_2(Y, YIN,ICLK,VCC_2, VCC_2, ICE_2, NOTIFY_REG);

// some temp signals created for timing checking sections

      buf U_c0 (Enable01,OCE);
      buf U_c2 (Enable02, OCE);
      buf U_c4 (Enable04, OCE);

      buf U_c1 (Enable11,OCE);
      buf U_c3 (Enable12, OCE);
      buf U_c5 (Enable14, OCE);

      buf U_c6 (Enable21,ICE);
      buf U_c7 (Enable22, ICE);
      buf U_c8 (Enable24, ICE);



//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_OCLK_to_EOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_EOUT = (0.1:0.1:0.1);

	specparam   tpdLH_OCLK_to_DOUT = (0.1:0.1:0.1);
	specparam   tpdHL_OCLK_to_DOUT = (0.1:0.1:0.1);

	specparam   tpdLH_ICLK_to_Y = (0.1:0.1:0.1);
	specparam   tpdHL_ICLK_to_Y = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge OCLK => (EOUT +: E))=(tpdLH_OCLK_to_EOUT, tpdHL_OCLK_to_EOUT);

	//checking setup and hold timing for inputs

	$setup(posedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$setup(negedge E,posedge OCLK &&& Enable01, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, posedge E,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable01, negedge E,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge OCE,posedge OCLK,  0.0, NOTIFY_REG);
	$hold(posedge OCLK, posedge OCE,0.0, NOTIFY_REG);
	$setup(negedge OCE,posedge OCLK, 0.0, NOTIFY_REG);
	$hold(posedge OCLK, negedge OCE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge OCLK,0,  0, NOTIFY_REG);
	$width(negedge OCLK, 0, 0, NOTIFY_REG);

	//check timing delay for output

	(posedge OCLK => (DOUT +: D))=(tpdLH_OCLK_to_DOUT, tpdHL_OCLK_to_DOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge OCLK &&& Enable11, 0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, posedge D,0.0, NOTIFY_REG);
	$hold(posedge OCLK &&& Enable11, negedge D,0.0, NOTIFY_REG);


	(posedge ICLK => (Y +: YIN))=(tpdLH_ICLK_to_Y, tpdHL_ICLK_to_Y);

	//checking setup and hold timing for inputs

	$setup(posedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$setup(negedge YIN,posedge ICLK &&& Enable21, 0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, posedge YIN,0.0, NOTIFY_REG);
	$hold(posedge ICLK &&& Enable21, negedge YIN,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge ICE,posedge ICLK,  0.0, NOTIFY_REG);
	$hold(posedge ICLK, posedge ICE,0.0, NOTIFY_REG);
	$setup(negedge ICE,posedge ICLK, 0.0, NOTIFY_REG);
	$hold(posedge ICLK, negedge ICE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge ICLK,0,  0, NOTIFY_REG);
	$width(negedge ICLK, 0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKIO
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKIO(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME : CLKBIBUF
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E % Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBIBUF(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;
 reg NOTIFY_REG;

 bufif1   U1583(PAD, D, E);
 buf    BUF_U1(Y,PAD);

        specify
		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
                specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
                specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
                specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
                specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
                specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
                specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
                specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam MacroType = "comb";

                //pin to pin path delay

            //if (~D)
                (E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

                (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
                (D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                (E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                (PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );

                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

        endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME  : DDR_OUT
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DDR_OUT(Q,CLK,CLR,DR,DF);
input CLK,CLR,DR,DF;
output Q;

wire tmp_out0,tmp_out1;
supply1 VCC;
supply0 GND;

reg NOTIFY_REG;

    not INV_CLR(CLR_, CLR);

    Dffpr DF_1(tmp_out0, DR,CLK,CLR_, VCC, GND, NOTIFY_REG);
    Dffpr DF_2(tmp_out1, DF,CLK,CLR_, VCC, GND, NOTIFY_REG);
    UDP_MUX2 mux1(Q,tmp_out0,tmp_out1,CLK);



 specify

         specparam   LibName     = "proasic3";
         specparam   InputLoad$DR = 2;
         specparam   InputLoad$DF = 2;
         specparam   InputLoad$CLR = 6;
         specparam   InputLoad$CLK = 2;
         specparam   OutputLoad$Q = 2;

         specparam   MacroType = "ddr_out";

          //check timing delay for output

        (CLK => Q)=(0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (Q +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);

        //checking setup and hold timing for inputs

        $setup(posedge DR,posedge CLK,0.0, NOTIFY_REG);
        $setup(negedge DR,posedge CLK,0.0, NOTIFY_REG);
        $hold(posedge CLK,posedge DR,0.0, NOTIFY_REG);
        $hold(posedge CLK,negedge DR,0.0, NOTIFY_REG);

        $setup(posedge DF,posedge CLK,0.0, NOTIFY_REG);
        $setup(negedge DF,posedge CLK,0.0, NOTIFY_REG);
        $hold(posedge CLK,negedge DF,0.0, NOTIFY_REG);
        $hold(posedge CLK,posedge DF,0.0, NOTIFY_REG);

           //checking timing for control signals


        $hold(posedge CLK,negedge CLR,0.0, NOTIFY_REG);

        //checking the pulse width

        $width(posedge CLK,0,  0, NOTIFY_REG);
        $width(negedge CLK, 0, 0, NOTIFY_REG);
        $width(posedge CLR, 0.0, 0, NOTIFY_REG);

        //checing the recovery data

        $recovery(negedge CLR, posedge CLK, 0.0, NOTIFY_REG);


    endspecify


endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : DDR_REG
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DDR_REG(D,CLK,CLR,QR,QF);
input D, CLR, CLK;
output QR,QF;

wire tmp_out;
supply1 VCC;
supply0 GND;
reg NOTIFY_REG;

    not INV_CLR(CLR_, CLR);
  
    Dffpf DF_0(tmp_out, D,       CLK, VCC,  VCC, GND, NOTIFY_REG);
    Dffpr DF_1(QF,      tmp_out, CLK, CLR_, VCC, GND, NOTIFY_REG);
    Dffpr DF_2(QR,      D,       CLK, CLR_, VCC, GND, NOTIFY_REG);


 specify

         specparam   LibName     = "proasic3";
         specparam   InputLoad$YIN = 2;
         specparam   InputLoad$CLR = 6;
         specparam   InputLoad$ICLK = 2;
         specparam   OutputLoad$YR = 2;
         specparam   OutputLoad$YF = 2;

         specparam   MacroType = "ddr";
         specparam   SeqType   = "flipflop";

          //check timing delay for output

        (posedge CLK => (QR +: D))=(0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (QR +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (CLK => QF) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (QF +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);

        //checking setup and hold timing for inputs

        $setup(posedge D,posedge CLK,0.0, NOTIFY_REG);
        $setup(negedge D,posedge CLK,0.0, NOTIFY_REG);
        $hold(posedge CLK,posedge D,0.0, NOTIFY_REG);
        $hold(posedge CLK,negedge D,0.0, NOTIFY_REG);

        $setup(posedge D,negedge CLK,0.0, NOTIFY_REG);
        $setup(negedge D,negedge CLK,0.0, NOTIFY_REG);
        $hold(negedge CLK,negedge D,0.0, NOTIFY_REG);
        $hold(negedge CLK,posedge D,0.0, NOTIFY_REG);


        //checking timing for control signals


        $hold(posedge CLK,negedge CLR,0.0, NOTIFY_REG);

        //checking the pulse width

        $width(posedge CLK, 0,  0, NOTIFY_REG);
        $width(negedge CLK, 0, 0, NOTIFY_REG);
        $width(posedge CLR, 0.0, 0, NOTIFY_REG);

        //checing the recovery data

        $recovery(negedge CLR, posedge CLK, 0.0, NOTIFY_REG);


    endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : IOBI_ID_OB_EB
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_ID_OB_EB(D, CLR, E, ICLK, YIN, DOUT, EOUT, YR, YF);
input D, CLR, E, ICLK, YIN;
output DOUT, EOUT, YR, YF;

wire tmp_zd;
supply1 VCC;
supply0 GND;

reg NOTIFY_REG;

    buf buf_D(DOUT, D);
    buf buf_E(EOUT, E);
 
    not INV_CLR(CLR_, CLR);
    Dffpf DF_1(tmp_zd, YIN,    ICLK, VCC,  VCC, GND, NOTIFY_REG);
    Dffpr DF_2(YF,     tmp_zd, ICLK, CLR_, VCC, GND, NOTIFY_REG);
    Dffpr DF_3(YR,     YIN,    ICLK, CLR_, VCC, GND, NOTIFY_REG);

    specify

        //check timing delay for output

        (D => DOUT ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (E => EOUT ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        
        (posedge CLR  => (YF +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR  => (YR +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        //(posedge ICLK => (YF +: YIN))  = (0.1:0.1:0.1, 0.1:0.1:0.1); // is this right??? no, negedge; no-edge is better
        (ICLK => YF) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge ICLK => (YR +: YIN))  = (0.1:0.1:0.1, 0.1:0.1:0.1);

        //checking setup and hold timing for inputs

        $setup(posedge YIN, posedge ICLK, 0.0, NOTIFY_REG);
        $setup(negedge YIN, posedge ICLK, 0.0, NOTIFY_REG);
        $hold(posedge ICLK, posedge YIN, 0.0, NOTIFY_REG);
        $hold(posedge ICLK, negedge YIN, 0.0, NOTIFY_REG);

        $setup(posedge YIN, negedge ICLK, 0.0, NOTIFY_REG);
        $setup(negedge YIN, negedge ICLK, 0.0, NOTIFY_REG);
        $hold(negedge ICLK, negedge YIN, 0.0, NOTIFY_REG);
        $hold(negedge ICLK, posedge YIN, 0.0, NOTIFY_REG);

        $recovery(negedge CLR, posedge ICLK, 0.0, NOTIFY_REG);
        $hold(posedge ICLK, negedge CLR, 0.0, NOTIFY_REG);

        //checking the pulse width

        $width(posedge ICLK, 0, 0, NOTIFY_REG);
        $width(negedge ICLK, 0, 0, NOTIFY_REG);
        $width(posedge CLR,  0, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME  : IOBI_ID_OD_EB
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_ID_OD_EB(E,DOUT,OCLK,CLR,DR,DF,YR,YF,ICLK,YIN,EOUT);
input YIN,E,OCLK,CLR,DR,DF,ICLK;
output DOUT,EOUT,YR,YF;

wire tmp_out, tmp_out0,tmp_out1;
supply1 VCC;
supply0 GND;

reg NOTIFY_REG;

    not INV_CLR(CLR_, CLR);
    buf buf_inst(EOUT,E);
 
    Dffpr DF_1(tmp_out0, DR,OCLK,CLR_, VCC, GND, NOTIFY_REG);
    Dffpr DF_2(tmp_out1, DF,OCLK,CLR_, VCC, GND, NOTIFY_REG);
    UDP_MUX2 mux1(DOUT,tmp_out0,tmp_out1,OCLK);

    Dffpf DF_3(tmp_out, YIN,     ICLK, VCC,  VCC, GND, NOTIFY_REG);
    Dffpr DF_4(YF,      tmp_out, ICLK, CLR_, VCC, GND, NOTIFY_REG);
    Dffpr DF_5(YR,      YIN,     ICLK, CLR_, VCC, GND, NOTIFY_REG);




    specify

        //check timing delay for output

        (posedge ICLK => (YR +: YIN))=(0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (YR +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (YF +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (ICLK => YF) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (DOUT +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (OCLK => DOUT)=(0.1:0.1:0.1, 0.1:0.1:0.1);

        //checking setup and hold timing for inputs

        $setup(posedge YIN,posedge ICLK,0.0, NOTIFY_REG);
        $setup(negedge YIN,posedge ICLK,0.0, NOTIFY_REG);
        $hold(posedge ICLK,posedge YIN,0.0, NOTIFY_REG);
        $hold(posedge ICLK,negedge YIN,0.0, NOTIFY_REG);

        $setup(posedge YIN,negedge ICLK,0.0, NOTIFY_REG);
        $setup(negedge YIN,negedge ICLK,0.0, NOTIFY_REG);
        $hold(negedge ICLK,negedge YIN,0.0, NOTIFY_REG);
        $hold(negedge ICLK,posedge YIN,0.0, NOTIFY_REG);


        //checking timing for control signals


        $hold(posedge ICLK,negedge CLR,0.0, NOTIFY_REG);

        //checking the pulse width

        $width(posedge ICLK,0,  0, NOTIFY_REG);
        $width(negedge ICLK, 0, 0, NOTIFY_REG);
        $width(posedge CLR, 0.0, 0, NOTIFY_REG);

        //checing the recovery data

        $recovery(negedge CLR, posedge ICLK, 0.0, NOTIFY_REG);

        //check timing delay for output

        (E => EOUT)=(0.1:0.1:0.1, 0.1:0.1:0.1);

        //checking setup and hold timing for inputs

        $setup(posedge DR,posedge OCLK,0.0, NOTIFY_REG);
        $setup(negedge DR,posedge OCLK,0.0, NOTIFY_REG);
        $hold(posedge OCLK,posedge DR,0.0, NOTIFY_REG);
        $hold(posedge OCLK,negedge DR,0.0, NOTIFY_REG);

        $setup(posedge DF,posedge OCLK,0.0, NOTIFY_REG);
        $setup(negedge DF,posedge OCLK,0.0, NOTIFY_REG);
        $hold(posedge OCLK,negedge DF,0.0, NOTIFY_REG);
        $hold(posedge OCLK,posedge DF,0.0, NOTIFY_REG);

        //checking timing for control signals


        $hold(posedge OCLK,negedge CLR,0.0, NOTIFY_REG);

        //checking the pulse width

        $width(posedge OCLK,0,  0, NOTIFY_REG);
        $width(negedge OCLK, 0, 0, NOTIFY_REG);
        $width(posedge CLR, 0.0, 0, NOTIFY_REG);

        //checing the recovery data

        $recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);



    endspecify


endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME  : IOBI_ID_OD_ERC
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBI_ID_OD_ERC(E,DOUT,OCLK,CLR,DR,DF,YR,YF,ICLK,YIN,EOUT);
input E,OCLK,CLR,DR,DF,YIN,ICLK;
output DOUT,EOUT,YR,YF;

wire tmp_out, tmp_out0,tmp_out1;
supply1 VCC;
supply0 GND;

reg NOTIFY_REG;

    not INV_CLR(CLR_, CLR);

    Dffpr DF_1(tmp_out0, DR,OCLK,CLR_, VCC, GND, NOTIFY_REG);
    Dffpr DF_2(tmp_out1, DF,OCLK,CLR_, VCC, GND, NOTIFY_REG);
    UDP_MUX2 mux1(DOUT,tmp_out0,tmp_out1,OCLK);

    Dffpf DF_3(tmp_out, YIN,     ICLK, VCC,  VCC, GND, NOTIFY_REG);
    Dffpr DF_4(YF,      tmp_out, ICLK, CLR_, VCC, GND, NOTIFY_REG);
    Dffpr DF_5(YR,      YIN,     ICLK, CLR_, VCC, GND, NOTIFY_REG);

    Dffpr DF_6(EOUT, E,OCLK,CLR_, VCC, GND, NOTIFY_REG);



   specify

        //check timing delay for output

        (posedge ICLK => (YR +: YIN))=(0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (YR +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (YF +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (ICLK => YF) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (DOUT +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (OCLK => DOUT)=(0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (EOUT +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (OCLK => EOUT)=(0.1:0.1:0.1, 0.1:0.1:0.1);

        //checking setup and hold timing for inputs

        $setup(posedge YIN,posedge ICLK,0.0, NOTIFY_REG);
        $setup(negedge YIN,posedge ICLK,0.0, NOTIFY_REG);
        $hold(posedge ICLK,posedge YIN,0.0, NOTIFY_REG);
        $hold(posedge ICLK,negedge YIN,0.0, NOTIFY_REG);

        $setup(posedge YIN,negedge ICLK,0.0, NOTIFY_REG);
        $setup(negedge YIN,negedge ICLK,0.0, NOTIFY_REG);
        $hold(negedge ICLK,negedge YIN,0.0, NOTIFY_REG);
        $hold(negedge ICLK,posedge YIN,0.0, NOTIFY_REG);


        //checking timing for control signals


        $hold(posedge ICLK,negedge CLR,0.0, NOTIFY_REG);

        //checking the pulse width

        $width(posedge ICLK,0,  0, NOTIFY_REG);
        $width(negedge ICLK, 0, 0, NOTIFY_REG);
        $width(posedge CLR, 0.0, 0, NOTIFY_REG);

        //checing the recovery data

        $recovery(negedge CLR, posedge ICLK, 0.0, NOTIFY_REG);

        //check timing delay for output

        $setup(posedge DR,posedge OCLK,0.0, NOTIFY_REG);
        $setup(negedge DR,posedge OCLK,0.0, NOTIFY_REG);
        $hold(posedge OCLK,posedge DR,0.0, NOTIFY_REG);
        $hold(posedge OCLK,negedge DR,0.0, NOTIFY_REG);

        $setup(posedge DF,posedge OCLK,0.0, NOTIFY_REG);
        $setup(negedge DF,posedge OCLK,0.0, NOTIFY_REG);
        $hold(posedge OCLK,negedge DF,0.0, NOTIFY_REG);
        $hold(posedge OCLK,posedge DF,0.0, NOTIFY_REG);

        //checking timing for control signals

        $hold(posedge OCLK,negedge CLR,0.0, NOTIFY_REG);

        //checking the pulse width

        $width(posedge OCLK,0,  0, NOTIFY_REG);
        $width(negedge OCLK, 0, 0, NOTIFY_REG);

        //checing the recovery data

        $recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);

        $setup(posedge E,posedge OCLK,0.0, NOTIFY_REG);
        $setup(negedge E,posedge OCLK,0.0, NOTIFY_REG);
        $hold(posedge OCLK,posedge E,0.0, NOTIFY_REG);
        $hold(posedge OCLK,negedge E,0.0, NOTIFY_REG);


    endspecify


endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults




/*--------------------------------------------------------------------
 CELL NAME  : IOTRI_OD_EB
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OD_EB(E,EOUT,DOUT,OCLK,CLR,DR,DF);
input E,OCLK,CLR,DR,DF;
output DOUT, EOUT;

wire tmp_out0,tmp_out1;
supply1 VCC;
supply0 GND;

reg NOTIFY_REG;

    not INV_CLR(CLR_, CLR);
    buf buf_inst(EOUT,E);
   
    Dffpr DF_1(tmp_out0, DR,OCLK,CLR_, VCC, GND, NOTIFY_REG);
    Dffpr DF_2(tmp_out1, DF,OCLK,CLR_, VCC, GND, NOTIFY_REG);
    UDP_MUX2 mux1(DOUT,tmp_out0,tmp_out1,OCLK);

specify

         specparam   LibName     = "proasic3";
         specparam   InputLoad$DR = 2;
         specparam   InputLoad$DF = 2;
         specparam   InputLoad$CLR = 6;
         specparam   InputLoad$OCLK = 2;
         specparam   OutputLoad$DOUT = 2;

         specparam   MacroType = "ddr";
         specparam   SeqType   = "flipflop";

          //check timing delay for output

        (OCLK => DOUT)=(0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (DOUT +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (E => EOUT)=(0.1:0.1:0.1, 0.1:0.1:0.1);

        //checking setup and hold timing for inputs

        $setup(posedge DR,posedge OCLK,0.0, NOTIFY_REG);
        $setup(negedge DR,posedge OCLK,0.0, NOTIFY_REG);
        $hold(posedge OCLK,posedge DR,0.0, NOTIFY_REG);
        $hold(posedge OCLK,negedge DR,0.0, NOTIFY_REG);

        $setup(posedge DF,posedge OCLK,0.0, NOTIFY_REG);
        $setup(negedge DF,posedge OCLK,0.0, NOTIFY_REG);
        $hold(posedge OCLK,negedge DF,0.0, NOTIFY_REG);
        $hold(posedge OCLK,posedge DF,0.0, NOTIFY_REG);


        //checking timing for control signals


        $hold(posedge OCLK,negedge CLR,0.0, NOTIFY_REG);

        //checking the pulse width

        $width(posedge OCLK,0,  0, NOTIFY_REG);
        $width(negedge OCLK, 0, 0, NOTIFY_REG);
        $width(posedge CLR, 0.0, 0, NOTIFY_REG);

        //checing the recovery data

        $recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);


    endspecify


endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : IOIN_ID
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOIN_ID(YIN,ICLK,CLR,YR,YF);
input YIN, CLR, ICLK;
output YR,YF;

wire tmp_out;
supply1 VCC;
supply0 GND;
reg NOTIFY_REG;

    not INV_CLR(CLR_, CLR);
   
    Dffpf DF_0(tmp_out, YIN,     ICLK, VCC,  VCC, GND, NOTIFY_REG);
    Dffpr DF_1(YF,      tmp_out, ICLK, CLR_, VCC, GND, NOTIFY_REG);
    Dffpr DF_2(YR,      YIN,     ICLK, CLR_, VCC, GND, NOTIFY_REG);


 specify

         specparam   LibName     = "proasic3";
         specparam   InputLoad$YIN = 2;
         specparam   InputLoad$CLR = 6;
         specparam   InputLoad$ICLK = 2;
         specparam   OutputLoad$YR = 2;
         specparam   OutputLoad$YF = 2;

         specparam   MacroType = "ddr";
         specparam   SeqType   = "flipflop";

          //check timing delay for output

        (posedge ICLK => (YR +: YIN))=(0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (YR +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (ICLK => YF) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (YF +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);

        //checking setup and hold timing for inputs

        $setup(posedge YIN,posedge ICLK,0.0, NOTIFY_REG);
        $setup(negedge YIN,posedge ICLK,0.0, NOTIFY_REG);
        $hold(posedge ICLK,posedge YIN,0.0, NOTIFY_REG);
        $hold(posedge ICLK,negedge YIN,0.0, NOTIFY_REG);

        $setup(posedge YIN,negedge ICLK,0.0, NOTIFY_REG);
        $setup(negedge YIN,negedge ICLK,0.0, NOTIFY_REG);
        $hold(negedge ICLK,negedge YIN,0.0, NOTIFY_REG);
        $hold(negedge ICLK,posedge YIN,0.0, NOTIFY_REG);


        //checking timing for control signals


        $hold(posedge ICLK,negedge CLR,0.0, NOTIFY_REG);

        //checking the pulse width

        $width(posedge ICLK,0,  0, NOTIFY_REG);
        $width(negedge ICLK, 0, 0, NOTIFY_REG);
        $width(posedge CLR, 0.0, 0, NOTIFY_REG);

        //checing the recovery data

        $recovery(negedge CLR, posedge ICLK, 0.0, NOTIFY_REG);


    endspecify


endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults




/*--------------------------------------------------------------------
 CELL NAME  : IOTRI_OD_ERC
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOTRI_OD_ERC(E,EOUT,DOUT,OCLK,CLR,DR,DF);
input E,OCLK,CLR,DR,DF;
output DOUT, EOUT;

wire tmp_out0,tmp_out1;
supply1 VCC;
supply0 GND;

reg NOTIFY_REG;

    not INV_CLR(CLR_, CLR);

    Dffpr DF_0(EOUT,E,OCLK,CLR_, VCC, GND, NOTIFY_REG);
    Dffpr DF_1(tmp_out0, DR,OCLK,CLR_, VCC, GND, NOTIFY_REG);
    Dffpr DF_2(tmp_out1, DF,OCLK,CLR_, VCC, GND, NOTIFY_REG);
    UDP_MUX2 mux1(DOUT,tmp_out0,tmp_out1,OCLK);



 specify

         specparam   LibName     = "proasic3";
         specparam   InputLoad$DR = 2;
         specparam   InputLoad$DF = 2;
         specparam   InputLoad$CLR = 6;
         specparam   InputLoad$OCLK = 2;
         specparam   OutputLoad$DOUT = 2;

         specparam   MacroType = "ddr";
         specparam   SeqType   = "flipflop";

          //check timing delay for output

        (OCLK => DOUT)=(0.1:0.1:0.1, 0.1:0.1:0.1);
        (OCLK => EOUT)=(0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (DOUT +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (posedge CLR => (EOUT +: 1'b0)) = (0.1:0.1:0.1, 0.1:0.1:0.1);

        //checking setup and hold timing for inputs

        $setup(posedge DR,posedge OCLK,0.0, NOTIFY_REG);
        $setup(negedge DR,posedge OCLK,0.0, NOTIFY_REG);
        $hold(posedge OCLK,posedge DR,0.0, NOTIFY_REG);
        $hold(posedge OCLK,negedge DR,0.0, NOTIFY_REG);

        $setup(posedge DF,posedge OCLK,0.0, NOTIFY_REG);
        $setup(negedge DF,posedge OCLK,0.0, NOTIFY_REG);
        $hold(posedge OCLK,negedge DF,0.0, NOTIFY_REG);
        $hold(posedge OCLK,posedge DF,0.0, NOTIFY_REG);

        //checking timing for control signals

        $hold(posedge   OCLK,negedge CLR,0.0, NOTIFY_REG);

        //checking the pulse width

        $width(posedge OCLK,0,  0, NOTIFY_REG);
        $width(negedge OCLK, 0, 0, NOTIFY_REG);
        $width(posedge CLR, 0.0, 0, NOTIFY_REG);

        //checing the recovery data

        $recovery(negedge CLR, posedge OCLK, 0.0, NOTIFY_REG);

        $setup(posedge E,posedge OCLK,0.0, NOTIFY_REG);
        $setup(negedge E,posedge OCLK,0.0, NOTIFY_REG);
        $hold(posedge OCLK,posedge E,0.0, NOTIFY_REG);
        $hold(posedge OCLK,negedge E,0.0, NOTIFY_REG);

   endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults


/*-----------------------------------------------------------------
 CELL NAME : RAM4K9
-----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ps/1 ps

module RAM4K9 (ADDRA11, ADDRA10, ADDRA9, ADDRA8, ADDRA7, ADDRA6, ADDRA5,
               ADDRA4, ADDRA3, ADDRA2, ADDRA1, ADDRA0, DINA8, DINA7, DINA6,
               DINA5, DINA4, DINA3, DINA2, DINA1, DINA0, DOUTA8, DOUTA7,
               DOUTA6, DOUTA5, DOUTA4, DOUTA3, DOUTA2, DOUTA1, DOUTA0,
               WIDTHA1, WIDTHA0, PIPEA, WMODEA, BLKA, WENA, CLKA,
               ADDRB11, ADDRB10, ADDRB9, ADDRB8, ADDRB7, ADDRB6, ADDRB5,
               ADDRB4, ADDRB3, ADDRB2, ADDRB1, ADDRB0, DINB8, DINB7, DINB6,
               DINB5, DINB4, DINB3, DINB2, DINB1, DINB0, DOUTB8, DOUTB7,
               DOUTB6, DOUTB5, DOUTB4, DOUTB3, DOUTB2, DOUTB1, DOUTB0,
               WIDTHB1, WIDTHB0, PIPEB, WMODEB, BLKB, WENB, CLKB, RESET
              );

parameter DELAY_TWO = 2;
parameter TC2CWWL = 331;
parameter TC2CWWH = 303;
parameter TC2CRWH = 452;
parameter TC2CWRH = 493;

input ADDRA11, ADDRA10, ADDRA9, ADDRA8, ADDRA7, ADDRA6, ADDRA5, ADDRA4, ADDRA3, ADDRA2, ADDRA1, ADDRA0;
input DINA8, DINA7, DINA6, DINA5, DINA4, DINA3, DINA2, DINA1, DINA0;
input WIDTHA1, WIDTHA0, PIPEA, WMODEA, BLKA, WENA, CLKA;
input ADDRB11, ADDRB10, ADDRB9, ADDRB8, ADDRB7, ADDRB6, ADDRB5, ADDRB4, ADDRB3, ADDRB2, ADDRB1, ADDRB0;
input DINB8, DINB7, DINB6, DINB5, DINB4, DINB3, DINB2, DINB1, DINB0;
input WIDTHB1, WIDTHB0, PIPEB, WMODEB, BLKB, WENB, CLKB, RESET;

output DOUTA8, DOUTA7, DOUTA6, DOUTA5, DOUTA4, DOUTA3, DOUTA2, DOUTA1, DOUTA0;
output DOUTB8, DOUTB7, DOUTB6, DOUTB5, DOUTB4, DOUTB3, DOUTB2, DOUTB1, DOUTB0; 


reg DOUTAP8, DOUTAP7, DOUTAP6, DOUTAP5, DOUTAP4, DOUTAP3, DOUTAP2, DOUTAP1, DOUTAP0;
reg DOUTBP8, DOUTBP7, DOUTBP6, DOUTBP5, DOUTBP4, DOUTBP3, DOUTBP2, DOUTBP1, DOUTBP0;

reg DOUTAP8_stg1, DOUTAP7_stg1, DOUTAP6_stg1, DOUTAP5_stg1, DOUTAP4_stg1, DOUTAP3_stg1, DOUTAP2_stg1, DOUTAP1_stg1, DOUTAP0_stg1;
reg DOUTBP8_stg1, DOUTBP7_stg1, DOUTBP6_stg1, DOUTBP5_stg1, DOUTBP4_stg1, DOUTBP3_stg1, DOUTBP2_stg1, DOUTBP1_stg1, DOUTBP0_stg1;

wire CLKA_int, CLKB_int;
wire WENA_int, WENB_int, WMODEA_int, WMODEB_int;
wire BLKA_int, BLKB_int, RESET_int,  PIPEA_int, PIPEB_int;

wire ADDRA11_int, ADDRA10_int, ADDRA9_int, ADDRA8_int, ADDRA7_int, ADDRA6_int, ADDRA5_int, ADDRA4_int;
wire ADDRA3_int, ADDRA2_int, ADDRA1_int, ADDRA0_int;

wire ADDRB11_int, ADDRB10_int, ADDRB9_int, ADDRB8_int, ADDRB7_int, ADDRB6_int, ADDRB5_int, ADDRB4_int;
wire ADDRB3_int, ADDRB2_int, ADDRB1_int, ADDRB0_int;

wire DINA8_int, DINA7_int, DINA6_int, DINA5_int, DINA4_int, DINA3_int, DINA2_int, DINA1_int, DINA0_int;
wire DINB8_int, DINB7_int, DINB6_int, DINB5_int, DINB4_int, DINB3_int, DINB2_int, DINB1_int, DINB0_int;

reg [8:0] MEM_512_9 [0:511];

reg NOTIFY_REG;

integer ADDRA;            // Address of PORT A
integer ADDRB;            // Address of PORT B
integer DEPTH;
integer MAXADD;

reg  ADDRA_VALID;
reg  ADDRB_VALID;

wire BLKA_EN;
wire BLKB_EN;

wire BLKA_WEN;
wire BLKB_WEN;

time CLKA_wr_re, CLKA_rd_re;
time CLKA_wr_fe, CLKA_rd_fe;
time CLKB_wr_re, CLKB_rd_re;
time CLKB_wr_fe, CLKB_rd_fe;

reg  WENA_lat, WENB_lat;

reg  DINA8_reg, DINA7_reg, DINA6_reg, DINA5_reg, DINA4_reg, DINA3_reg, DINA2_reg, DINA1_reg, DINA0_reg;
reg  DINB8_reg, DINB7_reg, DINB6_reg, DINB5_reg, DINB4_reg, DINB3_reg, DINB2_reg, DINB1_reg, DINB0_reg;

reg  DINA8_bypass, DINA7_bypass, DINA6_bypass, DINA5_bypass, DINA4_bypass;
reg  DINA3_bypass, DINA2_bypass, DINA1_bypass, DINA0_bypass;

reg  DINB8_bypass, DINB7_bypass, DINB6_bypass, DINB5_bypass, DINB4_bypass;
reg  DINB3_bypass, DINB2_bypass, DINB1_bypass, DINB0_bypass;


/********************* TEXT MACRO DEFINITIONS ******************/

`define BLKA_WIDTH_CFG {WIDTHA1,WIDTHA0}
`define BLKB_WIDTH_CFG {WIDTHB1,WIDTHB0}

`define BLKA_ADDR      {ADDRA11_int,ADDRA10_int,ADDRA9_int,ADDRA8_int,ADDRA7_int,ADDRA6_int,ADDRA5_int,ADDRA4_int,ADDRA3_int,ADDRA2_int,ADDRA1_int,ADDRA0_int}
`define BLKB_ADDR      {ADDRB11_int,ADDRB10_int,ADDRB9_int,ADDRB8_int,ADDRB7_int,ADDRB6_int,ADDRB5_int,ADDRB4_int,ADDRB3_int,ADDRB2_int,ADDRB1_int,ADDRB0_int}

`define DATA_A_OUT     {DOUTAP8,DOUTAP7,DOUTAP6,DOUTAP5,DOUTAP4,DOUTAP3,DOUTAP2,DOUTAP1,DOUTAP0}
`define DATA_B_OUT     {DOUTBP8,DOUTBP7,DOUTBP6,DOUTBP5,DOUTBP4,DOUTBP3,DOUTBP2,DOUTBP1,DOUTBP0}

`define DATAP_A_OUT    {DOUTAP8_stg1,DOUTAP7_stg1,DOUTAP6_stg1,DOUTAP5_stg1,DOUTAP4_stg1,DOUTAP3_stg1,DOUTAP2_stg1,DOUTAP1_stg1,DOUTAP0_stg1}
`define DATAP_B_OUT    {DOUTBP8_stg1,DOUTBP7_stg1,DOUTBP6_stg1,DOUTBP5_stg1,DOUTBP4_stg1,DOUTBP3_stg1,DOUTBP2_stg1,DOUTBP1_stg1,DOUTBP0_stg1}

`define DATA_A_IN      {DINA8_int,DINA7_int,DINA6_int,DINA5_int,DINA4_int,DINA3_int,DINA2_int,DINA1_int,DINA0_int}
`define DATA_B_IN      {DINB8_int,DINB7_int,DINB6_int,DINB5_int,DINB4_int,DINB3_int,DINB2_int,DINB1_int,DINB0_int}

`define DATA_A_REG     {DINA8_reg,DINA7_reg,DINA6_reg,DINA5_reg,DINA4_reg,DINA3_reg,DINA2_reg,DINA1_reg,DINA0_reg}
`define DATA_B_REG     {DINB8_reg,DINB7_reg,DINB6_reg,DINB5_reg,DINB4_reg,DINB3_reg,DINB2_reg,DINB1_reg,DINB0_reg}

`define DATA_A_BYP     {DINA8_bypass,DINA7_bypass,DINA6_bypass,DINA5_bypass,DINA4_bypass,DINA3_bypass,DINA2_bypass,DINA1_bypass,DINA0_bypass}
`define DATA_B_BYP     {DINB8_bypass,DINB7_bypass,DINB6_bypass,DINB5_bypass,DINB4_bypass,DINB3_bypass,DINB2_bypass,DINB1_bypass,DINB0_bypass}

assign BLKA_EN = ~BLKA_int & RESET_int;
assign BLKB_EN = ~BLKB_int & RESET_int;
assign BLKA_WEN = ~BLKA_int & RESET_int & ~WENA_int;
assign BLKB_WEN = ~BLKB_int & RESET_int & ~WENB_int;

buf b0(CLKA_int, CLKA);
buf b1(CLKB_int, CLKB);
buf b2(WENA_int, WENA);
buf b3(WENB_int, WENB);

buf b4(DINA0_int, DINA0);
buf b5(DINA1_int, DINA1);
buf b6(DINA2_int, DINA2);
buf b7(DINA3_int, DINA3);
buf b8(DINA4_int, DINA4);
buf b9(DINA5_int, DINA5);
buf b10(DINA6_int, DINA6);
buf b11(DINA7_int, DINA7);
buf b12(DINA8_int, DINA8);


buf b13(DINB0_int, DINB0);
buf b14(DINB1_int, DINB1);
buf b15(DINB2_int, DINB2);
buf b16(DINB3_int, DINB3);
buf b17(DINB4_int, DINB4);
buf b18(DINB5_int, DINB5);
buf b19(DINB6_int, DINB6);
buf b20(DINB7_int, DINB7);
buf b21(DINB8_int, DINB8);

buf b22(ADDRA0_int, ADDRA0);
buf b23(ADDRA1_int, ADDRA1);
buf b24(ADDRA2_int, ADDRA2);
buf b25(ADDRA3_int, ADDRA3);
buf b26(ADDRA4_int, ADDRA4);
buf b27(ADDRA5_int, ADDRA5);
buf b28(ADDRA6_int, ADDRA6);
buf b29(ADDRA7_int, ADDRA7);
buf b30(ADDRA8_int, ADDRA8);
buf b31(ADDRA9_int, ADDRA9);
buf b32(ADDRA10_int, ADDRA10);
buf b33(ADDRA11_int, ADDRA11);

buf b34(ADDRB0_int, ADDRB0);
buf b35(ADDRB1_int, ADDRB1);
buf b36(ADDRB2_int, ADDRB2);
buf b37(ADDRB3_int, ADDRB3);
buf b38(ADDRB4_int, ADDRB4);
buf b39(ADDRB5_int, ADDRB5);
buf b40(ADDRB6_int, ADDRB6);
buf b41(ADDRB7_int, ADDRB7);
buf b42(ADDRB8_int, ADDRB8);
buf b43(ADDRB9_int, ADDRB9);
buf b44(ADDRB10_int, ADDRB10);
buf b45(ADDRB11_int, ADDRB11);

buf b46(RESET_int, RESET);
buf b47(BLKA_int, BLKA);
buf b48(BLKB_int, BLKB);
buf b49(PIPEA_int, PIPEA);
buf b50(PIPEB_int, PIPEB);
buf b51(WMODEA_int, WMODEA);
buf b52(WMODEB_int, WMODEB);

pmos inst1(DOUTA0, DOUTAP0, 0);
pmos inst2(DOUTA1, DOUTAP1, 0);
pmos inst3(DOUTA2, DOUTAP2, 0);
pmos inst4(DOUTA3, DOUTAP3, 0);
pmos inst5(DOUTA4, DOUTAP4, 0);
pmos inst6(DOUTA5, DOUTAP5, 0);
pmos inst7(DOUTA6, DOUTAP6, 0);
pmos inst8(DOUTA7, DOUTAP7, 0);
pmos inst9(DOUTA8, DOUTAP8, 0);

pmos inst10(DOUTB0, DOUTBP0, 0);
pmos inst11(DOUTB1, DOUTBP1, 0);
pmos inst12(DOUTB2, DOUTBP2, 0);
pmos inst13(DOUTB3, DOUTBP3, 0);
pmos inst14(DOUTB4, DOUTBP4, 0);
pmos inst15(DOUTB5, DOUTBP5, 0);
pmos inst16(DOUTB6, DOUTBP6, 0);
pmos inst17(DOUTB7, DOUTBP7, 0);
pmos inst18(DOUTB8, DOUTBP8, 0);

parameter MEMORYFILE = "";
parameter WARNING_MSGS_ON = 1; // Used to turn off warnings about read &
                               // write to same address at same time.
                               // Default = on.  Set to 0 to turn them off.

  initial
    begin
    
      if ( WARNING_MSGS_ON == 0 )
        $display("Note: RAM4K9 warnings disabled. Set WARNING_MSGS_ON = 1 to enable.");

      if ( MEMORYFILE != "")
        $readmemb ( MEMORYFILE, MEM_512_9 );
      else
        begin
          //if ( WARNING_MSGS_ON == 1 )
            //$display ( "Note: Module %m, memory initialization file parameter MEMORYFILE not defined" );
        end
    end


always @(CLKA_int === 1'bx )
begin
  if ($time > 0) begin
    if (BLKA_int == 1'b0) begin
      if ( WARNING_MSGS_ON == 1 )
        $display("Warning : CLKA went unknown at time %0.1f. Instance: %m\n",$realtime);
    end
  end
end

always @(CLKB_int === 1'bx )
begin
  if ($time > 0) begin
    if (BLKB_int == 1'b0) begin
      if ( WARNING_MSGS_ON == 1 )
        $display("Warning : CLKB went unknown at time %0.1f. Instance: %m\n",$realtime);
    end
  end
end

  always @(RESET_int )
      begin
	  if(RESET_int === 1'b0 )
	      begin
		  if (PIPEA_int == 1'b0) begin 
		      case (`BLKA_WIDTH_CFG)
			 2'b00 : DOUTAP0 = 1'b0;
			 2'b01 : begin
			     DOUTAP0 = 1'b0;
			     DOUTAP1 = 1'b0;
			 end
			 2'b10 : begin
			     DOUTAP0 = 1'b0;
			     DOUTAP1 = 1'b0;
			     DOUTAP2 = 1'b0;
			     DOUTAP3 = 1'b0;
			 end
			 2'b11 : begin
			     DOUTAP0 = 1'b0;
			     DOUTAP1 = 1'b0;
			     DOUTAP2 = 1'b0;
			     DOUTAP3 = 1'b0;
			     DOUTAP4 = 1'b0;
			     DOUTAP5 = 1'b0;
			     DOUTAP6 = 1'b0;
			     DOUTAP7 = 1'b0;
			     DOUTAP8 = 1'b0;
			 end
			 default:
			     begin
				 //if ( WARNING_MSGS_ON == 1 )
				 //    $display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9", $time);
			     end
		      endcase
		  end else if (PIPEA_int == 1'b1) begin
		      case (`BLKA_WIDTH_CFG)
			 2'b00 : begin
			     DOUTAP0      = 1'b0;
			     DOUTAP0_stg1 = 1'b0;
			 end
			 2'b01 : begin
			     DOUTAP0 = 1'b0;
			     DOUTAP1 = 1'b0;
			     DOUTAP0_stg1 = 1'b0;
			     DOUTAP1_stg1 = 1'b0;
			 end
			 2'b10 : begin
			     DOUTAP0= 1'b0;
			     DOUTAP1 = 1'b0;
			     DOUTAP2 = 1'b0;
			     DOUTAP3 = 1'b0;
			     DOUTAP0_stg1= 1'b0;
			     DOUTAP1_stg1 = 1'b0;
			     DOUTAP2_stg1 = 1'b0;
			     DOUTAP3_stg1 = 1'b0;
			 end
			 2'b11 : begin
			     DOUTAP0 = 1'b0;
			     DOUTAP1 = 1'b0;
			     DOUTAP2 = 1'b0;
			     DOUTAP3 = 1'b0;
			     DOUTAP4 = 1'b0;
			     DOUTAP5 = 1'b0;
			     DOUTAP6 = 1'b0;
			     DOUTAP7 = 1'b0;
			     DOUTAP8 = 1'b0;
			     DOUTAP0_stg1 = 1'b0;
			     DOUTAP1_stg1 = 1'b0;
			     DOUTAP2_stg1 = 1'b0;
			     DOUTAP3_stg1 = 1'b0;
			     DOUTAP4_stg1 = 1'b0;
			     DOUTAP5_stg1 = 1'b0;
			     DOUTAP6_stg1 = 1'b0;
			     DOUTAP7_stg1 = 1'b0;
			     DOUTAP8_stg1 = 1'b0;

			 end
			 default:
			     begin
				 //if ( WARNING_MSGS_ON == 1 )
				 //    $display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9", $time);
			     end
		      endcase
		  end

		  if (PIPEB_int == 1'b0) begin  
		      case (`BLKB_WIDTH_CFG)
			 2'b00 : DOUTBP0 = 1'b0;
			 2'b01 : begin
			     DOUTBP0 = 1'b0;
			     DOUTBP1 = 1'b0;
			 end
			 2'b10 : begin
			     DOUTBP0= 1'b0;
			     DOUTBP1 = 1'b0;
			     DOUTBP2 = 1'b0;
			     DOUTBP3 = 1'b0;
			 end
			 2'b11 : begin
			     DOUTBP0 = 1'b0;
			     DOUTBP1 = 1'b0;
			     DOUTBP2 = 1'b0;
			     DOUTBP3 = 1'b0;
			     DOUTBP4 = 1'b0;
			     DOUTBP5 = 1'b0;
			     DOUTBP6 = 1'b0;
			     DOUTBP7 = 1'b0;
			     DOUTBP8 = 1'b0;
			 end
			 default:
			     begin
				// if ( WARNING_MSGS_ON == 1 )
				//     $display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9", $time);
			     end
		      endcase

		  end else if (PIPEB_int == 1'b1) begin
		      case (`BLKB_WIDTH_CFG)
			 2'b00 : begin
			     DOUTBP0 = 1'b0;
			     DOUTBP0_stg1 = 1'b0;
			 end
			 2'b01 : begin
			     DOUTBP0 = 1'b0;
			     DOUTBP1 = 1'b0;
			     DOUTBP0_stg1 = 1'b0;
			     DOUTBP1_stg1 = 1'b0;

			 end
			 2'b10 : begin
			     DOUTBP0= 1'b0;
			     DOUTBP1 = 1'b0;
			     DOUTBP2 = 1'b0;
			     DOUTBP3 = 1'b0;
			     DOUTBP0_stg1= 1'b0;
			     DOUTBP1_stg1 = 1'b0;
			     DOUTBP2_stg1 = 1'b0;
			     DOUTBP3_stg1 = 1'b0;

			 end
			 2'b11 : begin
			     DOUTBP0 = 1'b0;
			     DOUTBP1 = 1'b0;
			     DOUTBP2 = 1'b0;
			     DOUTBP3 = 1'b0;
			     DOUTBP4 = 1'b0;
			     DOUTBP5 = 1'b0;
			     DOUTBP6 = 1'b0;
			     DOUTBP7 = 1'b0;
			     DOUTBP8 = 1'b0;
			     DOUTBP0_stg1 = 1'b0;
			     DOUTBP1_stg1 = 1'b0;
			     DOUTBP2_stg1 = 1'b0;
			     DOUTBP3_stg1 = 1'b0;
			     DOUTBP4_stg1 = 1'b0;
			     DOUTBP5_stg1 = 1'b0;
			     DOUTBP6_stg1 = 1'b0;
			     DOUTBP7_stg1 = 1'b0;
			     DOUTBP8_stg1 = 1'b0;

			 end
			 default:
			     begin
				 //if ( WARNING_MSGS_ON == 1 )
				 //    $display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9", $time);
			     end
		      endcase
		  end
	      end
      end // Reset

// start the RAM BLKA negative edge behavior to handle write/write conflicts
// This part is only added to UMC chips since their RAM cells are level triggered
// rather than being edge triggered.
always @(negedge CLKA_int) 
begin
	if ((BLKA_int == 1'b0) && (RESET_int == 1'b1)) begin
		if ( (WENA_lat == 1'b0) && ADDRA_VALID ) begin  // Write mode
			CLKA_wr_fe = $time;
			// Check if Write from Port B and Write from Port A are to the same address, 
			// and CLKA and CLKB fall simultaneously --> write data is non-deterministic
			if ( (WENB_lat == 1'b0) && same_addr(ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0} ) &&
                                                            ((CLKB_wr_fe + TC2CWWL) > CLKA_wr_fe) ) begin
				$display (" ** Warning: Port B Write and Port A Write to same address at same time. Write data conflict. Updating memory contents at conflicting address with X"); 
				$display (" Time: %0.1f ps Instance: %m ", $realtime );
				// function call to determine conflicting write data bits based on address and width configuration
				`DATA_A_REG = drive_data_x (ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0}, `DATA_A_IN);
				
				case (`BLKA_WIDTH_CFG)
					2'b00 : begin
							MEM_512_9[ ADDRA[11:3] ] [ ADDRA[2:0] ] = DINA0_reg;
						end
					2'b01 : begin
						MEM_512_9[ ADDRA[10:2] ] [ ADDRA[1:0] * 2 ] = DINA0_reg;
						MEM_512_9[ ADDRA[10:2] ] [ ADDRA[1:0] * 2 + 1 ] = DINA1_reg;
					end
					2'b10 : begin
						MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 ] = DINA0_reg;
						MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 1 ] = DINA1_reg;
						MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 2 ] = DINA2_reg;
						MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 3 ] = DINA3_reg;
					end
					2'b11 : begin
						MEM_512_9[ ADDRA ] = {DINA8_reg,DINA7_reg,DINA6_reg,DINA5_reg,DINA4_reg,DINA3_reg,DINA2_reg,DINA1_reg,DINA0_reg};
					end
					default: begin
						if ( WARNING_MSGS_ON == 1 )
							$display ("Warning: Invalid WIDTH configuration at time %d ns. Legal Width: 1, 2, 4, 9. Instance: %m", $time);
					end
				endcase
			end
			
			// Check if CLKA falls while there is a Write from Port B to the same address, X is written to the RAM
			else if ( (WENB_lat == 1'b0) && same_addr(ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0} ) &&
									(CLKB_int == 1'b1) ) begin
				if ((CLKB_wr_re + TC2CWWH) < CLKA_wr_re) begin
					$display (" ** Warning: Port B Write and Port A Write to same address at same time. Write data conflict. Updating memory contents at conflicting address with X"); 
					$display (" Time: %0.1f ps Instance: %m ", $realtime );
					// function call to determine conflicting write data bits based on address and width configuration
					`DATA_A_REG = drive_data_x (ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0}, `DATA_A_IN);
					
					case (`BLKA_WIDTH_CFG)
						2'b00 : begin
								MEM_512_9[ ADDRA[11:3] ] [ ADDRA[2:0] ] = DINA0_reg;
							end
						2'b01 : begin
							MEM_512_9[ ADDRA[10:2] ] [ ADDRA[1:0] * 2 ] = DINA0_reg;
							MEM_512_9[ ADDRA[10:2] ] [ ADDRA[1:0] * 2 + 1 ] = DINA1_reg;
						end
						2'b10 : begin
							MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 ] = DINA0_reg;
							MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 1 ] = DINA1_reg;
							MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 2 ] = DINA2_reg;
							MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 3 ] = DINA3_reg;
						end
						2'b11 : begin
							MEM_512_9[ ADDRA ] = {DINA8_reg,DINA7_reg,DINA6_reg,DINA5_reg,DINA4_reg,DINA3_reg,DINA2_reg,DINA1_reg,DINA0_reg};
						end
						default: begin
							if ( WARNING_MSGS_ON == 1 )
								$display ("Warning: Invalid WIDTH configuration at time %d ns. Legal Width: 1, 2, 4, 9. Instance: %m", $time);
						end
					endcase
				end
			end
		end
	end
end

// start the RAM BLKB negative edge behavior to handle write/write conflicts
// This part is only added to UMC chips since their RAM cells are level triggered
// rather than being edge triggered.
always @(negedge CLKB_int) begin
	if ((BLKB_int == 1'b0) && (RESET_int == 1'b1)) begin
		if ( (WENB_lat == 1'b0) && ADDRB_VALID ) begin // Write mode
			CLKB_wr_fe = $time;

			// Check if Write from Port B and Write from Port A are to the same address, 
			// and CLKA and CLKB fall simultaneously --> write data is non-deterministic
			// Cases B1, B4
			if ( (WENA_lat == 1'b0) && same_addr(ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0} ))
			begin
				if ((CLKA_wr_fe + TC2CWWL) > CLKB_wr_fe ) 
				begin
					$display (" ** Warning: Port B Write and Port A Write to same address at same time. Write data conflict. Updating memory contents at conflicting address with X"); 
					$display (" Time: %0.1f ps Instance: %m ", $realtime );
					// function call to determine conflicting write data bits based on address and width configuration
					`DATA_B_REG = drive_data_x (ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0}, `DATA_B_IN);
				
					case (`BLKB_WIDTH_CFG)
						2'b00 : begin
								MEM_512_9[ ADDRB[11:3] ] [ ADDRB[2:0] ] = DINB0_reg;
							end
						2'b01 : begin
							MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 ] = DINB0_reg;
							MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 + 1 ] = DINB1_reg;
						end
						2'b10 : begin
							MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 ] = DINB0_reg;
							MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 1 ] = DINB1_reg;
							MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 2 ] = DINB2_reg;
							MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 3 ] = DINB3_reg;
						end
						2'b11 : begin
							MEM_512_9[ ADDRB ] = {DINB8_reg,DINB7_reg,DINB6_reg,DINB5_reg,DINB4_reg,DINB3_reg,DINB2_reg,DINB1_reg,DINB0_reg};
						end
						default: begin
							if ( WARNING_MSGS_ON == 1 )
								$display ("Warning: Invalid WIDTH configuration at time %d ns. Legal Width: 1, 2, 4, 9. Instance: %m", $time);
						end
					endcase
				end
				// Check if CLKB falls while there is a Write from Port A to the same address, DATA_A_IN is written to the RAM
				else if ( CLKA_int == 1'b1 ) 
				begin
					// Cases B5
					if ((CLKA_wr_re + TC2CWWH) < CLKB_wr_re) begin
						$display (" ** Warning: Port B Write and Port A Write to same address at same time. Write data conflict. Updating memory contents at conflicting address with X"); 
						$display (" Time: %0.1f ps Instance: %m ", $realtime );
						// function call to determine conflicting write data bits based on address and width configuration
						`DATA_B_REG = drive_data_x (ADDRA, ADDRB, {WIDTHA1,WIDTHA0}, {WIDTHB1,WIDTHB0}, `DATA_B_IN);
						
						case (`BLKB_WIDTH_CFG)
							2'b00 : begin
									MEM_512_9[ ADDRB[11:3] ] [ ADDRB[2:0] ] = DINB0_reg;
								end
							2'b01 : begin
								MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 ] = DINB0_reg;
								MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 + 1 ] = DINB1_reg;
							end
							2'b10 : begin
								MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 ] = DINB0_reg;
								MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 1 ] = DINB1_reg;
								MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 2 ] = DINB2_reg;
								MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 3 ] = DINB3_reg;
							end
							2'b11 : begin
								MEM_512_9[ ADDRB ] = {DINB8_reg,DINB7_reg,DINB6_reg,DINB5_reg,DINB4_reg,DINB3_reg,DINB2_reg,DINB1_reg,DINB0_reg};
							end
							default: begin
								if ( WARNING_MSGS_ON == 1 )
									$display ("Warning: Invalid WIDTH configuration at time %d ns. Legal Width: 1, 2, 4, 9. Instance: %m", $time);
							end
						endcase
					end
				end
			end
		end
	end
end
	  
// start the RAM BLKA write/read  behavior section
always @(posedge CLKA_int) begin

  if (PIPEA_int == 1'b1) begin
    case (`BLKA_WIDTH_CFG)
      2'b00 : begin 
               DOUTAP0 = DOUTAP0_stg1;
              end
      2'b01 : begin
               DOUTAP0 = DOUTAP0_stg1;
               DOUTAP1 = DOUTAP1_stg1;
              end
      2'b10 : begin
               DOUTAP0 = DOUTAP0_stg1;
               DOUTAP1 = DOUTAP1_stg1;
               DOUTAP2 = DOUTAP2_stg1;
               DOUTAP3 = DOUTAP3_stg1;
              end
      2'b11 : begin
               DOUTAP0 = DOUTAP0_stg1;
               DOUTAP1 = DOUTAP1_stg1;
               DOUTAP2 = DOUTAP2_stg1;
               DOUTAP3 = DOUTAP3_stg1;
               DOUTAP4 = DOUTAP4_stg1;
               DOUTAP5 = DOUTAP5_stg1;
               DOUTAP6 = DOUTAP6_stg1;
               DOUTAP7 = DOUTAP7_stg1;
               DOUTAP8 = DOUTAP8_stg1;
             end
      default:
              begin
                if ( WARNING_MSGS_ON == 1 )
                  $display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9. Instance: %m", $time);
              end
    endcase
  end
  else if (PIPEA_int == 1'bx) begin
    if ( WARNING_MSGS_ON == 1 )
      $display ("Warning: PIPEA unknown at time %d ns, no data was read. Instance: %m", $time);
    DOUTAP0 = 1'bx;
    DOUTAP1 = 1'bx;
    DOUTAP2 = 1'bx;
    DOUTAP3 = 1'bx;
    DOUTAP4 = 1'bx;
    DOUTAP5 = 1'bx;
    DOUTAP6 = 1'bx;
    DOUTAP7 = 1'bx;
    DOUTAP8 = 1'bx;
  end

  if ((BLKA_int == 1'b0) && (RESET_int == 1'b1)) begin

    WENA_lat = WENA_int;

    ADDRA = get_address(`BLKA_ADDR);   // get the address (read or write ) 
    ADDRA_VALID = 1;

    if ((^ADDRA) === 1'bx) begin
      ADDRA_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display(" Warning: Illegal address on port A at time %0.1f! Instance: %m", $realtime);
    end
    else if ((`BLKA_WIDTH_CFG == 2'b00) && (ADDRA > 4095)) begin
      ADDRA_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display(" Warning: Illegal address on port A at time %0.1f! Instance: %m", $realtime);
    end
    else if ((`BLKA_WIDTH_CFG == 2'b01) && (ADDRA > 2047)) begin
      ADDRA_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display(" Warning: Illegal address on port A at time %0.1f! Instance: %m", $realtime);
    end
    else if ((`BLKA_WIDTH_CFG == 2'b10) && (ADDRA > 1023)) begin
      ADDRA_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display(" Warning: Illegal address on port A at time %0.1f! Instance: %m", $realtime);
    end
    else if ((`BLKA_WIDTH_CFG == 2'b11) && (ADDRA > 511)) begin
      ADDRA_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display(" Warning: Illegal address on port A at time %0.1f! Instance: %m", $realtime);
    end

		if ( (WENA_int == 1'b0) && ADDRA_VALID ) begin  // Write mode
    	CLKA_wr_re = $time;
			
			// assign write data to data registers for writing into the memory array
			`DATA_A_REG = `DATA_A_IN;
			// assign write data to bypass registers for driving onto RD if MODE=1 
			`DATA_A_BYP = `DATA_A_IN;

      // Check if Write from Port B and Write from Port A are to the same address, write data is non-deterministic
			// Cases B1-B3
      if ( (WENB_lat == 1'b0) && same_addr(ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0} ) &&
                                                            ((CLKB_wr_re + TC2CWWH) > CLKA_wr_re) ) begin
        $display (" ** Warning: Port B Write and Port A Write to same address at same time. Write data conflict. Updating memory contents at conflicting address with X"); 
        $display (" Time: %0.1f ps Instance: %m ", $realtime );
        // function call to determine conflicting write data bits based on address and width configuration
        `DATA_A_REG = drive_data_x (ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0}, `DATA_A_IN);
      end

      // Check for Read from Port B and Write from Port A to the same address, read data on Port B is driven to X
      if ( (WENB_lat == 1'b1) && same_addr(ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0}) &&
                                                              ((CLKB_rd_re + TC2CRWH) > CLKA_wr_re) ) begin
        $display (" ** Warning: Port B Read and Port A Write to same address at same time. Port B read data is unpredictable, driving read data to X");
        $display (" Time: %0.1f ps Instance: %m ", $realtime );

        if (PIPEB_int == 1'b1)
				begin
					case (`BLKB_WIDTH_CFG)
						2'b00 : begin
										DOUTBP0_stg1 = MEM_512_9[ ADDRB[11:3] ] [ ADDRB[2:0] ];
										end
						2'b01 : begin
										DOUTBP0_stg1 = MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 ];
										DOUTBP1_stg1 = MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 + 1 ];
										end
						2'b10 : begin
										DOUTBP0_stg1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 ];
										DOUTBP1_stg1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 1 ];
										DOUTBP2_stg1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 2 ];
										DOUTBP3_stg1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 3 ];
										end
						2'b11 : begin
										{DOUTBP8_stg1, DOUTBP7_stg1, DOUTBP6_stg1, DOUTBP5_stg1, DOUTBP4_stg1,
																	 DOUTBP3_stg1, DOUTBP2_stg1, DOUTBP1_stg1, DOUTBP0_stg1} = MEM_512_9[ ADDRB ];
										end
						default:
							 begin
								if ( WARNING_MSGS_ON == 1 )
									$display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9. Instance: %m", $time);
							 end
					endcase
          `DATAP_B_OUT = drive_data_x (ADDRA, ADDRB, {WIDTHA1,WIDTHA0}, {WIDTHB1,WIDTHB0}, `DATAP_B_OUT);
				end
        else if (PIPEB_int == 1'b0)
				begin
					case (`BLKB_WIDTH_CFG)
						2'b00 : begin
										DOUTBP0 = MEM_512_9[ ADDRB[11:3] ] [ ADDRB[2:0] ];
										end
						2'b01 : begin
										DOUTBP0 = MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 ];
										DOUTBP1 = MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 + 1 ];
										end
						2'b10 : begin
										DOUTBP0 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 ];
										DOUTBP1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 1 ];
										DOUTBP2 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 2 ];
										DOUTBP3 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 3 ];
										end
						2'b11 : begin
										{DOUTBP8, DOUTBP7, DOUTBP6, DOUTBP5, DOUTBP4,
															DOUTBP3, DOUTBP2, DOUTBP1, DOUTBP0} = MEM_512_9[ ADDRB ];
										end
						default:
							 begin
								if ( WARNING_MSGS_ON == 1 )
									$display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9. Instance: %m", $time);
							 end
					endcase
          `DATA_B_OUT = drive_data_x (ADDRA, ADDRB, {WIDTHA1,WIDTHA0}, {WIDTHB1,WIDTHB0}, `DATA_B_OUT);
				end
      end


      case (`BLKA_WIDTH_CFG)
				2'b00 : begin
						MEM_512_9[ ADDRA[11:3] ] [ ADDRA[2:0] ] = DINA0_reg;
							if (WMODEA_int == 1'b1) begin
								if (PIPEA_int == 1'b0) begin 
									DOUTAP0 = DINA0_bypass;
								end else if (PIPEA_int == 1'b1) begin
									DOUTAP0_stg1 = DINA0_bypass;
								end 
							end
					end

				2'b01 : begin
					MEM_512_9[ ADDRA[10:2] ] [ ADDRA[1:0] * 2 ] = DINA0_reg;
					MEM_512_9[ ADDRA[10:2] ] [ ADDRA[1:0] * 2 + 1 ] = DINA1_reg;
					if (WMODEA_int == 1'b1) begin
						if (PIPEA_int == 1'b0) begin
							DOUTAP0 = DINA0_bypass;
							DOUTAP1 = DINA1_bypass;
						end else if (PIPEA_int == 1'b1) begin
							DOUTAP0_stg1 = DINA0_bypass;
							DOUTAP1_stg1 = DINA1_bypass;
						end
					end
				end

				2'b10 : begin
					MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 ] = DINA0_reg;
					MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 1 ] = DINA1_reg;
					MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 2 ] = DINA2_reg;
					MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 3 ] = DINA3_reg;

					if (WMODEA_int == 1'b1) begin
						if (PIPEA_int == 1'b0) begin
							DOUTAP0 = DINA0_bypass;
							DOUTAP1 = DINA1_bypass;
							DOUTAP2 = DINA2_bypass;
							DOUTAP3 = DINA3_bypass;
						end else if (PIPEA_int == 1'b1) begin
							DOUTAP0_stg1 = DINA0_bypass;
							DOUTAP1_stg1 = DINA1_bypass;
							DOUTAP2_stg1 = DINA2_bypass;
							DOUTAP3_stg1 = DINA3_bypass;
						end
					end
				end
			  
				2'b11 : begin
					MEM_512_9[ ADDRA ] = {DINA8_reg,DINA7_reg,DINA6_reg,DINA5_reg,DINA4_reg,DINA3_reg,DINA2_reg,DINA1_reg,DINA0_reg};
					if (WMODEA_int == 1'b1) begin
						if (PIPEA_int == 1'b0) begin
							DOUTAP0 = DINA0_bypass;
							DOUTAP1 = DINA1_bypass;
							DOUTAP2 = DINA2_bypass;
							DOUTAP3 = DINA3_bypass;
							DOUTAP4 = DINA4_bypass;
							DOUTAP5 = DINA5_bypass;
							DOUTAP6 = DINA6_bypass;
							DOUTAP7 = DINA7_bypass;
							DOUTAP8 = DINA8_bypass;
						end else if (PIPEA_int == 1'b1) begin
							DOUTAP0_stg1 = DINA0_bypass;
							DOUTAP1_stg1 = DINA1_bypass;
							DOUTAP2_stg1 = DINA2_bypass;
							DOUTAP3_stg1 = DINA3_bypass;
							DOUTAP4_stg1 = DINA4_bypass;
							DOUTAP5_stg1 = DINA5_bypass;
							DOUTAP6_stg1 = DINA6_bypass;
							DOUTAP7_stg1 = DINA7_bypass;
							DOUTAP8_stg1 = DINA8_bypass;
						end
					end
				end

				default: begin
					if ( WARNING_MSGS_ON == 1 )
						$display ("Warning: Invalid WIDTH configuration at time %d ns. Legal Width: 1, 2, 4, 9. Instance: %m", $time);
				end
			endcase

			end else if ( (WENA_int == 1'b1) && ADDRA_VALID ) begin // Read mode

        CLKA_rd_re = $time;
				
				// No pipeline
        if (PIPEA_int == 1'b0) begin
					case (`BLKA_WIDTH_CFG)
							2'b00 : begin 
											DOUTAP0 = MEM_512_9[ ADDRA[11:3] ] [ ADDRA[2:0] ];
											end
							2'b01 : begin
											DOUTAP0 = MEM_512_9[ ADDRA[10:2] ] [ ADDRA[1:0] * 2 ];
											DOUTAP1 = MEM_512_9[ ADDRA[10:2] ] [ ADDRA[1:0] * 2 + 1 ];
									end
							2'b10 : begin
											DOUTAP0 = MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 ];
											DOUTAP1 = MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 1 ];
											DOUTAP2 = MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 2 ];
											DOUTAP3 = MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 3 ];
									end
							2'b11 : begin
											{DOUTAP8, DOUTAP7, DOUTAP6, DOUTAP5, DOUTAP4, 
																DOUTAP3, DOUTAP2, DOUTAP1, DOUTAP0} = MEM_512_9[ ADDRA ];
											end
							 default:
								 begin
									if ( WARNING_MSGS_ON == 1 )
										$display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9. Instance: %m", $time);
								 end
					endcase
					// Check for Write from Port B and Read from Port A to the same address, read data on Port A is driven to X
          if ( (WENB_lat == 1'b0) && same_addr(ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0}) &&
                                                                  ((CLKB_wr_re + TC2CWRH) > CLKA_rd_re) ) begin
            $display (" ** Warning: Port B Write and Port A Read to same address at same time. Port A read data is unpredictable, driving read data to X.");
            $display (" Time: %0.1f ps Instance: %m ", $realtime );
            `DATA_A_OUT = drive_data_x (ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0}, `DATA_A_OUT);
          end

        end else if (PIPEA_int == 1'b1) begin		// pipeline
					case (`BLKA_WIDTH_CFG)
						2'b00 : begin 
										DOUTAP0_stg1 = MEM_512_9[ ADDRA[11:3] ] [ ADDRA[2:0] ];
										end
						2'b01 : begin
										DOUTAP0_stg1 = MEM_512_9[ ADDRA[10:2] ] [ ADDRA[1:0] * 2 ];
										DOUTAP1_stg1 = MEM_512_9[ ADDRA[10:2] ] [ ADDRA[1:0] * 2 + 1 ];
										end
						2'b10 : begin
										DOUTAP0_stg1 = MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 ];
										DOUTAP1_stg1 = MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 1 ];
										DOUTAP2_stg1 = MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 2 ];
										DOUTAP3_stg1 = MEM_512_9[ ADDRA[9:1] ] [ ADDRA[0] * 4 + 3 ];
										end
						2'b11 : begin
										{DOUTAP8_stg1, DOUTAP7_stg1, DOUTAP6_stg1, DOUTAP5_stg1, DOUTAP4_stg1,
																	 DOUTAP3_stg1, DOUTAP2_stg1, DOUTAP1_stg1, DOUTAP0_stg1} = MEM_512_9[ ADDRA ];
										end
						 default:
							 begin
								if ( WARNING_MSGS_ON == 1 )
									$display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9. Instance: %m", $time);
							 end
					endcase
          // Check for Write from Port B and Read from Port A to the same address, read data on Port A is driven to X
					if ( (WENB_lat == 1'b0) && same_addr(ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0}) &&
																																((CLKB_wr_re + TC2CWRH) > CLKA_rd_re) ) begin
						$display (" ** Warning: Port B Write and Port A Read to same address at same time. Port A read data is unpredictable, driving read data to X.");
						$display (" Time: %0.1f ps Instance: %m ", $realtime );
						`DATAP_A_OUT = drive_data_x (ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0}, `DATAP_A_OUT);
					end

        end else begin
                if ( WARNING_MSGS_ON == 1 )
                  $display ("Warning: PIPEA unknown at time %d ns, no data was read. Instance: %m", $time);
                DOUTAP0 = 1'bx;
                DOUTAP1 = 1'bx;
                DOUTAP2 = 1'bx;
                DOUTAP3 = 1'bx;
                DOUTAP4 = 1'bx;
                DOUTAP5 = 1'bx;
                DOUTAP6 = 1'bx;
                DOUTAP7 = 1'bx;
                DOUTAP8 = 1'bx;
              end
      end else if ( (WENA_int == 1'b0) && (ADDRA_VALID == 0) ) begin
        if ( WARNING_MSGS_ON == 1 )
          $display("Illegal Write Address on port A, Write Not Initiated. Instance: %m");
      end else if ( (WENA_int == 1'b1) && (ADDRA_VALID == 0) ) begin
        if ( WARNING_MSGS_ON == 1 )
          $display("Illegal Read Address on port A, Read Not Initiated. Instance: %m");
      end else begin
        if ( WARNING_MSGS_ON == 1 )
          $display("Warning: WENAis unknown at time %d ns. Instance: %m", $time);
      end
    end
 end
   
                          
  
// start the RAM BLKB write/read  behavior section

always @(posedge CLKB_int) begin

  if (PIPEB_int == 1'b1) begin
    case (`BLKB_WIDTH_CFG)
      2'b00 : begin 
               DOUTBP0 = DOUTBP0_stg1;
              end
      2'b01 : begin
               DOUTBP0 = DOUTBP0_stg1;
               DOUTBP1 = DOUTBP1_stg1;
              end
      2'b10 : begin
               DOUTBP0 = DOUTBP0_stg1;
               DOUTBP1 = DOUTBP1_stg1;
               DOUTBP2 = DOUTBP2_stg1;
               DOUTBP3 = DOUTBP3_stg1;
              end
      2'b11 : begin
               DOUTBP0 = DOUTBP0_stg1;
               DOUTBP1 = DOUTBP1_stg1;
               DOUTBP2 = DOUTBP2_stg1;
               DOUTBP3 = DOUTBP3_stg1;
               DOUTBP4 = DOUTBP4_stg1;
               DOUTBP5 = DOUTBP5_stg1;
               DOUTBP6 = DOUTBP6_stg1;
               DOUTBP7 = DOUTBP7_stg1;
               DOUTBP8 = DOUTBP8_stg1;
             end
      default:
              begin
                if ( WARNING_MSGS_ON == 1 )
                  $display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9. Instance: %m", $time);
              end
    endcase
  end
  else if (PIPEB_int == 1'bx) begin
    if ( WARNING_MSGS_ON == 1 )
      $display ("Warning: PIPEB unknown at time %d ns, no data was read. Instance: %m", $time); 
    DOUTBP0 = 1'bx;
    DOUTBP1 = 1'bx;
    DOUTBP2 = 1'bx;
    DOUTBP3 = 1'bx;
    DOUTBP4 = 1'bx;
    DOUTBP5 = 1'bx;
    DOUTBP6 = 1'bx;
    DOUTBP7 = 1'bx;
    DOUTBP8 = 1'bx;
  end
 

  if ((BLKB_int == 1'b0) && (RESET_int == 1'b1)) begin

    WENB_lat = WENB_int;

    ADDRB = get_address(`BLKB_ADDR);   // get the address (read or write )
    ADDRB_VALID = 1;

    if ((^ADDRB) === 1'bx) begin
      ADDRB_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display(" Warning: Illegal address on port B at time %0.1f! Instance: %m", $realtime);
    end
    else if ((`BLKB_WIDTH_CFG == 2'b00) && (ADDRB > 4095)) begin
      ADDRB_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display(" Warning: Illegal address on port B at time %0.1f! Instance: %m", $realtime);
    end
    else if ((`BLKB_WIDTH_CFG == 2'b01) && (ADDRB > 2047)) begin
      ADDRB_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display(" Warning: Illegal address on port B at time %0.1f! Instance: %m", $realtime);
    end
    else if ((`BLKB_WIDTH_CFG == 2'b10) && (ADDRB > 1023)) begin
      ADDRB_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display(" Warning: Illegal address on port B at time %0.1f! Instance: %m", $realtime);
    end
    else if ((`BLKB_WIDTH_CFG == 2'b11) && (ADDRB > 511)) begin
      ADDRB_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display(" Warning: Illegal address on port B at time %0.1f! Instance: %m", $realtime);
    end

		if ( (WENB_int == 1'b0) && ADDRB_VALID ) begin // Write mode
			CLKB_wr_re = $time;
			
			// assign write data to data registers for writing into the memory array
			`DATA_B_REG = `DATA_B_IN;
			// assign write data to bypass registers for driving onto RD if MODE=1 
			`DATA_B_BYP = `DATA_B_IN;

      // Check if Write from Port A and Write from Port A are to the same address, write data is non-deterministic
			// Cases B1-B3
      if ( (WENA_lat == 1'b0) && same_addr(ADDRA, ADDRB, {WIDTHA1,WIDTHA0}, {WIDTHB1,WIDTHB0} ) &&
                                                            ((CLKA_wr_re + TC2CWWH) > CLKB_wr_re) ) begin
        $display (" ** Warning: Port A Write and Port B Write to same address at same time. Write data conflict. Updating memory contents at conflicting address with X"); 
        // function call to determine conflicting write data bits based on address and width configuration
        $display (" Time: %0.1f ps Instance: %m ", $realtime );
        `DATA_B_REG = drive_data_x (ADDRA, ADDRB, {WIDTHA1,WIDTHA0}, {WIDTHB1,WIDTHB0}, `DATA_B_IN);
			end

      // Check for Read from Port A and Write from Port B to the same address, read data on Port A is driven to X
      if ( (WENA_lat == 1'b1) && same_addr(ADDRA, ADDRB, {WIDTHA1,WIDTHA0}, {WIDTHB1,WIDTHB0}) &&
                                                              ((CLKA_rd_re + TC2CRWH) > CLKB_wr_re) ) begin
        $display (" ** Warning: Port A Read and Port B Write to same address at same time. Port A read data is unpredictable, driving read data to X");
        $display (" Time: %0.1f ps Instance: %m ", $realtime );

        if (PIPEA_int == 1'b1)
				begin
					case (`BLKB_WIDTH_CFG)
						2'b00 : begin
										DOUTBP0_stg1 = MEM_512_9[ ADDRB[11:3] ] [ ADDRB[2:0] ];
										end
						2'b01 : begin
										DOUTBP0_stg1 = MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 ];
										DOUTBP1_stg1 = MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 + 1 ];
										end
						2'b10 : begin
										DOUTBP0_stg1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 ];
										DOUTBP1_stg1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 1 ];
										DOUTBP2_stg1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 2 ];
										DOUTBP3_stg1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 3 ];
										end
						2'b11 : begin
										{DOUTBP8_stg1, DOUTBP7_stg1, DOUTBP6_stg1, DOUTBP5_stg1, DOUTBP4_stg1,
																	 DOUTBP3_stg1, DOUTBP2_stg1, DOUTBP1_stg1, DOUTBP0_stg1} = MEM_512_9[ ADDRB ];
										end
						default:
							 begin
								if ( WARNING_MSGS_ON == 1 )
									$display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9. Instance: %m", $time);
							 end
					endcase
          `DATAP_A_OUT = drive_data_x (ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0}, `DATAP_A_OUT);
				end
        else if (PIPEA_int == 1'b0)
				begin
          case (`BLKB_WIDTH_CFG)
						2'b00 : begin
										DOUTBP0 = MEM_512_9[ ADDRB[11:3] ] [ ADDRB[2:0] ];
										end
						2'b01 : begin
										DOUTBP0 = MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 ];
										DOUTBP1 = MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 + 1 ];
										end
						2'b10 : begin
										DOUTBP0 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 ];
										DOUTBP1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 1 ];
										DOUTBP2 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 2 ];
										DOUTBP3 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 3 ];
										end
						2'b11 : begin
										{DOUTBP8, DOUTBP7, DOUTBP6, DOUTBP5, DOUTBP4,
															DOUTBP3, DOUTBP2, DOUTBP1, DOUTBP0} = MEM_512_9[ ADDRB ];
										end
						default:
							 begin
								if ( WARNING_MSGS_ON == 1 )
									$display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9. Instance: %m", $time);
							 end
					endcase
					`DATA_A_OUT = drive_data_x (ADDRB, ADDRA, {WIDTHB1,WIDTHB0}, {WIDTHA1,WIDTHA0}, `DATA_A_OUT);
				end
      end
			
			
			case (`BLKB_WIDTH_CFG)
				2'b00 : begin
						MEM_512_9[ ADDRB[11:3] ] [ ADDRB[2:0] ] = DINB0_reg;
							if (WMODEB_int == 1'b1) begin
								if (PIPEB_int == 1'b0) begin 
									DOUTBP0 = DINB0_bypass;
								end else if (PIPEB_int == 1'b1) begin
									DOUTBP0_stg1 = DINB0_bypass;
								end 
							end
					end

				2'b01 : begin
					MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 ] = DINB0_reg;
					MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 + 1 ] = DINB1_reg;
					if (WMODEB_int == 1'b1) begin
						if (PIPEB_int == 1'b0) begin
							DOUTBP0 = DINB0_bypass;
							DOUTBP1 = DINB1_bypass;
						end else if (PIPEB_int == 1'b1) begin
							DOUTBP0_stg1 = DINB0_bypass;
							DOUTBP1_stg1 = DINB1_bypass;
						end
					end
				end

				2'b10 : begin
					MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 ] = DINB0_reg;
					MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 1 ] = DINB1_reg;
					MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 2 ] = DINB2_reg;
					MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 3 ] = DINB3_reg;

					if (WMODEB_int == 1'b1) begin
						if (PIPEB_int == 1'b0) begin
							DOUTBP0 = DINB0_bypass;
							DOUTBP1 = DINB1_bypass;
							DOUTBP2 = DINB2_bypass;
							DOUTBP3 = DINB3_bypass;
						end else if (PIPEB_int == 1'b1) begin
							DOUTBP0_stg1 = DINB0_bypass;
							DOUTBP1_stg1 = DINB1_bypass;
							DOUTBP2_stg1 = DINB2_bypass;
							DOUTBP3_stg1 = DINB3_bypass;
						end
					end
				end
			  
				2'b11 : begin
					MEM_512_9[ ADDRB ] = {DINB8_reg,DINB7_reg,DINB6_reg,DINB5_reg,DINB4_reg,DINB3_reg,DINB2_reg,DINB1_reg,DINB0_reg};
					if (WMODEB_int == 1'b1) begin
						if (PIPEB_int == 1'b0) begin
							DOUTBP0 = DINB0_bypass;
							DOUTBP1 = DINB1_bypass;
							DOUTBP2 = DINB2_bypass;
							DOUTBP3 = DINB3_bypass;
							DOUTBP4 = DINB4_bypass;
							DOUTBP5 = DINB5_bypass;
							DOUTBP6 = DINB6_bypass;
							DOUTBP7 = DINB7_bypass;
							DOUTBP8 = DINB8_bypass;
						end else if (PIPEB_int == 1'b1) begin
							DOUTBP0_stg1 = DINB0_bypass;
							DOUTBP1_stg1 = DINB1_bypass;
							DOUTBP2_stg1 = DINB2_bypass;
							DOUTBP3_stg1 = DINB3_bypass;
							DOUTBP4_stg1 = DINB4_bypass;
							DOUTBP5_stg1 = DINB5_bypass;
							DOUTBP6_stg1 = DINB6_bypass;
							DOUTBP7_stg1 = DINB7_bypass;
							DOUTBP8_stg1 = DINB8_bypass;
						end
					end
				end

				default: begin
					if ( WARNING_MSGS_ON == 1 )
						$display ("Warning: Invalid WIDTH configuration at time %d ns. Legal Width: 1, 2, 4, 9. Instance: %m", $time);
				end
endcase
			

   end else if ( (WENB_int == 1'b1) && ADDRB_VALID ) begin		// read mode
        CLKB_rd_re = $time;

        if (PIPEB_int == 1'b0) begin 	// no pipeline
					case (`BLKB_WIDTH_CFG)
						2'b00 : begin
										DOUTBP0 = MEM_512_9[ ADDRB[11:3] ] [ ADDRB[2:0] ];
										end
						2'b01 : begin
										DOUTBP0 = MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 ];
										DOUTBP1 = MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 + 1 ];
										end
						2'b10 : begin
										DOUTBP0 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 ];
										DOUTBP1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 1 ];
										DOUTBP2 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 2 ];
										DOUTBP3 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 3 ];
										end
						2'b11 : begin
										{DOUTBP8, DOUTBP7, DOUTBP6, DOUTBP5, DOUTBP4,
															DOUTBP3, DOUTBP2, DOUTBP1, DOUTBP0} = MEM_512_9[ ADDRB ];
										end
						default:
							 begin
								if ( WARNING_MSGS_ON == 1 )
									$display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9. Instance: %m", $time);
							 end
					endcase
					// Check for Write from Port A and Read from Port B to the same address, read data on Port B is driven to X
					if ( (WENA_lat == 1'b0) && same_addr(ADDRA, ADDRB, {WIDTHA1,WIDTHA0}, {WIDTHB1,WIDTHB0}) &&
                                                                  ((CLKA_wr_re + TC2CWRH) > CLKB_rd_re) ) begin
						$display (" ** Warning: Port A Write and Port B Read to same address at same time. Port B read data is unpredictable, driving read data to X.");
						$display (" Time: %0.1f ps Instance: %m ", $realtime );
						`DATA_B_OUT = drive_data_x (ADDRA, ADDRB, {WIDTHA1,WIDTHA0}, {WIDTHB1,WIDTHB0}, `DATA_B_OUT);
					end 

        end else if (PIPEB_int == 1'b1) begin
					case (`BLKB_WIDTH_CFG)
						2'b00 : begin
										DOUTBP0_stg1 = MEM_512_9[ ADDRB[11:3] ] [ ADDRB[2:0] ];
										end
						2'b01 : begin
										DOUTBP0_stg1 = MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 ];
										DOUTBP1_stg1 = MEM_512_9[ ADDRB[10:2] ] [ ADDRB[1:0] * 2 + 1 ];
										end
						2'b10 : begin
										DOUTBP0_stg1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 ];
										DOUTBP1_stg1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 1 ];
										DOUTBP2_stg1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 2 ];
										DOUTBP3_stg1 = MEM_512_9[ ADDRB[9:1] ] [ ADDRB[0] * 4 + 3 ];
										end
						2'b11 : begin
										{DOUTBP8_stg1, DOUTBP7_stg1, DOUTBP6_stg1, DOUTBP5_stg1, DOUTBP4_stg1,
																	 DOUTBP3_stg1, DOUTBP2_stg1, DOUTBP1_stg1, DOUTBP0_stg1} = MEM_512_9[ ADDRB ];
										end
						default:
							 begin
								if ( WARNING_MSGS_ON == 1 )
									$display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9. Instance: %m", $time);
							 end
					endcase
          // Check for Write from Port A and Read from Port B to the same address, read data on Port B is driven to X
          if ( (WENA_lat == 1'b0) && same_addr(ADDRA, ADDRB, {WIDTHA1,WIDTHA0}, {WIDTHB1,WIDTHB0}) &&
                                                                  ((CLKA_wr_re + TC2CWRH) > CLKB_rd_re) ) begin
            $display (" ** Warning: Port A Write and Port B Read to same address at same time. Port B read data is unpredictable, driving read data to X.");
            $display (" Time: %0.1f ps Instance: %m ", $realtime );
            `DATAP_B_OUT = drive_data_x (ADDRA, ADDRB, {WIDTHA1,WIDTHA0}, {WIDTHB1,WIDTHB0}, `DATAP_B_OUT);
          end

       end else begin
                   if ( WARNING_MSGS_ON == 1 )
                     $display ("Warning: PIPEB unknown at time %d ns, no data was read. Instance: %m", $time); 
                   DOUTBP0 = 1'bx;
                   DOUTBP1 = 1'bx;
                   DOUTBP2 = 1'bx;
                   DOUTBP3 = 1'bx;
                   DOUTBP4 = 1'bx;
                   DOUTBP5 = 1'bx;
                   DOUTBP6 = 1'bx;
                   DOUTBP7 = 1'bx;
                   DOUTBP8 = 1'bx;
                end
      end else if ( (WENB_int == 1'b0) && (ADDRB_VALID == 0) ) begin
        if ( WARNING_MSGS_ON == 1 )
          $display("Illegal Write Address on port B, Write Not Initiated. Instance: %m");
      end else if ( (WENB_int == 1'b1) && (ADDRB_VALID == 0) ) begin
        if ( WARNING_MSGS_ON == 1 )
          $display("Illegal Read Address on port B, Read Not Initiated. Instance: %m");
      end else begin
        if ( WARNING_MSGS_ON == 1 )
          $display("Warning: WENB is unknown at time %d ns. Instance: %m", $time);
      end
    end
 end

 // function to drive read data bus to "x" depending on width configuration
 // function to check if write and read operations are accessing the same memory location

 function same_addr;
   input integer waddr, raddr;
   input [1:0]   ww, rw;
   integer       wr_addr, rd_addr;
   begin
     same_addr = 1'b0;
     if ( ww > rw ) begin
       rd_addr = raddr >> (  ww - rw );
       wr_addr = waddr;
     end
     else if ( rw > ww )begin
       rd_addr = raddr;
       wr_addr = waddr >> (  rw - ww );
     end
     else begin
       rd_addr = raddr;
       wr_addr = waddr;
     end
     if ( wr_addr == rd_addr ) begin
       same_addr = 1'b1;
     end
   end
 endfunction


 // function to drive read data bus to "x" depending on width configuration
 function [8:0] drive_data_x;
   input integer waddr, raddr;
   input [1:0]   ww, rw;
   input [8:0]   rd_data;
   integer       index, i;
   begin
     drive_data_x = rd_data;
     case(rw)
       2'b00 : begin
                 drive_data_x [ 0 ] = 1'bx;
               end
       2'b01 : begin
                 if ( ww == 2'b00 )
                   drive_data_x [ waddr[0] ] = 1'bx;
                 else
                   drive_data_x [ 1:0 ] = 2'bx;
               end
       2'b10 : begin
                 if ( ww == 2'b00 )
                   drive_data_x [ waddr[1:0] ] = 1'bx;
                 else if ( ww == 2'b01 ) begin
                   index = waddr[0] * 2;
                   for ( i=index; i<index+2; i=i+1 )
                     drive_data_x [ i ] = 1'bx;
                 end else
                   drive_data_x [ 3:0 ] = 4'bx;
               end
       2'b11 : begin
                 if ( ww == 2'b00 )
                   drive_data_x [ waddr[2:0] ] = 1'bx;
                 else if ( ww == 2'b01 ) begin
                   index = waddr[1:0] * 2;
                   for ( i=index; i<index+2; i=i+1 )
                     drive_data_x [ i ] = 1'bx;
                 end else if ( ww == 2'b10 ) begin
                   index = waddr[0] * 4;
                   for ( i=index; i<index+4; i=i+1 )
                     drive_data_x [ i ] = 1'bx;
                 end else
                   drive_data_x [ 8:0 ] = 9'bx;
               end
       default: begin
                  $display ("Warning: invalid WIDTH configuration at time %d ns, Legal Width: 1,2,4,9. Instance: %m", $time);
                end
      endcase
   end

 endfunction

 // function to convert addr vector to integer 

 function integer get_address;
   input [11:0] addr_signal;
   integer      ADDR;
   begin
     // the address calculation is based on  width,  because we assume that
     // users (or actgen) will connect low unused address pin to GND (1'b0), otherwise it may cause problem !
     ADDR =  addr_signal[11]*2048 + addr_signal[10]*1024 + addr_signal[9]*512 + addr_signal[8]*256 +
             addr_signal[7]*128 + addr_signal[6]*64 + addr_signal[5]*32 + addr_signal[4]*16 +
             addr_signal[3]*8 + addr_signal[2]*4 + addr_signal[1]*2 + addr_signal[0]*1;
     get_address = ADDR;
   end
 endfunction


   specify

      specparam   LibName     = "proasic3";
      (posedge CLKA => (DOUTA0+:DOUTA0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKA => (DOUTA1+:DOUTA1) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKA => (DOUTA2+:DOUTA2) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKA => (DOUTA3+:DOUTA3) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKA => (DOUTA4+:DOUTA4) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKA => (DOUTA5+:DOUTA5) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKA => (DOUTA6+:DOUTA6) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKA => (DOUTA7+:DOUTA7) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKA => (DOUTA8+:DOUTA8) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);

      (posedge CLKB => (DOUTB0+:DOUTB0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKB => (DOUTB1+:DOUTB1) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKB => (DOUTB2+:DOUTB2) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKB => (DOUTB3+:DOUTB3) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKB => (DOUTB4+:DOUTB4) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKB => (DOUTB5+:DOUTB5) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKB => (DOUTB6+:DOUTB6) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKB => (DOUTB7+:DOUTB7) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge CLKB => (DOUTB8+:DOUTB8) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);


      (negedge RESET => (DOUTA0+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTA1+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTA2+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTA3+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTA4+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTA5+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTA6+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTA7+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTA8+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);

      (negedge RESET => (DOUTB0+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTB1+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTB2+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTB3+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTB4+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTB5+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTB6+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTB7+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (DOUTB8+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);


      $width(posedge CLKA, 0.0, 0, NOTIFY_REG);
      $width(negedge CLKA, 0.0, 0, NOTIFY_REG);
      $width(posedge CLKB, 0.0, 0, NOTIFY_REG);
      $width(negedge CLKB, 0.0, 0, NOTIFY_REG);

     
      $setup(posedge ADDRA11, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRA11, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, posedge ADDRA11, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, negedge ADDRA11, 0.0, NOTIFY_REG);
      $setup(posedge ADDRA10, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRA10, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, posedge ADDRA10, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, negedge ADDRA10, 0.0, NOTIFY_REG);
      $setup(posedge ADDRA9, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRA9, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, posedge ADDRA9, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, negedge ADDRA9, 0.0, NOTIFY_REG);
      $setup(posedge ADDRA8, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRA8, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, posedge ADDRA8, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, negedge ADDRA8, 0.0, NOTIFY_REG);
      $setup(posedge ADDRA7, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRA7, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, posedge ADDRA7, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, negedge ADDRA7, 0.0, NOTIFY_REG);
      $setup(posedge ADDRA6, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRA6, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, posedge ADDRA6, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, negedge ADDRA6, 0.0, NOTIFY_REG);
      $setup(posedge ADDRA5, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRA5, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, posedge ADDRA5, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, negedge ADDRA5, 0.0, NOTIFY_REG);
      $setup(posedge ADDRA4, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRA4, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, posedge ADDRA4, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, negedge ADDRA4, 0.0, NOTIFY_REG);
      $setup(posedge ADDRA3, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRA3, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, posedge ADDRA3, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, negedge ADDRA3, 0.0, NOTIFY_REG);
      $setup(posedge ADDRA2, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRA2, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, posedge ADDRA2, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, negedge ADDRA2, 0.0, NOTIFY_REG);
      $setup(posedge ADDRA1, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRA1, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, posedge ADDRA1, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, negedge ADDRA1, 0.0, NOTIFY_REG);
      $setup(posedge ADDRA0, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRA0, posedge CLKA &&& BLKA_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, posedge ADDRA0, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_EN, negedge ADDRA0, 0.0, NOTIFY_REG);

      $setup(posedge DINA8, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINA8, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, posedge DINA8, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, negedge DINA8, 0.0, NOTIFY_REG);
      $setup(posedge DINA7, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINA7, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, posedge DINA7, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, negedge DINA7, 0.0, NOTIFY_REG);
      $setup(posedge DINA6, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINA6, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, posedge DINA6, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, negedge DINA6, 0.0, NOTIFY_REG);
      $setup(posedge DINA5, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINA5, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, posedge DINA5, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, negedge DINA5, 0.0, NOTIFY_REG);
      $setup(posedge DINA4, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINA4, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, posedge DINA4, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, negedge DINA4, 0.0, NOTIFY_REG);
      $setup(posedge DINA3, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINA3, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, posedge DINA3, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, negedge DINA3, 0.0, NOTIFY_REG);
      $setup(posedge DINA2, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINA2, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, posedge DINA2, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, negedge DINA2, 0.0, NOTIFY_REG);
      $setup(posedge DINA1, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINA1, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, posedge DINA1, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, negedge DINA1, 0.0, NOTIFY_REG);
      $setup(posedge DINA0, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINA0, posedge CLKA &&& BLKA_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, posedge DINA0, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& BLKA_WEN, negedge DINA0, 0.0, NOTIFY_REG);


      $setup(posedge WENA, posedge CLKA &&& RESET, 0.0, NOTIFY_REG);
      $setup(negedge WENA, posedge CLKA &&& RESET, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& RESET, posedge WENA, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&&RESET, negedge WENA, 0.0, NOTIFY_REG);

      $setup(posedge BLKA, posedge CLKA &&& RESET, 0.0, NOTIFY_REG);
      $setup(negedge BLKA, posedge CLKA &&& RESET, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& RESET, posedge BLKA, 0.0, NOTIFY_REG);
      $hold(posedge CLKA &&& RESET, negedge BLKA, 0.0, NOTIFY_REG);

      $recovery(posedge RESET, posedge CLKA, 0.0, NOTIFY_REG);
      $hold(posedge CLKA,posedge RESET, 0.0, NOTIFY_REG);
      
      $recovery(posedge RESET, posedge CLKB, 0.0, NOTIFY_REG);
      $hold(posedge CLKB,posedge RESET, 0.0, NOTIFY_REG);

      $width(negedge RESET, 0.0, 0, NOTIFY_REG);


      $setup(posedge ADDRB11, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRB11, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, posedge ADDRB11, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, negedge ADDRB11, 0.0, NOTIFY_REG);
      $setup(posedge ADDRB10, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRB10, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, posedge ADDRB10, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, negedge ADDRB10, 0.0, NOTIFY_REG);
      $setup(posedge ADDRB9, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRB9, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, posedge ADDRB9, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, negedge ADDRB9, 0.0, NOTIFY_REG);
      $setup(posedge ADDRB8, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRB8, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, posedge ADDRB8, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, negedge ADDRB8, 0.0, NOTIFY_REG);
      $setup(posedge ADDRB7, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRB7, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, posedge ADDRB7, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, negedge ADDRB7, 0.0, NOTIFY_REG);
      $setup(posedge ADDRB6, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRB6, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, posedge ADDRB6, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, negedge ADDRB6, 0.0, NOTIFY_REG);
      $setup(posedge ADDRB5, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRB5, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, posedge ADDRB5, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, negedge ADDRB5, 0.0, NOTIFY_REG);
      $setup(posedge ADDRB4, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRB4, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, posedge ADDRB4, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, negedge ADDRB4, 0.0, NOTIFY_REG);
      $setup(posedge ADDRB3, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRB3, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, posedge ADDRB3, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, negedge ADDRB3, 0.0, NOTIFY_REG);
      $setup(posedge ADDRB2, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRB2, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, posedge ADDRB2, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, negedge ADDRB2, 0.0, NOTIFY_REG);
      $setup(posedge ADDRB1, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRB1, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, posedge ADDRB1, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, negedge ADDRB1, 0.0, NOTIFY_REG);
      $setup(posedge ADDRB0, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $setup(negedge ADDRB0, posedge CLKB &&& BLKB_EN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, posedge ADDRB0, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_EN, negedge ADDRB0, 0.0, NOTIFY_REG);

      $setup(posedge DINB8, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINB8, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, posedge DINB8, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, negedge DINB8, 0.0, NOTIFY_REG);
      $setup(posedge DINB7, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINB7, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, posedge DINB7, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, negedge DINB7, 0.0, NOTIFY_REG);
      $setup(posedge DINB6, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINB6, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, posedge DINB6, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, negedge DINB6, 0.0, NOTIFY_REG);
      $setup(posedge DINB5, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINB5, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, posedge DINB5, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, negedge DINB5, 0.0, NOTIFY_REG);
      $setup(posedge DINB4, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINB4, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, posedge DINB4, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, negedge DINB4, 0.0, NOTIFY_REG);
      $setup(posedge DINB3, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINB3, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, posedge DINB3, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, negedge DINB3, 0.0, NOTIFY_REG);
      $setup(posedge DINB2, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINB2, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, posedge DINB2, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, negedge DINB2, 0.0, NOTIFY_REG);
      $setup(posedge DINB1, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINB1, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, posedge DINB1, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, negedge DINB1, 0.0, NOTIFY_REG);
      $setup(posedge DINB0, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $setup(negedge DINB0, posedge CLKB &&& BLKB_WEN, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, posedge DINB0, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& BLKB_WEN, negedge DINB0, 0.0, NOTIFY_REG);


      $setup(posedge WENB, posedge CLKB &&& RESET, 0.0, NOTIFY_REG);
      $setup(negedge WENB, posedge CLKB &&& RESET, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& RESET, posedge WENB, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& RESET, negedge WENB, 0.0, NOTIFY_REG);

      $setup(posedge BLKB, posedge CLKB &&& RESET, 0.0, NOTIFY_REG);
      $setup(negedge BLKB, posedge CLKB &&& RESET, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& RESET, posedge BLKB, 0.0, NOTIFY_REG);
      $hold(posedge CLKB &&& RESET, negedge BLKB, 0.0, NOTIFY_REG);

   endspecify
 endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*-----------------------------------------------------------------
 CELL NAME : RAM512X18
-----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ps/1 ps

module RAM512X18(RADDR8,RADDR7,RADDR6,RADDR5,RADDR4,RADDR3,RADDR2,RADDR1,RADDR0,
                 WADDR8,WADDR7,WADDR6,WADDR5,WADDR4,WADDR3,WADDR2,WADDR1,WADDR0,
                 RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,
                 RD3,RD2,RD1,RD0,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,
                 WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0,RW1,WW1,RW0,WW0,REN,RCLK,WEN,WCLK,RESET,PIPE); 

parameter DELAY_TWO = 2;
parameter TC2CWRH = 587;
parameter TC2CRWH = 503;

input RADDR8,RADDR7,RADDR6,RADDR5,RADDR4,RADDR3,RADDR2,RADDR1,RADDR0;
input WADDR8,WADDR7,WADDR6,WADDR5,WADDR4,WADDR3,WADDR2,WADDR1,WADDR0;
input WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0;
input RW1,WW1,RW0, WW0,REN,RCLK,WEN,WCLK,RESET,PIPE;

output RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0;

reg RDP17,RDP16,RDP15,RDP14,RDP13,RDP12,RDP11,RDP10,RDP9,RDP8,RDP7,RDP6,RDP5,RDP4,RDP3,RDP2,RDP1,RDP0;
reg RDP17_stg,RDP16_stg,RDP15_stg,RDP14_stg,RDP13_stg,RDP12_stg,RDP11_stg,RDP10_stg,RDP9_stg;
reg RDP8_stg,RDP7_stg,RDP6_stg,RDP5_stg,RDP4_stg,RDP3_stg,RDP2_stg,RDP1_stg,RDP0_stg;

wire RADDR8_int,RADDR7_int,RADDR6_int,RADDR5_int,RADDR4_int,RADDR3_int,RADDR2_int,RADDR1_int,RADDR0_int;
wire WADDR8_int,WADDR7_int,WADDR6_int,WADDR5_int,WADDR4_int,WADDR3_int,WADDR2_int,WADDR1_int,WADDR0_int;
wire WD17_int,WD16_int,WD15_int,WD14_int,WD13_int,WD12_int,WD11_int,WD10_int,WD9_int,WD8_int;
wire WD7_int,WD6_int,WD5_int,WD4_int,WD3_int,WD2_int,WD1_int,WD0_int;
wire REN_int,RCLK_int,WEN_int,WCLK_int,RESET_int,PIPE_int;

wire RENABLE;
wire WENABLE;

time WCLK_re;
time RCLK_re;

reg [8:0] MEM_512_9 [0:511];

reg NOTIFY_REG;

integer RADDR;           
integer WADDR;           
integer DEPTH;
integer MAXADD;

reg RADDR_VALID;
reg WADDR_VALID;

reg WEN_lat, REN_lat;

`define WADDR_BUS {WADDR8_int,WADDR7_int,WADDR6_int,WADDR5_int,WADDR4_int,WADDR3_int,WADDR2_int,WADDR1_int,WADDR0_int}
`define RADDR_BUS {RADDR8_int,RADDR7_int,RADDR6_int,RADDR5_int,RADDR4_int,RADDR3_int,RADDR2_int,RADDR1_int,RADDR0_int}
`define DATA_WIDTH_18 {RDP17,RDP16,RDP15,RDP14,RDP13,RDP12,RDP11,RDP10,RDP9,RDP8,RDP7,RDP6,RDP5,RDP4,RDP3,RDP2,RDP1,RDP0}
`define DATAP_WIDTH_18 {RDP17_stg,RDP16_stg,RDP15_stg,RDP14_stg,RDP13_stg,RDP12_stg,RDP11_stg,RDP10_stg,RDP9_stg,RDP8_stg,                                     RDP7_stg,RDP6_stg,RDP5_stg,RDP4_stg,RDP3_stg,RDP2_stg,RDP1_stg,RDP0_stg}
                            

assign RENABLE = ~REN_int & RESET_int;
assign WENABLE = ~WEN_int & RESET_int;

buf b0(WCLK_int, WCLK);
buf b1(RCLK_int, RCLK);
buf b2(WEN_int,WEN);
buf b3(REN_int,REN);
buf b4(RESET_int, RESET);

buf b5(RADDR8_int, RADDR8);
buf b6(RADDR7_int, RADDR7);
buf b7(RADDR6_int, RADDR6);
buf b8(RADDR5_int, RADDR5);
buf b9(RADDR4_int, RADDR4);
buf b10(RADDR3_int, RADDR3);
buf b11(RADDR2_int, RADDR2);
buf b12(RADDR1_int, RADDR1);
buf b13(RADDR0_int, RADDR0);

buf b14(WADDR8_int, WADDR8);
buf b15(WADDR7_int, WADDR7);
buf b16(WADDR6_int, WADDR6);
buf b17(WADDR5_int, WADDR5);
buf b18(WADDR4_int, WADDR4);
buf b19(WADDR3_int, WADDR3);
buf b20(WADDR2_int, WADDR2);
buf b21(WADDR1_int, WADDR1);
buf b22(WADDR0_int, WADDR0);

buf b23(WD17_int, WD17);
buf b24(WD16_int, WD16);
buf b25(WD15_int, WD15);
buf b26(WD14_int, WD14);
buf b27(WD13_int, WD13);
buf b28(WD12_int, WD12);
buf b29(WD11_int, WD11);
buf b30(WD10_int, WD10);
buf b31(WD9_int, WD9);
buf b32(WD8_int, WD8);
buf b33(WD7_int, WD7);
buf b34(WD6_int, WD6);
buf b35(WD5_int, WD5);
buf b36(WD4_int, WD4);
buf b37(WD3_int, WD3);
buf b38(WD2_int, WD2);
buf b39(WD1_int, WD1);
buf b40(WD0_int, WD0);
buf b41(PIPE_int,PIPE);

pmos inst0(RD17, RDP17, 0);
pmos inst1(RD16, RDP16, 0);
pmos inst2(RD15, RDP15, 0);
pmos inst3(RD14, RDP14, 0);
pmos inst4(RD13, RDP13, 0);
pmos inst5(RD12, RDP12, 0);
pmos inst6(RD11, RDP11, 0);
pmos inst7(RD10, RDP10, 0);
pmos inst8(RD9, RDP9, 0);
pmos inst9(RD8, RDP8, 0);
pmos inst10(RD7, RDP7, 0);
pmos inst11(RD6, RDP6, 0);
pmos inst12(RD5, RDP5, 0);
pmos inst13(RD4, RDP4, 0);
pmos inst14(RD3, RDP3, 0);
pmos inst15(RD2, RDP2, 0);
pmos inst16(RD1, RDP1, 0);
pmos inst17(RD0, RDP0, 0);

parameter MEMORYFILE = "";
parameter WARNING_MSGS_ON = 1; // Used to turn off warnings about read &
                               // write to same address at same time.
                               // Default = on.  Set to 0 to turn them off.

  initial
    begin
    
      if ( WARNING_MSGS_ON == 0 )
        $display ( "Note: RAM512X18 warnings disabled. Set WARNING_MSGS_ON = 1 to enable." );

      if ( MEMORYFILE != "")
        $readmemb ( MEMORYFILE, MEM_512_9 );
      else
        begin
          //if ( WARNING_MSGS_ON == 1 )
            //$display ( "Note: Module %m, memory initialization file parameter MEMORYFILE not defined" );
        end
    end

always @(WCLK_int === 1'bx )
begin
  if ($time > 0) begin
    if (WEN_int == 1'b0) begin
      if ( WARNING_MSGS_ON == 1 )
        $display("Warning : WCLK went unknown at time %0.1f. Instance: %m\n",$realtime);
    end
  end
end

always @(RCLK_int === 1'bx )
begin
  if ($time > 0) begin
    if (REN_int == 1'b0) begin
      if ( WARNING_MSGS_ON == 1 )
        $display("Warning : RCLK went unknown at time %0.1f. Instance: %m\n",$realtime);
    end
  end
end

  always @(RESET_int )
      begin
	  if(RESET_int === 1'b0 )
	      begin
		  
		  case({RW1,RW0})
		     2'b01 : begin
			 RDP0 = 1'b0;
			 RDP1 = 1'b0;
			 RDP2 = 1'b0;
			 RDP3 = 1'b0;
			 RDP4 = 1'b0;
			 RDP5 = 1'b0;
			 RDP6 = 1'b0;
			 RDP7 = 1'b0;
			 RDP8 = 1'b0;
			 if (PIPE_int == 1'b1) begin
			     RDP0_stg = 1'b0;
			     RDP1_stg = 1'b0;
			     RDP2_stg = 1'b0;
			     RDP3_stg = 1'b0;
			     RDP4_stg = 1'b0;
			     RDP5_stg = 1'b0;
			     RDP6_stg = 1'b0;
			     RDP7_stg = 1'b0;
			     RDP8_stg = 1'b0;
			 end
		     end
		     2'b10 : begin
			 RDP0 = 1'b0;
			 RDP1 = 1'b0;
			 RDP2 = 1'b0;
			 RDP3 = 1'b0;
			 RDP4 = 1'b0;
			 RDP5 = 1'b0;
			 RDP6 = 1'b0;
			 RDP7 = 1'b0;
			 RDP8 = 1'b0;
			 RDP9 = 1'b0;
			 RDP10 = 1'b0;
			 RDP11 = 1'b0;
			 RDP12 = 1'b0;
			 RDP13 = 1'b0;
			 RDP14 = 1'b0;
			 RDP15 = 1'b0;
			 RDP16 = 1'b0;
			 RDP17 = 1'b0;
			 if (PIPE_int == 1'b1) begin
			     RDP0_stg = 1'b0;
			     RDP1_stg = 1'b0;
			     RDP2_stg = 1'b0;
			     RDP3_stg = 1'b0;
			     RDP4_stg = 1'b0;
			     RDP5_stg = 1'b0;
			     RDP6_stg = 1'b0;
			     RDP7_stg = 1'b0;
			     RDP8_stg = 1'b0;
			     RDP9_stg = 1'b0;
			     RDP10_stg = 1'b0;
			     RDP11_stg = 1'b0;
			     RDP12_stg = 1'b0;
			     RDP13_stg = 1'b0;
			     RDP14_stg = 1'b0;
			     RDP15_stg = 1'b0;
			     RDP16_stg = 1'b0;
			     RDP17_stg = 1'b0;
			 end
		     end
		     default : begin
			 //if ( WARNING_MSGS_ON == 1 )
			 //  $display ("Warning: RW at time %d ns.", $time);
		     end
		  endcase
	      end
      end // Reset

always @(posedge WCLK_int) begin

  WEN_lat = WEN_int;

  if ((WEN_int == 1'b0) && (RESET_int == 1'b1))  begin

    WCLK_re     = $time;
    WADDR       = get_address(`WADDR_BUS); // call address calculation function to get write address
    WADDR_VALID = 1;

    if ((^WADDR) === 1'bx) begin
      WADDR_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display(" Warning: Illegal address on write port at time %0.1f! Instance: %m", $realtime);
    end
    else if (({WW1,WW0} == 2'b01) && (WADDR > 511)) begin
      WADDR_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display(" Warning: Illegal address on write port at time %0.1f! Instance: %m", $realtime);
    end
    else if (({WW1,WW0} == 2'b10) && (WADDR > 255)) begin
      WADDR_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display(" Warning: Illegal address on write port at time %0.1f! Instance: %m", $realtime);
    end

    if (WADDR_VALID) begin

      // Check for Write and Read to the same address, write is not affected
      if ( (REN_lat == 1'b0) && same_addr(WADDR, RADDR, {WW1,WW0}, {RW1,RW0} ) &&
                                                 ((RCLK_re + TC2CRWH) > WCLK_re) ) begin
        $display (" ** Warning: Read and Write to same address at same time.  RD is unpredictable, driving RD to X ");
        $display (" Time: %0.1f Instance: %m ", $realtime );

        if (PIPE_int == 1'b1)
          `DATAP_WIDTH_18 = drive_rd_x (WADDR, RADDR, {WW1,WW0}, {RW1,RW0}, `DATAP_WIDTH_18);
        else if (PIPE_int == 1'b0)
          `DATA_WIDTH_18 = drive_rd_x (WADDR, RADDR, {WW1,WW0}, {RW1,RW0}, `DATA_WIDTH_18);
      end

      case ({WW1,WW0})
            2'b01 : begin
                    MEM_512_9 [ WADDR ] = {WD8_int, WD7_int, WD6_int, WD5_int, WD4_int, WD3_int, WD2_int, WD1_int, WD0_int};
                    end
            2'b10 : begin
                    MEM_512_9 [ WADDR * 2 ] = {WD8_int,WD7_int,WD6_int,WD5_int,WD4_int,WD3_int,WD2_int,WD1_int,WD0_int};
                    MEM_512_9 [ WADDR * 2 + 1 ] = {WD17_int,WD16_int,WD15_int,WD14_int,WD13_int,WD12_int,WD11_int,WD10_int,WD9_int};
                    end
          default : begin
                      if ( WARNING_MSGS_ON == 1 )
                        $display("Warning: WW value unknown at time %d. Instance: %m",$time);
                    end
      endcase
    end
    else begin
      if ( WARNING_MSGS_ON == 1 )
        $display("Warning: Illegal Write Address, Write Not Initiated. Instance: %m");
    end
  end else if (WEN_int == 1'bx) begin
    if ( WARNING_MSGS_ON == 1 )
      $display ("Warning: WEN went unknown at time %d ns. Instance: %m", $time);
  end 
end


always @(posedge RCLK_int) begin

    REN_lat = REN_int;

    if (PIPE_int == 1'b1) begin
     case({RW1,RW0})
       2'b01 : begin
                RDP0 = RDP0_stg;
                RDP1 = RDP1_stg;
                RDP2 = RDP2_stg;
                RDP3 = RDP3_stg;
                RDP4 = RDP4_stg;
                RDP5 = RDP5_stg;
                RDP6 = RDP6_stg;
                RDP7 = RDP7_stg;
                RDP8 = RDP8_stg;
               end
       2'b10 : begin
                RDP0 = RDP0_stg;
                RDP1 = RDP1_stg;
                RDP2 = RDP2_stg;
                RDP3 = RDP3_stg;
                RDP4 = RDP4_stg;
                RDP5 = RDP5_stg;
                RDP6 = RDP6_stg;
                RDP7 = RDP7_stg;
                RDP8 = RDP8_stg;
                RDP9 = RDP9_stg;
                RDP10 = RDP10_stg;
                RDP11 = RDP11_stg;
                RDP12 = RDP12_stg;
                RDP13 = RDP13_stg;
                RDP14 = RDP14_stg;
                RDP15 = RDP15_stg;
                RDP16 = RDP16_stg;
                RDP17 = RDP17_stg;
              end
       default : begin
                  if ( WARNING_MSGS_ON == 1 )
                    $display ("Warning: RW unknown at time %d ns. Instance: %m", $time);
                 end
     endcase
    end 
    else if (PIPE_int == 1'bx) begin
      if ( WARNING_MSGS_ON == 1 )
        $display ("Warning: PIPE unknown at time %d ns, no data was read. Instance: %m", $time);
      RDP0 = 1'bx;
      RDP1 = 1'bx;
      RDP2 = 1'bx;
      RDP3 = 1'bx;
      RDP4 = 1'bx;
      RDP5 = 1'bx;
      RDP6 = 1'bx;
      RDP7 = 1'bx;
      RDP8 = 1'bx;
      RDP9 = 1'bx;
      RDP10 = 1'bx;
      RDP11 = 1'bx;
      RDP12 = 1'bx;
      RDP13 = 1'bx;
      RDP14 = 1'bx;
      RDP15 = 1'bx;
      RDP16 = 1'bx;
      RDP17 = 1'bx;
    end


  if ((REN_int == 1'b0 ) && (RESET_int == 1'b1)) begin

    RCLK_re     = $time;
    RADDR       = get_address(`RADDR_BUS);
    RADDR_VALID = 1;
    
    if ((^RADDR) === 1'bx) begin
      RADDR_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display("Warning: Illegal address on read port at time %0.1f! Instance: %m", $realtime);
    end
    else if (({RW1,RW0} == 2'b01) && (RADDR > 511)) begin
      RADDR_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display("Warning: Illegal address on read port at time %0.1f! Instance: %m", $realtime);
    end
    else if (({RW1,RW0} == 2'b10) && (RADDR > 255)) begin
      RADDR_VALID = 0;
      if ( WARNING_MSGS_ON == 1 )
        $display("Warning: Illegal address on read port at time %0.1f! Instance: %m", $realtime);
    end

    if (RADDR_VALID) begin

      if (PIPE_int == 1'b0) begin
        case({RW1,RW0})
          2'b01 : begin
                  {RDP8, RDP7, RDP6, RDP5, RDP4, RDP3, RDP2, RDP1, RDP0} = MEM_512_9 [ RADDR ];
                end
          2'b10 : begin
                    {RDP8, RDP7, RDP6, RDP5, RDP4, RDP3, RDP2, RDP1, RDP0} = MEM_512_9 [ RADDR * 2 ];
                    {RDP17, RDP16, RDP15, RDP14, RDP13, RDP12, RDP11, RDP10, RDP9} = MEM_512_9 [ RADDR * 2 + 1 ];
                  end
        default : begin
                    if ( WARNING_MSGS_ON == 1 )
                      $display ("Warning: RW at time %d ns. Instance: %m", $time);
                  end
        endcase

        // Check for Write and Read to the same address
        if ( (WEN_lat == 1'b0) && same_addr(WADDR, RADDR, {WW1,WW0}, {RW1,RW0}) &&
                            ((WCLK_re + TC2CWRH) > RCLK_re)) begin
          $display (" ** Warning: Write and Read to same address at same time.  RD is unpredictable, driving RD to X");
          $display (" Time: %0.1f Instance: %m ", $realtime );
          `DATA_WIDTH_18 = drive_rd_x (WADDR, RADDR, {WW1,WW0}, {RW1,RW0}, `DATA_WIDTH_18);
        end

      end else if (PIPE_int == 1'b1) begin
        case({RW1,RW0})
          2'b01 : begin
                    {RDP8_stg,RDP7_stg,RDP6_stg,RDP5_stg,RDP4_stg,RDP3_stg,RDP2_stg,RDP1_stg,RDP0_stg} = MEM_512_9 [ RADDR ];
                  end
          2'b10 : begin
                    {RDP8_stg,RDP7_stg,RDP6_stg,RDP5_stg,RDP4_stg,RDP3_stg,RDP2_stg,RDP1_stg,RDP0_stg} = MEM_512_9 [ RADDR * 2 ];
                    {RDP17_stg,RDP16_stg,RDP15_stg,RDP14_stg,RDP13_stg,RDP12_stg,RDP11_stg,RDP10_stg,RDP9_stg} = MEM_512_9 [ RADDR * 2 + 1 ];
                  end
          default : begin
                      if ( WARNING_MSGS_ON == 1 )
                        $display ("Warning: RW unknown at time %d ns. Instance: %m", $time);
                    end
        endcase 

        // Check for Write and Read to the same address
        if ( (WEN_lat == 1'b0) && same_addr(WADDR, RADDR, {WW1,WW0}, {RW1,RW0}) &&
                            ((WCLK_re + TC2CWRH) > RCLK_re)) begin
          $display (" ** Warning: Write and Read to same address at same time.  RD is unpredictable, driving RD to X");
          $display (" Time: %0.1f Instance: %m ", $realtime );
          `DATAP_WIDTH_18 = drive_rd_x (WADDR, RADDR, {WW1,WW0}, {RW1,RW0}, `DATAP_WIDTH_18);
        end

      end else begin
                if ( WARNING_MSGS_ON == 1 )
                  $display ("Warning: PIPE unknown at time %d ns, no data was read. Instance: %m", $time);
                RDP0 = 1'bx;
                RDP1 = 1'bx;
                RDP2 = 1'bx;
                RDP3 = 1'bx;
                RDP4 = 1'bx;
                RDP5 = 1'bx;
                RDP6 = 1'bx;
                RDP7 = 1'bx;
                RDP8 = 1'bx;
                RDP9 = 1'bx;
                RDP10 = 1'bx;
                RDP11 = 1'bx;
                RDP12 = 1'bx;
                RDP13 = 1'bx;
                RDP14 = 1'bx;
                RDP15 = 1'bx;
                RDP16 = 1'bx;
                RDP17 = 1'bx;
              end
    end else begin
      if ( WARNING_MSGS_ON == 1 )
        $display("Warning: Illegal Read Address, Read Not Initiated. Instance: %m");
    end

  end else if (REN_int == 1'bx) begin
    if ( WARNING_MSGS_ON == 1 )
      $display ("Warning: REN went unknown at time %d ns. Instance: %m", $time);
  end 

 end

 // function to check if write and read operations are accessing the same memory location

 function same_addr;
   input integer waddr, raddr;
   input [1:0]   ww, rw;
   integer wr_addr, rd_addr;
   begin
     same_addr = 1'b0;
     if ( ww > rw ) begin
       rd_addr = raddr >> (  ww - rw );
       wr_addr = waddr;
     end
     else if ( rw > ww )begin
       rd_addr = raddr;
       wr_addr = waddr >> (  rw - ww );
     end
     else begin
       rd_addr = raddr;
       wr_addr = waddr;
     end
     if ( wr_addr == rd_addr ) begin
       same_addr = 1'b1;
     end
   end
 endfunction


 // function to check if write and read operations are accessing the same memory location
 // function to drive read data bus to "x" depending on width configuration

 function [17:0] drive_rd_x;
   input integer waddr, raddr;
   input [1:0]   ww, rw;
   input [17:0]  rd_data;
   integer       index, i;
   begin
     drive_rd_x = rd_data;
     case(rw)
       2'b01 : begin
                 drive_rd_x [ 8:0 ] =  9'bx;
               end
       2'b10 : begin
                 if ( ww == 2'b01 ) begin
                   index = waddr[0] * 9;
                   for ( i=index; i<index+9; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else
                   drive_rd_x [ 17:0 ] =  18'bx;
               end
       default: begin
                  $display("Warning : Invalid READ WIDTH at time %d ns,Legal Width: 9,18. Instance: %m",$time);
                end
      endcase
   end
 
 endfunction

 
 function integer get_address;
  input [8:0] addr_signal;
  integer ADDR;
   begin
    // the address calculation is based on  width,  because we assume that
    // users (or actgen) will connect upper unused address pin to GND (1'b0), otherwise it may cause problem !
          ADDR =  addr_signal[8]*256 + addr_signal[7]*128 + addr_signal[6]*64 + addr_signal[5]*32
                + addr_signal[4]*16 + addr_signal[3]*8 + addr_signal[2]*4 + addr_signal[1]*2 + addr_signal[0]*1;
  get_address =ADDR;
  end
 endfunction


   specify

      specparam   LibName     = "proasic3";
      (posedge RCLK => (RD0+:RD0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD1+:RD1) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD2+:RD2) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD3+:RD3) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD4+:RD4) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD5+:RD5) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD6+:RD6) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD7+:RD7) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD8+:RD8) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD9+:RD9) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD10+:RD10) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD11+:RD11) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD12+:RD12) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD13+:RD13) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD14+:RD14) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD15+:RD15) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD16+:RD16) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (posedge RCLK => (RD17+:RD17) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);

      (negedge RESET => (RD0+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD1+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD2+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD3+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD4+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD5+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD6+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD7+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD8+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD9+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD10+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD11+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD12+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD13+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD14+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD15+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD16+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);
      (negedge RESET => (RD17+:1'b0) ) = (1.0:1.0:1.0, 1.0:1.0:1.0);

 
      $setup(posedge RADDR8, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG);
      $setup(negedge RADDR8, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RENABLE, posedge RADDR8, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RENABLE, negedge RADDR8, 0.0, NOTIFY_REG);
      $setup(posedge RADDR7, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge RADDR7, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, posedge RADDR7, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, negedge RADDR7, 0.0, NOTIFY_REG); 
      $setup(posedge RADDR6, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge RADDR6, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, posedge RADDR6, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, negedge RADDR6, 0.0, NOTIFY_REG); 
      $setup(posedge RADDR5, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge RADDR5, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, posedge RADDR5, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, negedge RADDR5, 0.0, NOTIFY_REG); 
      $setup(posedge RADDR4, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge RADDR4, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, posedge RADDR4, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, negedge RADDR4, 0.0, NOTIFY_REG); 
      $setup(posedge RADDR3, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge RADDR3, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, posedge RADDR3, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, negedge RADDR3, 0.0, NOTIFY_REG); 
      $setup(posedge RADDR2, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge RADDR2, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, posedge RADDR2, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, negedge RADDR2, 0.0, NOTIFY_REG); 
      $setup(posedge RADDR1, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge RADDR1, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, posedge RADDR1, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, negedge RADDR1, 0.0, NOTIFY_REG); 
      $setup(posedge RADDR0, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge RADDR0, posedge RCLK &&& RENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, posedge RADDR0, 0.0, NOTIFY_REG); 
      $hold(posedge RCLK &&& RENABLE, negedge RADDR0, 0.0, NOTIFY_REG);

      $setup(posedge REN, posedge RCLK, 0.0, NOTIFY_REG);
      $setup(negedge REN, posedge RCLK, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, posedge REN, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, negedge REN, 0.0, NOTIFY_REG);
 

      $setup(posedge WADDR8, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WADDR8, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WADDR8, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WADDR8, 0.0, NOTIFY_REG); 
      $setup(posedge WADDR7, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WADDR7, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WADDR7, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WADDR7, 0.0, NOTIFY_REG); 
      $setup(posedge WADDR6, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WADDR6, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WADDR6, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WADDR6, 0.0, NOTIFY_REG); 
      $setup(posedge WADDR5, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WADDR5, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WADDR5, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WADDR5, 0.0, NOTIFY_REG); 
      $setup(posedge WADDR4, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WADDR4, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WADDR4, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WADDR4, 0.0, NOTIFY_REG); 
      $setup(posedge WADDR3, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WADDR3, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WADDR3, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WADDR3, 0.0, NOTIFY_REG); 
      $setup(posedge WADDR2, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WADDR2, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WADDR2, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WADDR2, 0.0, NOTIFY_REG); 
      $setup(posedge WADDR1, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WADDR1, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WADDR1, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WADDR1, 0.0, NOTIFY_REG); 
      $setup(posedge WADDR0, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WADDR0, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WADDR0, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WADDR0, 0.0, NOTIFY_REG); 

      $setup(posedge WD17, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD17, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD17, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD17, 0.0, NOTIFY_REG); 
      $setup(posedge WD16, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD16, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD16, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD16, 0.0, NOTIFY_REG); 
      $setup(posedge WD15, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD15, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD15, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD15, 0.0, NOTIFY_REG); 
      $setup(posedge WD14, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD14, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD14, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD14, 0.0, NOTIFY_REG); 
      $setup(posedge WD13, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD13, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD13, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD13, 0.0, NOTIFY_REG); 
      $setup(posedge WD12, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD12, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD12, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD12, 0.0, NOTIFY_REG); 
      $setup(posedge WD11, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD11, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD11, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD11, 0.0, NOTIFY_REG); 
      $setup(posedge WD10, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD10, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD10, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD10, 0.0, NOTIFY_REG); 
      $setup(posedge WD9, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD9, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD9, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD9, 0.0, NOTIFY_REG);

      $setup(posedge WD8, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD8, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD8, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD8, 0.0, NOTIFY_REG); 
      $setup(posedge WD7, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD7, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD7, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD7, 0.0, NOTIFY_REG); 
      $setup(posedge WD6, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD6, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD6, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD6, 0.0, NOTIFY_REG); 
      $setup(posedge WD5, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD5, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD5, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD5, 0.0, NOTIFY_REG); 
      $setup(posedge WD4, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD4, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD4, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD4, 0.0, NOTIFY_REG); 
      $setup(posedge WD3, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD3, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD3, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD3, 0.0, NOTIFY_REG); 
      $setup(posedge WD2, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD2, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD2, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD2, 0.0, NOTIFY_REG); 
      $setup(posedge WD1, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD1, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD1, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD1, 0.0, NOTIFY_REG); 
      $setup(posedge WD0, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $setup(negedge WD0, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, posedge WD0, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK &&& WENABLE, negedge WD0, 0.0, NOTIFY_REG);

      $setup(posedge WEN, posedge WCLK, 0.0, NOTIFY_REG); 
      $setup(negedge WEN, posedge WCLK, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK, posedge WEN, 0.0, NOTIFY_REG); 
      $hold(posedge WCLK, negedge WEN, 0.0, NOTIFY_REG); 
 
      $recovery(posedge RESET, posedge RCLK, 0.0, NOTIFY_REG);
      $hold(posedge RCLK,posedge RESET, 0.0, NOTIFY_REG);

      $recovery(posedge RESET, posedge WCLK, 0.0, NOTIFY_REG);
      $hold(posedge WCLK,posedge RESET, 0.0, NOTIFY_REG);

      $width(negedge RESET, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK, 0.0, 0, NOTIFY_REG);
      $width(posedge WCLK, 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK, 0.0, 0, NOTIFY_REG);
 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : FIFO4K18
 CELL TYPE : FIFO
-----------------------------------------------------------------*/


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 10 ps

module FIFO4K18 (AEVAL11, AEVAL10, AEVAL9, AEVAL8, AEVAL7, AEVAL6, 
                 AEVAL5, AEVAL4, AEVAL3, AEVAL2, AEVAL1, AEVAL0, 
                 AFVAL11, AFVAL10, AFVAL9, AFVAL8, AFVAL7, AFVAL6, 
                 AFVAL5, AFVAL4, AFVAL3, AFVAL2, AFVAL1, AFVAL0, 
                 REN, RBLK, RCLK, RESET, RPIPE, WEN, WBLK, WCLK,
                 RW2, RW1, RW0, WW2, WW1, WW0, ESTOP, FSTOP,
                 WD17, WD16, WD15, WD14, WD13, WD12, WD11, WD10, 
                 WD9, WD8, WD7, WD6, WD5, WD4, WD3, WD2, WD1, WD0, 
                 RD17, RD16, RD15, RD14, RD13, RD12, RD11, RD10, 
                 RD9, RD8, RD7, RD6, RD5, RD4, RD3, RD2, RD1, RD0, 
                 FULL, AFULL, EMPTY, AEMPTY
                );

input AEVAL11, AEVAL10, AEVAL9, AEVAL8, AEVAL7, AEVAL6;
input AEVAL5, AEVAL4, AEVAL3, AEVAL2, AEVAL1, AEVAL0;
input AFVAL11, AFVAL10, AFVAL9, AFVAL8, AFVAL7, AFVAL6;
input AFVAL5, AFVAL4, AFVAL3, AFVAL2, AFVAL1, AFVAL0;
input REN, RBLK, RCLK, RESET, RPIPE, WEN, WBLK, WCLK;
input RW2, RW1, RW0, WW2, WW1, WW0, ESTOP, FSTOP;
input WD17, WD16, WD15, WD14, WD13, WD12, WD11, WD10;
input WD9, WD8, WD7, WD6, WD5, WD4, WD3, WD2, WD1, WD0;

output RD17, RD16, RD15, RD14, RD13, RD12, RD11, RD10;
output RD9, RD8, RD7, RD6, RD5, RD4, RD3, RD2, RD1, RD0;
output FULL, AFULL, EMPTY, AEMPTY;

reg FULLP, AFULLP, EMPTYP, AEMPTYP;
reg [18:0] FIFO[0:512];
reg NOTIFY_REG;

wire AEVAL11_int, AEVAL10_int, AEVAL9_int, AEVAL8_int, AEVAL7_int;
wire AEVAL6_int, AEVAL5_int, AEVAL4_int, AEVAL3_int, AEVAL2_int;
wire AEVAL1_int, AEVAL0_int;
wire AFVAL11, AFVAL10_int, AFVAL9_int, AFVAL8_int, AFVAL7_int;
wire AFVAL6_int, AFVAL5_int, AFVAL4_int, AFVAL3_int, AFVAL2_int;
wire AFVAL1_int, AFVAL0_int;
wire REN_int, RBLK_int, RCLK_int, RESET_int, RPIPE_int;
wire WEN_int, WBLK_int, WCLK_int;
wire RW2_int, RW1_int, RW0_int;
wire WW2_int, WW1_int, WW0_int;
wire ESTOP_int, FSTOP_int;  
wire WD17_int, WD16_int, WD15_int, WD14_int, WD13_int, WD12_int;
wire WD11_int, WD10_int, WD9_int, WD8_int, WD7_int, WD6_int;
wire WD5_int, WD4_int, WD3_int, WD2_int, WD1_int, WD0_int;

reg RDP17, RDP16, RDP15, RDP14, RDP13, RDP12, RDP11, RDP10, RDP9;
reg RDP8, RDP7, RDP6, RDP5, RDP4, RDP3, RDP2, RDP1, RDP0;

reg RD17_stg, RD16_stg, RD15_stg, RD14_stg, RD13_stg, RD12_stg;
reg RD11_stg, RD10_stg, RD9_stg, RD8_stg, RD7_stg;
reg RD6_stg, RD5_stg, RD4_stg, RD3_stg, RD2_stg, RD1_stg, RD0_stg;

`define RDATAP_WIDTH_18 {RDP17, RDP16, RDP15, RDP14, RDP13, RDP12, RDP11, RDP10, RDP9, RDP8, RDP7, RDP6, RDP5, RDP4, RDP3, RDP2, RDP1, RDP0}
`define RWIDTH_CFG_VECTOR {RW2_int, RW1_int, RW0_int}
`define WWIDTH_CFG_VECTOR {WW2_int, WW1_int, WW0_int}
`define AEMPTY_CFG_VECTOR {AEVAL11_int, AEVAL10_int, AEVAL9_int, AEVAL8_int, AEVAL7_int, AEVAL6_int, AEVAL5_int, AEVAL4_int, AEVAL3_int, AEVAL2_int, AEVAL1_int, AEVAL0_int}
`define AFULL_CFG_VECTOR  {AFVAL11_int, AFVAL10_int, AFVAL9_int, AFVAL8_int, AFVAL7_int, AFVAL6_int, AFVAL5_int, AFVAL4_int, AFVAL3_int, AFVAL2_int, AFVAL1_int, AFVAL0_int}

integer MAX_DEPTH;

  
reg [4095:0] MEM;
reg [511 :0] MEM9;

wire WENABLE; 
wire RENABLE;

reg [3:0] mask;
reg RCLK_prev, WCLK_prev;  
reg RBLK_lastvalue = 1, RBLK_hold = 1;
reg WBLK_lastvalue = 1, WBLK_hold=1;
reg REN_lastvalue = 0, REN_hold=0;
reg WEN_lastvalue = 1, WEN_hold=1;
reg issue_WEN = 0;
reg issue_WBLK = 0;
reg issue_RBLK = 0;
reg issue_REN = 0; 
reg issue_afval = 0;
reg issue_aeval = 0;
reg [11:0] AFVAL_lastvalue = 0;
reg [11:0] AEVAL_lastvalue = 0;
reg [11:0] AFVAL_hold = 0;
reg [11:0] AEVAL_hold = 0;  
reg xor_aeval, xor_afval;
  
buf AFU0  (AFVAL0_int,  AFVAL0);
buf AFU1  (AFVAL1_int,  AFVAL1);
buf AFU2  (AFVAL2_int,  AFVAL2);
buf AFU3  (AFVAL3_int,  AFVAL3);
buf AFU4  (AFVAL4_int,  AFVAL4);
buf AFU5  (AFVAL5_int,  AFVAL5);
buf AFU6  (AFVAL6_int,  AFVAL6);
buf AFU7  (AFVAL7_int,  AFVAL7);
buf AFU8  (AFVAL8_int,  AFVAL8);
buf AFU9  (AFVAL9_int,  AFVAL9);
buf AFU10 (AFVAL10_int, AFVAL10);
buf AFU11 (AFVAL11_int, AFVAL11);

buf AEU0  (AEVAL0_int,  AEVAL0);
buf AEU1  (AEVAL1_int,  AEVAL1);
buf AEU2  (AEVAL2_int,  AEVAL2);
buf AEU3  (AEVAL3_int,  AEVAL3);
buf AEU4  (AEVAL4_int,  AEVAL4);
buf AEU5  (AEVAL5_int,  AEVAL5);
buf AEU6  (AEVAL6_int,  AEVAL6);
buf AEU7  (AEVAL7_int,  AEVAL7);
buf AEU8  (AEVAL8_int,  AEVAL8);
buf AEU9  (AEVAL9_int,  AEVAL9);
buf AEU10 (AEVAL10_int, AEVAL10);
buf AEU11 (AEVAL11_int, AEVAL11);

buf WDU0  (WD0_int,     WD0);
buf WDU1  (WD1_int,     WD1);
buf WDU2  (WD2_int,     WD2);
buf WDU3  (WD3_int,     WD3);
buf WDU4  (WD4_int,     WD4);
buf WDU5  (WD5_int,     WD5);
buf WDU6  (WD6_int,     WD6);
buf WDU7  (WD7_int,     WD7);
buf WDU8  (WD8_int,     WD8);
buf WDU9  (WD9_int,     WD9);
buf WDU10 (WD10_int,    WD10);
buf WDU11 (WD11_int,    WD11);
buf WDU12 (WD12_int,    WD12);
buf WDU13 (WD13_int,    WD13);
buf WDU14 (WD14_int,    WD14);
buf WDU15 (WD15_int,    WD15);
buf WDU16 (WD16_int,    WD16);
buf WDU17 (WD17_int,    WD17);

buf WWU2  (WW2_int,     WW2);
buf WWU1  (WW1_int,     WW1);
buf WWU0  (WW0_int,     WW0);

buf RWU2  (RW2_int,     RW2);
buf RWU1  (RW1_int,     RW1);
buf RWU0  (RW0_int,     RW0);

buf RENU  (REN_int,     REN);
buf WENU  (WEN_int,     WEN);
buf RBLKU (RBLK_int,    RBLK);
buf WBLKU (WBLK_int,    WBLK);

buf WCLKU (WCLK_int,    WCLK);
buf RCLKU (RCLK_int,    RCLK);

buf RESETU (RESET_int,  RESET);
buf ESTOPU (ESTOP_int,  ESTOP);
buf FSTOPU (FSTOP_int,  FSTOP);
buf RPIPEU (RPIPE_int,  RPIPE);


pmos RDU0  (RD0,  RDP0,  0);
pmos RDU1  (RD1,  RDP1,  0);
pmos RDU2  (RD2,  RDP2,  0);
pmos RDU3  (RD3,  RDP3,  0);
pmos RDU4  (RD4,  RDP4,  0);
pmos RDU5  (RD5,  RDP5,  0);
pmos RDU6  (RD6,  RDP6,  0);
pmos RDU7  (RD7,  RDP7,  0);
pmos RDU8  (RD8,  RDP8,  0);
pmos RDU9  (RD9,  RDP9,  0);
pmos RDU10 (RD10, RDP10, 0);
pmos RDU11 (RD11, RDP11, 0);
pmos RDU12 (RD12, RDP12, 0);
pmos RDU13 (RD13, RDP13, 0);
pmos RDU14 (RD14, RDP14, 0);
pmos RDU15 (RD15, RDP15, 0);
pmos RDU16 (RD16, RDP16, 0);
pmos RDU17 (RD17, RDP17, 0);

pmos AEMPTYU (AEMPTY, AEMPTYP, 0);
pmos EMPTYU  (EMPTY,  EMPTYP,  0);
pmos AFULLU  (AFULL,  AFULLP,  0);
pmos FULLU   (FULL,   FULLP,   0);

integer MAX_ADDR;
integer WADDR;
integer WADDR_P1;
integer WADDR_P2;
integer RADDR;
integer RADDR_P1;
integer RADDR_P2;
integer BIT_WADDR;
integer BIT_RADDR;
integer WADDR_wrap;
integer WADDR_wrap_P1;
integer WADDR_wrap_P2;
integer RADDR_wrap;
integer RADDR_wrap_P1;
integer RADDR_wrap_P2;

integer AEVAL;
integer AFVAL;

integer wdepth;
integer rdepth;


assign WENABLE = RESET_int & ~WEN_int & ~WBLK_int; 
assign RENABLE = RESET_int &  REN_int & ~RBLK_int; 

  always @(WCLK_int or RESET_int)
      begin
	  if (WCLK_int === 1'bx && RESET_int == 1 ) begin
	      $display("Warning : WCLK went unknown at time %0.1f\n", $realtime);
	  end
      end

  always @(RCLK_int or RESET_int or RENABLE)
      begin
	  if (RCLK_int === 1'bx && RESET_int == 1 ) begin
	      $display("Warning : RCLK went unknown at time %0.1f\n", $realtime);
	      if (RENABLE == 1'b1) begin
		  `RDATAP_WIDTH_18 <= 18'bx;
	      end // if (RENABLE == 1'b1)
	  end 
      end 
    
always @(WCLK_int)
    begin
	WCLK_prev <= WCLK_int;
    end 
  
always @(RCLK_int)
    begin
	RCLK_prev <= RCLK_int;
    end 

  always @(RBLK_int)
      begin
	  RBLK_hold <=  RBLK_int;
	  RBLK_lastvalue <= RBLK_hold;
      end 

 always @(REN_int)
      begin
	  REN_hold <=  REN_int;
	  REN_lastvalue <= REN_hold;
      end  

  always @(WBLK_int)
      begin
	  WBLK_lastvalue <= WBLK_hold;	  
	  WBLK_hold <=  WBLK_int;
      end 
 
 always @(WEN_int)
      begin
	  WEN_hold <=  WEN_int;
	  WEN_lastvalue <= WEN_hold;
      end 

 always @(`AFULL_CFG_VECTOR)
      begin
	  AFVAL_hold <=  `AFULL_CFG_VECTOR;
	  AFVAL_lastvalue <= AFVAL_hold;
      end       

always @(`AEMPTY_CFG_VECTOR)
      begin
	  AEVAL_hold <=  `AEMPTY_CFG_VECTOR;
	  AEVAL_lastvalue <= AEVAL_hold;
      end       
  
// FIFO RESET behavior section

always @(RESET_int) begin
  if (RESET_int == 1'b0) begin
    WADDR         <= 0;
    WADDR_P1      <= 0;
    WADDR_P2      <= 0;
    WADDR_wrap    <= 0;
    WADDR_wrap_P1 <= 0;
    WADDR_wrap_P2 <= 0;
    RADDR         <= 0;
    RADDR_P1      <= 0;
    RADDR_P2      <= 0;
    RADDR_wrap    <= 0;
    RADDR_wrap_P1 <= 1;
    RADDR_wrap_P2 <= 1;
    FULLP         <= 1'b0;
    EMPTYP        <= 1'b1;
    AFULLP        <= 1'b0;
    AEMPTYP       <= 1'b1;
    `RDATAP_WIDTH_18 <= 18'b0;
    RD0_stg       <= 1'b0;
    RD1_stg       <= 1'b0;
    RD2_stg       <= 1'b0;
    RD3_stg       <= 1'b0;
    RD4_stg       <= 1'b0;
    RD5_stg       <= 1'b0;
    RD6_stg       <= 1'b0;
    RD7_stg       <= 1'b0;
    RD8_stg       <= 1'b0;
    RD9_stg       <= 1'b0;
    RD10_stg      <= 1'b0;
    RD11_stg      <= 1'b0;
    RD12_stg      <= 1'b0;
    RD13_stg      <= 1'b0;
    RD14_stg      <= 1'b0;
    RD15_stg      <= 1'b0;
    RD16_stg      <= 1'b0;
    RD17_stg      <= 1'b0;
      
  end else if (RESET_int === 1'bx) begin
      if ($time > 0) begin
	  $display("Warning : RESET went unknown at time %0.1f\n", $realtime);
      end
  end
end

  // FIFO WRITE behavior section

always @(posedge WCLK_int ) begin
  if (RESET_int == 1'b1 && WCLK_prev == 1'b0 && WCLK_int == 1'b1 ) begin
    // Synchronizer needs two WCLKs to generate empty flag
      RADDR_P2 = RADDR_P1;
      RADDR_P1 = RADDR;
      RADDR_wrap_P2 = RADDR_wrap_P1;
 if (RADDR_wrap == 0) 
      RADDR_wrap_P1 = 1;
    else
      RADDR_wrap_P1 = 0;

    if ((WBLK_int == 1'b0) && (WEN_int == 1'b0)) begin
      if ( ! ((FULLP == 1'b1) && (FSTOP_int == 1'b1))) begin
        case (`WWIDTH_CFG_VECTOR)
          3'b000 : begin
            MEM[WADDR] <= WD0_int;
            wdepth = 4096;
            if (WADDR < wdepth - 1 ) begin
              WADDR = #0 WADDR + 1;
            end else begin
              WADDR = #0 0;
              WADDR_wrap = 1 - WADDR_wrap;
            end
          end
          3'b001 : begin
            MEM[(WADDR * 2) + 0] <= WD0_int;
            MEM[(WADDR * 2) + 1] <= WD1_int;
            wdepth = 2048;
            if (WADDR < wdepth - 1 ) begin
              WADDR = #0 WADDR + 1;
            end else begin
              WADDR = #0 0;
              WADDR_wrap = 1 - WADDR_wrap;
            end
          end
          3'b010 : begin
            MEM[(WADDR * 4) + 0] <= WD0_int;
            MEM[(WADDR * 4) + 1] <= WD1_int;
            MEM[(WADDR * 4) + 2] <= WD2_int;
            MEM[(WADDR * 4) + 3] <= WD3_int;
            wdepth = 1024; 
            if (WADDR < wdepth - 1 ) begin
              WADDR = #0 WADDR + 1;
            end else begin
              WADDR = #0 0;
              WADDR_wrap = 1 - WADDR_wrap;
            end
          end
          3'b011 : begin
            MEM[(WADDR * 8) + 0] <= WD0_int;
            MEM[(WADDR * 8) + 1] <= WD1_int;
            MEM[(WADDR * 8) + 2] <= WD2_int;
            MEM[(WADDR * 8) + 3] <= WD3_int;
            MEM[(WADDR * 8) + 4] <= WD4_int;
            MEM[(WADDR * 8) + 5] <= WD5_int;
            MEM[(WADDR * 8) + 6] <= WD6_int;
            MEM[(WADDR * 8) + 7] <= WD7_int;
            MEM9[WADDR] = WD8_int;
            wdepth = 512; 
            if (WADDR < wdepth - 1 ) begin
              WADDR = #0 WADDR + 1;
            end else begin
              WADDR = #0 0;
              WADDR_wrap = 1 - WADDR_wrap;
		
            end
          end
          3'b100 : begin
            MEM[(WADDR * 16) + 0] <= WD0_int;
            MEM[(WADDR * 16) + 1] <= WD1_int;
            MEM[(WADDR * 16) + 2] <= WD2_int;
            MEM[(WADDR * 16) + 3] <= WD3_int;
            MEM[(WADDR * 16) + 4] <= WD4_int;
            MEM[(WADDR * 16) + 5] <= WD5_int;
            MEM[(WADDR * 16) + 6] <= WD6_int;
            MEM[(WADDR * 16) + 7] <= WD7_int;
            MEM9[WADDR *   2 + 0] <= WD8_int;
            MEM[(WADDR * 16) + 8] <= WD9_int;
            MEM[(WADDR * 16) + 9] <= WD10_int;
            MEM[(WADDR * 16) + 10] <= WD11_int;
            MEM[(WADDR * 16) + 11] <= WD12_int;
            MEM[(WADDR * 16) + 12] <= WD13_int;
            MEM[(WADDR * 16) + 13] <= WD14_int;
            MEM[(WADDR * 16) + 14] <= WD15_int;
            MEM[(WADDR * 16) + 15] <= WD16_int;
            MEM9[WADDR * 2 + 1] <= WD17_int;
            wdepth = 256; 
            if (WADDR < wdepth - 1 ) begin
              WADDR = #0 WADDR + 1;
            end else begin
              WADDR = #0 0;
              WADDR_wrap = 1 - WADDR_wrap;
            end
          end
          default: begin
	      $display("Warning: Illegal Write port width configuration");
          end
	endcase
      end // not (FULL and FSTOP)
	else if(FSTOP === 1'bx)
	    begin
		$display("Warning : FSTOP is unknown");
		$display("When FULL, to stop writing set FSTOP = 1, to overwrite set FSTOP= 0");
		$display("Time : %0.1fns Instance : %m",$realtime);
	    end 
	
    end // WBLK = 0 and WEN = 0
      else begin
	  if (WBLK_int === 1'bx &&  issue_WBLK == 0 && (WEN_int ==0 ||
							WEN_int === 1'bx))
	      begin
		  if ( WBLK_lastvalue !== 1'bx)
		      begin
			  $display("Warning : WBLK signal is unknown");
			  $display("Time : %0.1fns Instance : %m",$realtime);
			  issue_WBLK = 1;
		      end 
	      end 
	  else if(WBLK_int !== 1'bx)
	      issue_WBLK = 0;
	  
	  if (WEN_int === 1'bx && issue_WEN == 0 && (WBLK_int == 0 ||
						     WBLK_int === 1'bx))
	      begin
		  if ( WEN_lastvalue !== 1'bx)
		      begin	      
			  $display("Warning : WEN signal is unknown");
			  $display("Time : %0.1fns Instance : %m",$realtime);
			  issue_WEN = 1;
		      end // if ( WEN_lastvalue !== 1'bx)
	      end // if (WEN_int === 1'bx && issue_WEN == 0)
	  else if(WEN_int !== 1'bx)
	      issue_WEN = 0;
	  
      end 

      fifo_flags(`AFULL_CFG_VECTOR, `AEMPTY_CFG_VECTOR, `RWIDTH_CFG_VECTOR,
		 `WWIDTH_CFG_VECTOR);

      mask = get_mask(`RWIDTH_CFG_VECTOR,`WWIDTH_CFG_VECTOR);
      xor_afval = ^ (`AFULL_CFG_VECTOR & {8'hff,mask});
      if ( xor_afval !== 1'bx)
	  issue_afval = 0;
      else if ( xor_afval === 1'bx && issue_afval == 0)
	  begin
	      $display("Warning : Invalid AFVAL %b",`AFULL_CFG_VECTOR);
	      $display("Holding the value of AFULL FLAG ");
	      $display("Time : %0.1fns Instance : %m",$realtime);
	      issue_afval = 1;	  
	  end 

  end // if RESET deasserted
end  // Write section

  // FIFO READ behavior section

  always @(posedge RCLK_int) begin
      if (RESET_int == 1'b1  && RCLK_prev == 1'b0 && RCLK_int == 1'b1) begin
    // Synchronizer needs two RCLKs to generate empty flag
      WADDR_P2 = WADDR_P1;
      WADDR_P1 = WADDR;
      WADDR_wrap_P2 = WADDR_wrap_P1;
      WADDR_wrap_P1 = WADDR_wrap;
 
    if (RPIPE_int == 1'b1) begin // Pipelining on
      RDP0  <= RD0_stg;
      RDP1  <= RD1_stg;
      RDP2  <= RD2_stg;
      RDP3  <= RD3_stg;
      RDP4  <= RD4_stg;
      RDP5  <= RD5_stg;
      RDP6  <= RD6_stg;
      RDP7  <= RD7_stg;
      RDP8  <= RD8_stg;
      RDP9  <= RD9_stg;
      RDP10 <= RD10_stg;
      RDP11 <= RD11_stg;
      RDP12 <= RD12_stg;
      RDP13 <= RD13_stg;
      RDP14 <= RD14_stg;
      RDP15 <= RD15_stg;
      RDP16 <= RD16_stg;
      RDP17 <= RD17_stg;
    end
    else if (RPIPE_int === 1'bx ) begin // RPIPE unknown
      $display("Warning : RPIPE signal unknown.");

      RDP0  <= 1'bx;
      RDP1  <= 1'bx;
      RDP2  <= 1'bx;
      RDP3  <= 1'bx;
      RDP4  <= 1'bx;
      RDP5  <= 1'bx;
      RDP6  <= 1'bx;
      RDP7  <= 1'bx;
      RDP8  <= 1'bx;
      RDP9  <= 1'bx;
      RDP10 <= 1'bx;
      RDP11 <= 1'bx;
      RDP12 <= 1'bx;
      RDP13 <= 1'bx;
      RDP14 <= 1'bx;
      RDP15 <= 1'bx;
      RDP16 <= 1'bx;
      RDP17 <= 1'bx;
    end

    if ((RBLK_int == 1'b0) && (REN_int == 1'b1)) begin
      if ( ! ((EMPTYP == 1'b1) && (ESTOP_int == 1'b1))) begin // OK to Read
        if (RPIPE_int == 1'b0) begin // Pipelining off 
          case (`RWIDTH_CFG_VECTOR)
            3'b000 : begin
              RDP0  <= MEM[RADDR];
              rdepth = 4096;
              if (RADDR < rdepth - 1) begin
                RADDR = #0 RADDR + 1;
              end else begin
                RADDR = #0 0;
                RADDR_wrap = 1 - RADDR_wrap;
              end
            end
            3'b001 : begin
              RDP0  <= MEM[(RADDR * 2) + 0];
              RDP1  <= MEM[(RADDR * 2) + 1];
              rdepth = 2048;
              if (RADDR < rdepth - 1) begin
                RADDR = #0 RADDR + 1;
              end else begin
                RADDR = #0 0;
                RADDR_wrap = 1 - RADDR_wrap;
              end
            end
            3'b010 : begin
              RDP0  <= MEM[(RADDR * 4) + 0];
              RDP1  <= MEM[(RADDR * 4) + 1];
              RDP2  <= MEM[(RADDR * 4) + 2];
              RDP3  <= MEM[(RADDR * 4) + 3];
              rdepth = 1024;
              if (RADDR < rdepth - 1) begin
                RADDR = #0 RADDR + 1;
              end else begin
                RADDR = #0 0;
                RADDR_wrap = 1 - RADDR_wrap;
              end
            end
            3'b011 : begin
              RDP0  <= MEM[(RADDR * 8) + 0];
              RDP1  <= MEM[(RADDR * 8) + 1];
              RDP2  <= MEM[(RADDR * 8) + 2];
              RDP3  <= MEM[(RADDR * 8) + 3];
              RDP4  <= MEM[(RADDR * 8) + 4];
              RDP5  <= MEM[(RADDR * 8) + 5];
              RDP6  <= MEM[(RADDR * 8) + 6];
              RDP7  <= MEM[(RADDR * 8) + 7];
              RDP8  <= MEM9[RADDR];
              rdepth = 512;
              if (RADDR < rdepth - 1) begin
                RADDR = #0 RADDR + 1;
              end else begin
                RADDR = #0 0;
                RADDR_wrap = 1 - RADDR_wrap;
              end
            end
            3'b100 : begin
              RDP0  <= MEM[(RADDR * 16) + 0];
              RDP1  <= MEM[(RADDR * 16) + 1];
              RDP2  <= MEM[(RADDR * 16) + 2];
              RDP3  <= MEM[(RADDR * 16) + 3];
              RDP4  <= MEM[(RADDR * 16) + 4];
              RDP5  <= MEM[(RADDR * 16) + 5];
              RDP6  <= MEM[(RADDR * 16) + 6];
              RDP7  <= MEM[(RADDR * 16) + 7];
              RDP8  <= MEM9[RADDR*2 +0];
              RDP9  <= MEM[(RADDR * 16) + 8];
              RDP10 <= MEM[(RADDR * 16) + 9];
              RDP11 <= MEM[(RADDR * 16) + 10];
              RDP12 <= MEM[(RADDR * 16) + 11];
              RDP13 <= MEM[(RADDR * 16) + 12];
              RDP14 <= MEM[(RADDR * 16) + 13];
              RDP15 <= MEM[(RADDR * 16) + 14];
              RDP16 <= MEM[(RADDR * 16) + 15];
              RDP17 <= MEM9[RADDR * 2 + 1];
              rdepth = 256;
              if (RADDR < rdepth - 1) begin
                RADDR = #0 RADDR + 1;
              end else begin
                RADDR = #0 0;
                RADDR_wrap = 1 - RADDR_wrap;
              end
            end
            default: begin
              $display("Warning: Illegal Read port width configuration");
            end
          endcase
        end else if (RPIPE_int == 1'b1) begin // Pipelining on
          case (`RWIDTH_CFG_VECTOR)
            3'b000 : begin
              RD0_stg  <= MEM[RADDR];
              rdepth = 4096;
              if (RADDR < rdepth - 1) begin
                RADDR = #0 RADDR + 1;
              end else begin
                RADDR = #0 0;
                RADDR_wrap = 1 - RADDR_wrap;
              end
            end
            3'b001 : begin
              RD0_stg  <= MEM[(RADDR * 2) + 0];
              RD1_stg  <= MEM[(RADDR * 2) + 1];
              rdepth = 2048;
              if (RADDR < rdepth - 1) begin
                RADDR = #0 RADDR + 1;
              end else begin
                RADDR = #0 0;
                RADDR_wrap = 1 - RADDR_wrap;
              end
            end
            3'b010 : begin
              RD0_stg  <= MEM[(RADDR * 4) + 0];
              RD1_stg  <= MEM[(RADDR * 4) + 1];
              RD2_stg  <= MEM[(RADDR * 4) + 2];
              RD3_stg  <= MEM[(RADDR * 4) + 3];
              rdepth = 1024;
              if (RADDR < rdepth - 1) begin
                RADDR = #0 RADDR + 1;
              end else begin
                RADDR = #0 0;
                RADDR_wrap = 1 - RADDR_wrap;
              end
            end
            3'b011 : begin
              RD0_stg  <= MEM[(RADDR * 8) + 0];
              RD1_stg  <= MEM[(RADDR * 8) + 1];
              RD2_stg  <= MEM[(RADDR * 8) + 2];
              RD3_stg  <= MEM[(RADDR * 8) + 3];
              RD4_stg  <= MEM[(RADDR * 8) + 4];
              RD5_stg  <= MEM[(RADDR * 8) + 5];
              RD6_stg  <= MEM[(RADDR * 8) + 6];
              RD7_stg  <= MEM[(RADDR * 8) + 7];
              RD8_stg  <= MEM9[RADDR];
              rdepth = 512;
              if (RADDR < rdepth - 1) begin
                RADDR = #0 RADDR + 1;
              end else begin
                RADDR = #0 0;
                RADDR_wrap = 1 - RADDR_wrap;
              end
            end
            3'b100 : begin
              RD0_stg  <= MEM[(RADDR * 16) + 0];
              RD1_stg  <= MEM[(RADDR * 16) + 1];
              RD2_stg  <= MEM[(RADDR * 16) + 2];
              RD3_stg  <= MEM[(RADDR * 16) + 3];
              RD4_stg  <= MEM[(RADDR * 16) + 4];
              RD5_stg  <= MEM[(RADDR * 16) + 5];
              RD6_stg  <= MEM[(RADDR * 16) + 6];
              RD7_stg  <= MEM[(RADDR * 16) + 7];
              RD8_stg  <= MEM9[RADDR*2 +0];
              RD9_stg  <= MEM[(RADDR * 16) + 8];
              RD10_stg <= MEM[(RADDR * 16) + 9];
              RD11_stg <= MEM[(RADDR * 16) + 10];
              RD12_stg <= MEM[(RADDR * 16) + 11];
              RD13_stg <= MEM[(RADDR * 16) + 12];
              RD14_stg <= MEM[(RADDR * 16) + 13];
              RD15_stg <= MEM[(RADDR * 16) + 14];
              RD16_stg <= MEM[(RADDR * 16) + 15];
              RD17_stg <= MEM9[RADDR * 2 + 1];
              rdepth = 256;
              if (RADDR < rdepth - 1) begin
                RADDR = #0 RADDR + 1;
              end else begin
                RADDR = #0 0;
                RADDR_wrap = 1 - RADDR_wrap;
              end
            end
            default: begin
              $display("Warning: Illegal Read port width configuration");
            end
          endcase
        end // RPIPE == 1
      end // if (EMPTY and ESTOP)
	else if (ESTOP === 1'bx )
	    begin
		$display("Warning : ESTOP is unknown");
		$display("When FIFO is EMPTY, to stop reading ESTOP=1 or to continue reading old data ESTOP=0");
		$display("Time : %0.1fns Instance : %m",$realtime);
	    end 
    end // if REN = 1 and RBLK = 0

      else begin
	  if (RBLK_int === 1'bx &&  issue_RBLK == 0 && (REN_int == 1 ||
							REN_int === 1'bx) )
	      begin
		  if ( RBLK_lastvalue !== 1'bx)
		      begin
			  $display("Warning : RBLK signal is unknown");
			  $display("Time : %0.1fns Instance : %m",$realtime);
			  issue_RBLK = 1;
		      end 
	      end 
	  else if(RBLK_int !== 1'bx)
	      issue_RBLK = 0;
	  
	  if (REN_int === 1'bx && issue_REN == 0 && (RBLK_int == 0 ||
						     RBLK_int === 1'bx))
	      begin
		  if ( REN_lastvalue !== 1'bx)
		      begin	      
			  $display("Warning : REN signal is unknown");
			  $display("Time : %0.1fns Instance : %m",$realtime);
			  issue_REN = 1;
		      end 
	      end 
	  else if (REN_int !== 1'bx )
	      issue_REN = 0;
      end 
      
	  fifo_flags(`AFULL_CFG_VECTOR, `AEMPTY_CFG_VECTOR,
		     `RWIDTH_CFG_VECTOR, `WWIDTH_CFG_VECTOR);
	  mask = get_mask(`RWIDTH_CFG_VECTOR,`WWIDTH_CFG_VECTOR);
	  xor_aeval = ^ (`AFULL_CFG_VECTOR & {8'hff,mask});
	  if ( xor_aeval !== 1'bx)
	      issue_aeval = 0;
	  else if ( xor_aeval === 1'bx && issue_aeval == 0)
	      begin
		  $display("Warning : Invalid AEVAL %b",`AEMPTY_CFG_VECTOR);
		  $display("Holding the value of AEMPTY FLAG ");
		  $display("Time : %0.1fns Instance : %m",$realtime);
		  issue_aeval = 1;	  
	      end 
      end // if RESET deasserted
  end // Read section
  
function integer get_rel_value;
   input [11:0] addr_signal;
   input [3:0] 	mask;
   integer 	value;
    begin
	value =  addr_signal[11] * 2048 + addr_signal[10] * 1024 
		 + addr_signal[9] *  512  + addr_signal[8]  * 256
		 + addr_signal[7] *  128  + addr_signal[6]  * 64 
		 + addr_signal[5] *  32   + addr_signal[4]  * 16
		 + (addr_signal[3] & mask[3]) * 8
		 + (addr_signal[2] & mask[2]) * 4 
		 + (addr_signal[1] & mask[1]) * 2
		 + (addr_signal[0] & mask[0]) * 1;
	
	get_rel_value = value / (16-mask);
    end
endfunction

function [3:0] get_mask;
     input [2:0] rw;
     input [2:0] ww;
     reg [3:0] 	 rmask,wmask;
      begin
	  rmask = 4'b1111 << rw;
	  wmask = 4'b1111 << ww;
	  get_mask = rmask & wmask;
      end
endfunction // get_mask
  
task fifo_flags;

  input [11:0] afval_cfg_bus;
  input [11:0] aeval_cfg_bus;
  input [2:0]  rwidth_cfg_bus; 
  input [2:0]  wwidth_cfg_bus;

  integer raddr_rel;
  integer raddr_rel_p2;
  integer waddr_rel;
  integer waddr_rel_p2;    
  integer afval_rel, aeval_rel;    
  integer rel_depth;
   integer num_fifo_entries;
 
    begin
	if (^(wwidth_cfg_bus) === 1'bx || (wwidth_cfg_bus > 4))
	    begin
		$display("Warning: Illegal Write port width configuration");
	    end
	else if (^(rwidth_cfg_bus) === 1'bx || (rwidth_cfg_bus > 4))
	    begin
		$display("Warning: Illegal Read port width configuration");
	    end	    
	else if (wwidth_cfg_bus >= rwidth_cfg_bus)
	    begin
		
		raddr_rel = RADDR >> (wwidth_cfg_bus - rwidth_cfg_bus);
		raddr_rel_p2 = RADDR_P2 >> (wwidth_cfg_bus - rwidth_cfg_bus);
		waddr_rel = WADDR;
		waddr_rel_p2 = WADDR_P2;
		rel_depth = 1 << (12 - wwidth_cfg_bus);
	    end 
	else
	    begin
		waddr_rel = WADDR >> (rwidth_cfg_bus - wwidth_cfg_bus);
		waddr_rel_p2 = WADDR_P2 >> (rwidth_cfg_bus - wwidth_cfg_bus);
		raddr_rel = RADDR;
		raddr_rel_p2 = RADDR_P2;
		rel_depth = 1 << (12 - rwidth_cfg_bus);
	    end 

      aeval_rel = get_rel_value(aeval_cfg_bus, get_mask(rwidth_cfg_bus, wwidth_cfg_bus));
      afval_rel = get_rel_value(afval_cfg_bus, get_mask(rwidth_cfg_bus, wwidth_cfg_bus));
 
    // Pipelined addresses used for FULL and EMPTY calculations

	if ((WADDR_wrap == RADDR_wrap_P2) && (waddr_rel == raddr_rel_p2))
	    FULLP = 1'b1;
	else
	    FULLP = 1'b0;

	if ((RADDR_wrap == WADDR_wrap_P2) && (waddr_rel_p2 == raddr_rel))
	    EMPTYP = 1'b1;
	else
	    EMPTYP = 1'b0;

	//Number of FIFO ENTRIES	
	if (waddr_rel >= raddr_rel)
	    num_fifo_entries = waddr_rel - raddr_rel;
	else
	    num_fifo_entries = rel_depth + waddr_rel - raddr_rel;
	//aempty, afull generation
	if (FULLP == 1'b1)
	    AEMPTYP = 1'b0;
	else
	    begin
		if (num_fifo_entries > aeval_rel) 
		    AEMPTYP = 1'b0;
		else if (num_fifo_entries <= aeval_rel)
		    AEMPTYP = 1'b1;
	    end 

	if (EMPTYP == 1'b1) 
	    AFULLP = 1'b0;
	else if (FULLP == 1'b1) 
	    AFULLP = 1'b1;
	else
	    begin
		if (num_fifo_entries < afval_rel) 
		    AFULLP = 1'b0;
		else if (num_fifo_entries >= afval_rel)  
		    AFULLP = 1'b1;
	    end
    end
endtask
 
specify

      specparam   LibName     = "proasic3";
      
      (posedge RCLK => (RD0+:RD0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD1+:RD1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD2+:RD2) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD3+:RD3) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD4+:RD4) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD5+:RD5) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD6+:RD6) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD7+:RD7) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD8+:RD8) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD9+:RD9) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD10+:RD10) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD11+:RD11) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD12+:RD12) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD13+:RD13) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD14+:RD14) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD15+:RD15) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD16+:RD16) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD17+:RD17) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge RCLK => (EMPTY +: 1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      if (AEMPTYP)
      (posedge RCLK => (AEMPTY+: 1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      if (!AFULLP)
      (posedge RCLK => (AFULL +: 1'b0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      if (!AEMPTYP)
      (posedge WCLK => (AEMPTY+: 1'b0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      if (AFULLP)
      (posedge WCLK => (AFULL +: 1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge WCLK => (FULL  +: 1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (negedge RESET => (RD0+:RD0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD1+:RD1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD2+:RD2) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD3+:RD3) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD4+:RD4) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD5+:RD5) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD6+:RD6) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD7+:RD7) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD8+:RD8) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD9+:RD9) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD10+:RD10) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD11+:RD11) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD12+:RD12) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD13+:RD13) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD14+:RD14) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD15+:RD15) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD16+:RD16) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (RD17+:RD17) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (negedge RESET => (EMPTY +: 1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (AEMPTY+: 1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (FULL  +: 1'b0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge RESET => (AFULL +: 1'b0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      $setup(posedge WD17, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD17, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD17, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD17, 0.0, NOTIFY_REG);
      $setup(posedge WD16, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD16, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD16, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD16, 0.0, NOTIFY_REG);
      $setup(posedge WD15, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD15, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD15, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD15, 0.0, NOTIFY_REG);
      $setup(posedge WD14, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD14, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD14, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD14, 0.0, NOTIFY_REG);
      $setup(posedge WD13, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD13, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD13, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD13, 0.0, NOTIFY_REG);
      $setup(posedge WD12, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD12, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD12, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD12, 0.0, NOTIFY_REG);
      $setup(posedge WD11, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD11, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD11, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD11, 0.0, NOTIFY_REG);
      $setup(posedge WD10, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD10, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD10, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD10, 0.0, NOTIFY_REG);
      $setup(posedge WD9, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD9, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD9, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD9, 0.0, NOTIFY_REG);

      $setup(posedge WD8, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD8, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD8, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD8, 0.0, NOTIFY_REG);
      $setup(posedge WD7, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD7, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD7, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD7, 0.0, NOTIFY_REG);
      $setup(posedge WD6, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD6, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD6, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD6, 0.0, NOTIFY_REG);
      $setup(posedge WD5, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD5, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD5, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD5, 0.0, NOTIFY_REG);
      $setup(posedge WD4, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD4, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD4, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD4, 0.0, NOTIFY_REG);
      $setup(posedge WD3, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD3, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD3, 0.0, NOTIFY_REG);
      $setup(posedge WD2, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD2, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD2, 0.0, NOTIFY_REG);
      $setup(posedge WD1, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD1, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD1, 0.0, NOTIFY_REG);
      $setup(posedge WD0, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $setup(negedge WD0, posedge WCLK &&& WENABLE, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, posedge WD0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WENABLE, negedge WD0, 0.0, NOTIFY_REG);

      $setup(posedge WEN, posedge WCLK &&& RESET, 0.0, NOTIFY_REG);
      $setup(negedge WEN, posedge WCLK &&& RESET, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& RESET, posedge WEN, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& RESET, negedge WEN, 0.0, NOTIFY_REG);
      $setup(posedge WBLK, posedge WCLK &&& RESET, 0.0, NOTIFY_REG);
      $setup(negedge WBLK, posedge WCLK &&& RESET, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& RESET, posedge WBLK, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& RESET, negedge WBLK, 0.0, NOTIFY_REG);

      $setup(posedge FSTOP, posedge WCLK, 0.0, NOTIFY_REG);
      $setup(negedge FSTOP, posedge WCLK, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, posedge FSTOP, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, negedge FSTOP, 0.0, NOTIFY_REG);

      $setup(posedge WW2, posedge WCLK, 0.0, NOTIFY_REG);
      $setup(negedge WW2, posedge WCLK, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, posedge WW2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, negedge WW2, 0.0, NOTIFY_REG);
      $setup(posedge WW1, posedge WCLK, 0.0, NOTIFY_REG);
      $setup(negedge WW1, posedge WCLK, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, posedge WW1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, negedge WW1, 0.0, NOTIFY_REG);
      $setup(posedge WW0, posedge WCLK, 0.0, NOTIFY_REG);
      $setup(negedge WW0, posedge WCLK, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, posedge WW0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, negedge WW0, 0.0, NOTIFY_REG);

      $setup(posedge REN, posedge RCLK &&& RESET, 0.0, NOTIFY_REG);
      $setup(negedge REN, posedge RCLK &&& RESET, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RESET, posedge REN, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RESET, negedge REN, 0.0, NOTIFY_REG);
      $setup(posedge RBLK, posedge RCLK &&& RESET, 0.0, NOTIFY_REG);
      $setup(negedge RBLK, posedge RCLK &&& RESET, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RESET, posedge RBLK, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RESET, negedge RBLK, 0.0, NOTIFY_REG);

      $setup(posedge ESTOP, posedge RCLK, 0.0, NOTIFY_REG);
      $setup(negedge ESTOP, posedge RCLK, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, posedge ESTOP, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, negedge ESTOP, 0.0, NOTIFY_REG);

      $setup(posedge RW2, posedge RCLK, 0.0, NOTIFY_REG);
      $setup(negedge RW2, posedge RCLK, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, posedge RW2, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, negedge RW2, 0.0, NOTIFY_REG);
      $setup(posedge RW1, posedge RCLK, 0.0, NOTIFY_REG);
      $setup(negedge RW1, posedge RCLK, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, posedge RW1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, negedge RW1, 0.0, NOTIFY_REG);
      $setup(posedge RW0, posedge RCLK, 0.0, NOTIFY_REG);
      $setup(negedge RW0, posedge RCLK, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, posedge RW0, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, negedge RW0, 0.0, NOTIFY_REG);

      $width(posedge WCLK, 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK, 0.0, 0, NOTIFY_REG);

      $recovery(posedge RESET, posedge WCLK, 0.0, NOTIFY_REG);
      $recovery(posedge RESET, posedge RCLK, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, posedge RESET, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, posedge RESET, 0.0, NOTIFY_REG);

      $width(negedge RESET, 0.0, 0, NOTIFY_REG);

endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults
//---- END MODULE FIFO4K18 ----


/*---------------------------------------------------------------
 CELL NAME : UFROM
-----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module UFROM( ADDR6, ADDR5, ADDR4, ADDR3, ADDR2, ADDR1, ADDR0, CLK,
              DO7, DO6, DO5, DO4, DO3, DO2, DO1, DO0 );

input     ADDR6, ADDR5, ADDR4, ADDR3, ADDR2, ADDR1, ADDR0, CLK;
output    DO7, DO6, DO5, DO4, DO3, DO2, DO1, DO0;

reg [7:0] memory_array [0:127];

wire      ADDR6_int, ADDR5_int, ADDR4_int, ADDR3_int, ADDR2_int, ADDR1_int, ADDR0_int;
reg       DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int;

reg [6:0] ADDR;
reg       addr_is_x;
reg       NOTIFY_REG;

`define   ADDR_BUS    {ADDR6_int, ADDR5_int, ADDR4_int, ADDR3_int, ADDR2_int, ADDR1_int, ADDR0_int}
`define   ROM_DO_BUS  {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}

buf BUF_U0 (ADDR0_int, ADDR0);
buf BUF_U1 (ADDR1_int, ADDR1);
buf BUF_U2 (ADDR2_int, ADDR2);
buf BUF_U3 (ADDR3_int, ADDR3);
buf BUF_U4 (ADDR4_int, ADDR4);
buf BUF_U5 (ADDR5_int, ADDR5);
buf BUF_U6 (ADDR6_int, ADDR6);
buf BUF_U7 (CLK_int, CLK);

buf OUTBUF_U34 (DO0, DO0_int);
buf OUTBUF_U35 (DO1, DO1_int);
buf OUTBUF_U36 (DO2, DO2_int);
buf OUTBUF_U37 (DO3, DO3_int);
buf OUTBUF_U38 (DO4, DO4_int);
buf OUTBUF_U39 (DO5, DO5_int);
buf OUTBUF_U40 (DO6, DO6_int);
buf OUTBUF_U41 (DO7, DO7_int);

parameter MEMORYFILE = "";
parameter DATA_X     = 1;

// Parameter for maintaining programing file info in design flow.
parameter ACT_PROGFILE   = "";

  initial
    begin
      if ( MEMORYFILE != "" )
        $readmemb ( MEMORYFILE, memory_array );
      else
        begin
          $display ( "Error: Module %m, memory initialization file parameter MEMORYFILE not defined" );
          $finish;
        end
    end

  // latch input address on rising edge of CLK_int

  always @( posedge CLK_int )
    begin
      ADDR      = `ADDR_BUS;   
      addr_is_x = address_is_x ( ADDR );
      // users can turn-off data being driven to "X" on posedge CLK_ipd, by setting DATA_X to 0
      if ( DATA_X == 1 )
        `ROM_DO_BUS = 8'bx;
    end

  // updated DO only on the falling edge of CLK

  always @ ( negedge CLK_int )
    begin
      read_memory ( `ROM_DO_BUS, ADDR );
    end

  // task to read the contents of an addressed memory location.

  task  read_memory;

    output   [7:0] data_out;
    input    [6:0] address;
    reg      [7:0] temp_reg;
    reg      [7:0] data_out;

    begin
      if ( addr_is_x == 1'b0)
        begin
          temp_reg = memory_array[address];
          data_out = temp_reg;
        end
      else
        data_out = 8'bx